/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.hints;

import com.intellij.codeInsight.codeVision.CodeVisionRelativeOrdering;
import com.intellij.codeInsight.hints.codeVision.CodeVisionProviderBase;
import com.intellij.codeInsight.hints.codeVision.ReferencesCodeVisionProvider;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.evaluation.JSTypeEvaluationLocationProvider;
import com.intellij.lang.javascript.hints.JSCodeVisionLocationKind;
import com.intellij.lang.javascript.hints.JSCodeVisionLocations;
import com.intellij.lang.javascript.hints.JSCodeVisionUsageCollector;
import com.intellij.lang.javascript.inspections.unusedsymbols.JSSymbolReferenceCache;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.awt.event.MouseEvent;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 !2\u00020\u0001:\u0001!B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016J\"\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0017\u0010\u0017\u001a\t\u0018\u00010\u0015\u00a2\u0006\u0002\b\u00182\u0006\u0010\t\u001a\u00020\nH\u0002R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006\""}, d2={"Lcom/intellij/lang/javascript/hints/JSReferencesCodeVisionProvider;", "Lcom/intellij/codeInsight/hints/codeVision/ReferencesCodeVisionProvider;", "<init>", "()V", "acceptsFile", "", "file", "Lcom/intellij/psi/PsiFile;", "acceptsElement", "element", "Lcom/intellij/psi/PsiElement;", "handleClick", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "event", "Ljava/awt/event/MouseEvent;", "logClickToFUS", "hint", "", "getVisionInfo", "Lcom/intellij/codeInsight/hints/codeVision/CodeVisionProviderBase$CodeVisionInfo;", "getHint", "calculateHint", "Lorg/jetbrains/annotations/Nls;", "relativeOrderings", "", "Lcom/intellij/codeInsight/codeVision/CodeVisionRelativeOrdering;", "getRelativeOrderings", "()Ljava/util/List;", "id", "getId", "()Ljava/lang/String;", "Companion", "intellij.javascript.impl"})
public final class JSReferencesCodeVisionProvider
extends ReferencesCodeVisionProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String ID = "js.references";

    public boolean acceptsFile(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return JSCodeVisionLocations.INSTANCE.acceptsFile(file);
    }

    public boolean acceptsElement(@NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        return JSCodeVisionLocations.INSTANCE.isImportantLocation(element2);
    }

    public void handleClick(@NotNull Editor editor, @NotNull PsiElement element2, @Nullable MouseEvent event) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        super.handleClick(editor, JSCodeVisionLocations.INSTANCE.getNamedElementForLocation(element2), event);
    }

    public void logClickToFUS(@NotNull PsiElement element2, @NotNull String hint2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)hint2, (String)"hint");
        JSCodeVisionLocationKind jSCodeVisionLocationKind = JSCodeVisionLocations.INSTANCE.getLocationKind(element2);
        if (jSCodeVisionLocationKind == null) {
            jSCodeVisionLocationKind = JSCodeVisionLocationKind.OTHER;
        }
        JSCodeVisionLocationKind location = jSCodeVisionLocationKind;
        JSCodeVisionUsageCollector.INSTANCE.getUSAGES_CLICKED_EVENT_ID().log(element2.getProject(), (Object)location);
    }

    @Nullable
    public CodeVisionProviderBase.CodeVisionInfo getVisionInfo(@NotNull PsiElement element2, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return (CodeVisionProviderBase.CodeVisionInfo)JSTypeEvaluationLocationProvider.withTypeEvaluationLocation(element2, () -> JSReferencesCodeVisionProvider.getVisionInfo$lambda$0(this, element2));
    }

    @Nullable
    public String getHint(@NotNull PsiElement element2, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        CodeVisionProviderBase.CodeVisionInfo codeVisionInfo = this.getVisionInfo(element2, file);
        return codeVisionInfo != null ? codeVisionInfo.getText() : null;
    }

    private final CodeVisionProviderBase.CodeVisionInfo calculateHint(PsiElement element2) {
        String string;
        PsiElement adjusted = JSCodeVisionLocations.INSTANCE.getNamedElementForLocation(element2);
        if (!(adjusted instanceof JSNamedElement) && !(adjusted instanceof JSExportAssignment)) {
            return null;
        }
        int referenceLimit = Registry.Companion.intValue("js.code.vision.reference.limit");
        int size = JSSymbolReferenceCache.getReferenceSearcher(adjusted).findReferences(referenceLimit, null).size();
        if (referenceLimit == 1) {
            var7_5 = new Object[]{size};
            string = JavaScriptBundle.message("inlay.hints.max.one.usage.text", var7_5);
        } else {
            var7_5 = new Object[]{size, size >= referenceLimit ? 1 : 0};
            string = JavaScriptBundle.message("inlay.hints.usages.text", var7_5);
        }
        String string2 = string;
        Intrinsics.checkNotNull((Object)string2);
        String message = string2;
        return new CodeVisionProviderBase.CodeVisionInfo(message, Integer.valueOf(size), size < referenceLimit);
    }

    @NotNull
    public List<CodeVisionRelativeOrdering> getRelativeOrderings() {
        return CollectionsKt.emptyList();
    }

    @NotNull
    public String getId() {
        return ID;
    }

    private static final CodeVisionProviderBase.CodeVisionInfo getVisionInfo$lambda$0(JSReferencesCodeVisionProvider this$0, PsiElement $element) {
        return this$0.calculateHint($element);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/lang/javascript/hints/JSReferencesCodeVisionProvider$Companion;", "", "<init>", "()V", "ID", "", "intellij.javascript.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

