/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.index;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSPsiNamedElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSVariableBaseImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.primitives.JSObjectType;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSLocalNamespaceEvaluator {
    @Nullable
    private Set<PsiElement> myVisited;
    private static final Key<CachedValue<Map<JSReferenceExpression, JSNamespace>>> cachedClassExtendingKey = Key.create((String)"cached.class.extending");

    public JSLocalNamespaceEvaluator(@Nullable Set<PsiElement> visited) {
        this.myVisited = visited;
    }

    @Nullable
    public JSNamespace evaluateNamespaceLocally(@Nullable JSExpression expression) {
        JSExpression lOperand;
        JSExpression definitionExpression;
        if (expression instanceof JSReferenceExpression) {
            return this.myVisited == null ? this.evaluateReferenceExpression((JSReferenceExpression)expression) : this.doEvaluateReferenceExpression((JSReferenceExpression)expression);
        }
        if (expression instanceof JSThisExpression) {
            Ref ref2 = Ref.create(null);
            JSNamespace namespace = JSSymbolUtil.evalThis((JSThisExpression)expression, (Ref<JSReferenceExpression>)ref2);
            if (namespace != null) {
                return this.replaceLocalVars(namespace, (JSReferenceExpression)ref2.get());
            }
        } else if (expression instanceof JSNewExpression) {
            JSNamespace innerResult = this.evaluateNamespaceLocally(((JSNewExpression)expression).getMethodExpression());
            if (innerResult != null && innerResult.getJSContext() != JSContext.INSTANCE) {
                return innerResult.copyWithTypeContext(JSTypeContext.INSTANCE);
            }
        } else if (expression instanceof JSCallExpression) {
            JSExpression[] arguments;
            JSExpression methodExpression = ((JSCallExpression)expression).getMethodExpression();
            if (methodExpression instanceof JSReferenceExpression && (JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)methodExpression, "Object", "create") || JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)methodExpression, "Object", "defineProperty") || JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)methodExpression, "Object", "extend")) && (arguments = ((JSCallExpression)expression).getArguments()).length > 0) {
                return this.evaluateNamespaceLocally(arguments[0]);
            }
        } else if (expression instanceof JSAssignmentExpression && (definitionExpression = ((JSAssignmentExpression)expression).getLOperand()) instanceof JSDefinitionExpression && (lOperand = ((JSDefinitionExpression)definitionExpression).getExpression()) != null) {
            return this.evaluateNamespaceLocally(lOperand);
        }
        return null;
    }

    @Nullable
    private JSNamespace evaluateReferenceExpression(@NotNull JSReferenceExpression lOperand) {
        Map cachedMap;
        PsiFile containingFile;
        CachedValue value;
        if (lOperand == null) {
            JSLocalNamespaceEvaluator.$$$reportNull$$$0(0);
        }
        if ((value = (CachedValue)(containingFile = lOperand.getContainingFile()).getUserData(cachedClassExtendingKey)) == null) {
            value = CachedValuesManager.getManager((Project)containingFile.getManager().getProject()).createCachedValue(() -> new CachedValueProvider.Result(Collections.synchronizedMap(new HashMap(100)), new Object[]{containingFile}), false);
            containingFile.putUserData(cachedClassExtendingKey, (Object)value);
        }
        if ((cachedMap = (Map)value.getValue()).containsKey(lOperand)) {
            return (JSNamespace)cachedMap.get(lOperand);
        }
        JSNamespace type2 = this.doEvaluateReferenceExpression(lOperand);
        cachedMap.put(lOperand, type2);
        return type2;
    }

    @Nullable
    private JSNamespace doEvaluateReferenceExpression(@NotNull JSReferenceExpression referenceExpression) {
        JSNamespace ns;
        JSExpression initializer;
        String name;
        JSNamespace predefinedType;
        if (referenceExpression == null) {
            JSLocalNamespaceEvaluator.$$$reportNull$$$0(1);
        }
        if ((predefinedType = JSSymbolUtil.getPredefinedNamespace(referenceExpression)) != null) {
            return predefinedType;
        }
        JSExpression qualifier = referenceExpression.getQualifier();
        if (qualifier != null && JSSymbolUtil.isPrototype(name = referenceExpression.getReferenceName()) && qualifier instanceof JSReferenceExpression) {
            JSNamespace qualifierNs = this.doEvaluateReferenceExpression((JSReferenceExpression)qualifier);
            if (qualifierNs != null) {
                qualifierNs = qualifierNs.copyWithTypeContext(JSTypeContext.PROTOTYPE);
            }
            return qualifierNs;
        }
        Pair<@NotNull JSPsiNamedElementBase, @Nullable JSExpression> pair = JSLocalNamespaceEvaluator.resolveLocallyCompletely(referenceExpression);
        if (pair == null) {
            JSNamespace predefined = JSSymbolUtil.getPredefinedNamespaceForUnresolvedReference(referenceExpression);
            if (predefined != null) {
                return predefined;
            }
            JSNamespace ns2 = JSSymbolUtil.createNamespaceFromReferenceExpression(referenceExpression, JSContext.STATIC, true, true);
            return ns2 != null && referenceExpression.getQualifier() != null ? this.replaceLocalVars(ns2, referenceExpression) : ns2;
        }
        if (this.myVisited == null) {
            this.myVisited = new HashSet<PsiElement>();
        }
        if ((initializer = (JSExpression)pair.second) != null && this.myVisited.add((PsiElement)initializer)) {
            ns = this.evaluateNamespaceLocally(initializer);
            this.myVisited.remove(initializer);
            if (!(ns == null || ns instanceof JSObjectType && ns.getTypeContext() == JSTypeContext.INSTANCE)) {
                return ns;
            }
        }
        if (this.myVisited.add((PsiElement)pair.first)) {
            ns = JSSymbolUtil.buildProvidedNamespace((JSPsiNamedElementBase)pair.first, this.myVisited);
            this.myVisited.remove(pair.first);
            if (ns != null) {
                return ns;
            }
        }
        return null;
    }

    @NotNull
    public static JSElement calcRefExprValue(@NotNull JSReferenceExpression lOperand) {
        Pair<JSPsiNamedElementBase, JSExpression> resolveAndInitializer;
        if (lOperand == null) {
            JSLocalNamespaceEvaluator.$$$reportNull$$$0(2);
        }
        JSElement jSElement = (resolveAndInitializer = JSLocalNamespaceEvaluator.resolveLocallyCompletely(lOperand)) == null ? lOperand : (resolveAndInitializer.second != null ? (JSElement)resolveAndInitializer.second : (JSElement)resolveAndInitializer.first);
        if (jSElement == null) {
            JSLocalNamespaceEvaluator.$$$reportNull$$$0(3);
        }
        return jSElement;
    }

    @Nullable
    private static @Nullable Pair<@NotNull JSPsiNamedElementBase, @Nullable JSExpression> resolveLocallyCompletely(@NotNull JSReferenceExpression lOperand) {
        if (lOperand == null) {
            JSLocalNamespaceEvaluator.$$$reportNull$$$0(4);
        }
        HashSet<JSReferenceExpression> visited = new HashSet<JSReferenceExpression>();
        JSPsiNamedElementBase resolve2 = null;
        JSExpression initializer = null;
        while (visited.add(lOperand)) {
            if (lOperand.getQualifier() != null) {
                return resolve2 != null ? Pair.create(resolve2, initializer) : null;
            }
            String referenceName = lOperand.getReferenceName();
            if (referenceName == null) {
                return resolve2 != null ? Pair.create(resolve2, initializer) : null;
            }
            JSPsiNamedElementBase oldResolve = resolve2;
            resolve2 = JSSymbolUtil.resolveLocallyIncludingDefinitions(referenceName, lOperand);
            if (resolve2 == null) {
                return oldResolve != null ? Pair.create((Object)oldResolve, (Object)initializer) : null;
            }
            initializer = JSLocalNamespaceEvaluator.getValueFromInitializer(resolve2);
            if (!(initializer instanceof JSReferenceExpression)) {
                return Pair.create((Object)resolve2, (Object)initializer);
            }
            lOperand = (JSReferenceExpression)initializer;
        }
        return Pair.create(resolve2, initializer);
    }

    @Nullable
    private static JSExpression getValueFromInitializer(@NotNull JSElement resolveResult) {
        if (resolveResult == null) {
            JSLocalNamespaceEvaluator.$$$reportNull$$$0(5);
        }
        JSExpression expressionToFollow = null;
        if (resolveResult instanceof JSVariable && !JSVariableBaseImpl.hasExplicitlyDeclaredType((JSVariable)resolveResult)) {
            if (resolveResult instanceof JSParameter) {
                JSParameter parameter = (JSParameter)resolveResult;
                JSExpression initialization = JSSymbolUtil.getParameterInitialization(parameter);
                if (initialization != null) {
                    expressionToFollow = initialization;
                }
            } else if (!(resolveResult.getParent() instanceof JSDestructuringProperty) && !(resolveResult.getParent() instanceof JSDestructuringContainer)) {
                expressionToFollow = ((JSVariable)resolveResult).getInitializer();
            }
        } else if (resolveResult instanceof JSDefinitionExpression) {
            expressionToFollow = JSPsiImplUtils.getRightmostOperand((JSDefinitionExpression)resolveResult);
        }
        if (expressionToFollow instanceof JSBinaryExpression) {
            JSExpression operand;
            JSBinaryExpression binaryExpression = (JSBinaryExpression)expressionToFollow;
            IElementType sign = binaryExpression.getOperationSign();
            JSExpression jSExpression = sign == JSTokenTypes.OROR ? binaryExpression.getLOperand() : (operand = sign == JSTokenTypes.ANDAND ? binaryExpression.getROperand() : null);
            if (operand instanceof JSReferenceExpression) {
                expressionToFollow = operand;
            }
        }
        return expressionToFollow;
    }

    @Nullable
    private JSNamespace replaceLocalVars(@NotNull JSNamespace ns, @Nullable JSReferenceExpression expression) {
        if (ns == null) {
            JSLocalNamespaceEvaluator.$$$reportNull$$$0(6);
        }
        if (expression == null) {
            return ns;
        }
        JSQualifiedName qualifiedName = ns.getQualifiedName();
        if (qualifiedName == null) {
            return ns;
        }
        JSReferenceExpression innerMostExpr = expression;
        while (innerMostExpr.getQualifier() != null) {
            JSExpression innerMostExprQualifier = innerMostExpr.getQualifier();
            if (!(innerMostExprQualifier instanceof JSReferenceExpression)) {
                return ns;
            }
            innerMostExpr = (JSReferenceExpression)innerMostExprQualifier;
        }
        PsiElement ref2 = JSStubBasedPsiTreeUtil.resolveLocally(JSQualifiedNameImpl.getTopmostParent(qualifiedName), (PsiElement)expression, false);
        if (ref2 instanceof JSParameter) {
            JSFunction declaringFunction = ((JSParameter)ref2).getDeclaringFunction();
            if (declaringFunction instanceof JSFunctionExpression && (declaringFunction.getParent() instanceof JSArgumentList || declaringFunction.getParent() instanceof JSParenthesizedExpression)) {
                return null;
            }
            return JSNamedTypeFactory.createNamespace(JSQualifiedNameImpl.fromQualifiedNamedElement((JSVariable)ref2), ns.getJSContext(), ref2, true, ns.isDeclaration(), true);
        }
        if (ref2 instanceof JSVariable) {
            JSExpression initializer = ((JSVariable)ref2).getInitializer();
            boolean isDeclaration = ns.isDeclaration();
            if (JSVariableBaseImpl.hasExplicitlyDeclaredType((JSVariable)ref2)) {
                isDeclaration = false;
            }
            if (initializer instanceof JSReferenceExpression) {
                JSNamespace initializerType = JSSymbolUtil.createNamespaceFromReferenceExpression((JSReferenceExpression)initializer, ns.getJSContext(), isDeclaration);
                return JSLocalNamespaceEvaluator.replaceTopmostQualifier(ns, initializerType);
            }
            if (this.myVisited == null) {
                this.myVisited = new HashSet<PsiElement>();
            }
            if (this.myVisited.add((PsiElement)innerMostExpr)) {
                ns = this.replaceTopmostQualifier(innerMostExpr, expression, ns, isDeclaration, ref2);
                this.myVisited.remove(innerMostExpr);
                return ns;
            }
        } else if (innerMostExpr == expression && ref2 instanceof JSNamedElement && !(ref2 instanceof JSElementBase) && !ns.isLocal()) {
            return JSNamedTypeFactory.createNamespace(ns.getQualifiedName(), ns.getJSContext(), ns.getSource().getSourceElement(), ns.isSourceStrict(), ns.isDeclaration(), true);
        }
        return ns;
    }

    @Nullable
    private JSNamespace replaceTopmostQualifier(@NotNull JSReferenceExpression innerMostExpr, @NotNull JSReferenceExpression expression, @NotNull JSNamespace ns, boolean isDeclaration, PsiElement ref2) {
        if (innerMostExpr == null) {
            JSLocalNamespaceEvaluator.$$$reportNull$$$0(7);
        }
        if (expression == null) {
            JSLocalNamespaceEvaluator.$$$reportNull$$$0(8);
        }
        if (ns == null) {
            JSLocalNamespaceEvaluator.$$$reportNull$$$0(9);
        }
        if (innerMostExpr != expression) {
            JSNamespace innerMostType = this.evaluateNamespaceLocally(innerMostExpr);
            if (innerMostType == null) {
                String name = innerMostExpr.getReferenceName();
                if (JSLocalNamespaceEvaluator.isImportantName(name)) {
                    return JSSymbolUtil.createNamespaceFromReferenceExpression(expression, ns.getJSContext(), isDeclaration);
                }
                return null;
            }
            return JSLocalNamespaceEvaluator.replaceTopmostQualifier(ns, innerMostType);
        }
        JSNamespace innerResult = this.evaluateNamespaceLocally(innerMostExpr);
        if (innerResult == null) {
            return JSNamedTypeFactory.createNamespace(JSQualifiedNameImpl.fromQualifiedNamedElement((JSVariable)ref2), ns.getJSContext(), ref2, true, isDeclaration, ns.isLocal());
        }
        JSContext jsContext = JSTypeUtils.combineJSContexts(innerResult.getJSContext(), ns.getJSContext());
        return JSNamedTypeFactory.createNamespace(innerResult.getQualifiedName(), jsContext, innerResult.getSource().getSourceElement(), innerResult.isSourceStrict(), innerResult.isDeclaration(), innerResult.isLocal());
    }

    @Nullable
    private static JSNamespace replaceTopmostQualifier(@NotNull JSNamespace ns, @Nullable JSNamespace by) {
        JSQualifiedNameImpl initialQName;
        if (ns == null) {
            JSLocalNamespaceEvaluator.$$$reportNull$$$0(10);
        }
        if ((initialQName = (JSQualifiedNameImpl)ns.getQualifiedName()) == null) {
            throw new IllegalArgumentException("Nothing to replace");
        }
        if (by == null) {
            return null;
        }
        JSQualifiedNameImpl tail = initialQName.withoutInnermostComponent(null);
        JSQualifiedName replaced = JSQualifiedNameImpl.concat(by.getQualifiedName(), tail);
        return JSNamedTypeFactory.createNamespace(replaced, ns.getJSContext(), ns.getSource().getSourceElement(), false, ns.isDeclaration(), by.isLocal());
    }

    private static boolean isImportantName(@Nullable String name) {
        if (StringUtil.isEmpty((String)name)) {
            return false;
        }
        char ch = name.charAt(0);
        return Character.isUpperCase(ch) || ch == '$';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lOperand";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/index/JSLocalNamespaceEvaluator";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResult";
                break;
            }
            case 6: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ns";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "innerMostExpr";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/index/JSLocalNamespaceEvaluator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "calcRefExprValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "evaluateReferenceExpression";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "doEvaluateReferenceExpression";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "calcRefExprValue";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "resolveLocallyCompletely";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getValueFromInitializer";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "replaceLocalVars";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "replaceTopmostQualifier";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

