/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptThisType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSFunctionBaseImpl;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.ImplicitJSVariableImpl;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public final class JSMethodCanBeStaticInspection
extends JSInspection {
    public boolean myOnlyPrivate = false;

    @Override
    @NotNull
    protected JSElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSMethodCanBeStaticInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            JSMethodCanBeStaticInspection.$$$reportNull$$$0(1);
        }
        return new JSElementVisitor(){

            @Override
            public void visitJSFunctionDeclaration(final @NotNull JSFunction function) {
                TypeScriptFunction tsFunction;
                Condition[] classAttributeList;
                JSClass clazz;
                if (function == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((clazz = JSUtils.getMemberContainingClass(function)) == null) {
                    return;
                }
                if (clazz.isInterface()) {
                    return;
                }
                if (clazz.getName() == null) {
                    return;
                }
                PsiElement nameIdentifier = function.getNameIdentifier();
                if (nameIdentifier == null) {
                    return;
                }
                JSAttributeList attributeList = function.getAttributeList();
                if (attributeList == null || attributeList.hasModifier(JSAttributeList.ModifierType.STATIC) || attributeList.hasModifier(JSAttributeList.ModifierType.OVERRIDE)) {
                    return;
                }
                if (attributeList.getAccessType() != JSAttributeList.AccessType.PRIVATE && JSMethodCanBeStaticInspection.this.myOnlyPrivate) {
                    return;
                }
                if (function.isConstructor() || "toString".equals(function.getName())) {
                    return;
                }
                if (!attributeList.hasModifier(JSAttributeList.ModifierType.FINAL) && (classAttributeList = clazz.getAttributeList()) != null && classAttributeList.findAttributeByName("Abstract") != null) {
                    return;
                }
                for (Condition addin : (Condition[])InspectionManager.CANT_BE_STATIC_EXTENSION.getExtensions()) {
                    if (!addin.value((Object)function)) continue;
                    return;
                }
                if (JSMethodCanBeStaticInspection.hasEmptyBody(function)) {
                    return;
                }
                if (function instanceof TypeScriptFunction && (tsFunction = (TypeScriptFunction)function).hasOverloadDeclarations()) {
                    return;
                }
                JSDocComment docComment = JSDocumentationUtils.findOwnDocComment(function);
                if (docComment != null && docComment.hasInstanceTag()) {
                    return;
                }
                final Ref dependsOnInstance = new Ref();
                function.acceptChildren(new JSRecursiveWalkingElementVisitor(){

                    @Override
                    public void visitJSThisExpression(@NotNull JSThisExpression node) {
                        if (node == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        dependsOnInstance.set((Object)Boolean.TRUE);
                    }

                    @Override
                    public void visitJSSuperExpression(@NotNull JSSuperExpression superExpression) {
                        if (superExpression == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        dependsOnInstance.set((Object)Boolean.TRUE);
                    }

                    @Override
                    public void visitTypeScriptThisType(@NotNull TypeScriptThisType thisType) {
                        if (thisType == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        dependsOnInstance.set((Object)Boolean.TRUE);
                    }

                    @Override
                    public void visitJSReferenceExpression(@NotNull JSReferenceExpression node) {
                        if (node == null) {
                            1.$$$reportNull$$$0(3);
                        }
                        if (node.getQualifier() == null && !JSResolveUtil.isSelfReference((PsiElement)node)) {
                            ResolveResult[] resolveResults = node.multiResolve(false);
                            if (resolveResults.length == 0) {
                                dependsOnInstance.set((Object)Boolean.TRUE);
                            }
                            for (ResolveResult resolveResult : resolveResults) {
                                if (!JSMethodCanBeStaticInspection.checkReferenceResolveResultDependsOnInstance(resolveResult, function)) continue;
                                dependsOnInstance.set((Object)Boolean.TRUE);
                            }
                        }
                        super.visitJSReferenceExpression(node);
                    }

                    @Override
                    public boolean visitAsFunction(@NotNull JSFunction function2) {
                        if (function2 == null) {
                            1.$$$reportNull$$$0(4);
                        }
                        this.checkFunForExternals((JSFunctionBaseImpl)function2);
                        return true;
                    }

                    private void checkFunForExternals(JSFunctionBaseImpl node) {
                        HashSet<String> usedExternalVars = new HashSet<String>();
                        node.addReferencedExternalNames(usedExternalVars);
                        if (!usedExternalVars.isEmpty() || node.isArrowFunction() && node.isReferencesThis()) {
                            dependsOnInstance.set((Object)Boolean.TRUE);
                        }
                    }

                    @Override
                    public void visitElement(@NotNull PsiElement element2) {
                        if (element2 == null) {
                            1.$$$reportNull$$$0(5);
                        }
                        if (dependsOnInstance.get() != null) {
                            return;
                        }
                        super.visitElement(element2);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "node";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "superExpression";
                                break;
                            }
                            case 2: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "thisType";
                                break;
                            }
                            case 4: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "function";
                                break;
                            }
                            case 5: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "element";
                                break;
                            }
                        }
                        objectArray2[1] = "com/intellij/lang/javascript/inspections/JSMethodCanBeStaticInspection$1$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "visitJSThisExpression";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "visitJSSuperExpression";
                                break;
                            }
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[2] = "visitTypeScriptThisType";
                                break;
                            }
                            case 3: {
                                objectArray = objectArray2;
                                objectArray2[2] = "visitJSReferenceExpression";
                                break;
                            }
                            case 4: {
                                objectArray = objectArray2;
                                objectArray2[2] = "visitAsFunction";
                                break;
                            }
                            case 5: {
                                objectArray = objectArray2;
                                objectArray2[2] = "visitElement";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
                for (ImplicitUsageProvider usageProvider : ImplicitUsageProvider.EP_NAME.getExtensionList()) {
                    if (!usageProvider.isImplicitUsage((PsiElement)function)) continue;
                    return;
                }
                if (dependsOnInstance.get() == null && !JSInheritanceUtil.participatesInMemberHierarchy(function)) {
                    holder.registerProblem(nameIdentifier, JavaScriptBundle.message("js.method.can.be.static", new Object[0]), new LocalQuickFix[]{JSFixFactory.getInstance().makeMethodStaticFix()});
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/inspections/JSMethodCanBeStaticInspection$1", "visitJSFunctionDeclaration"));
            }
        };
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"myOnlyPrivate", (String)JavaScriptBundle.message("js.method.can.be.static.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            JSMethodCanBeStaticInspection.$$$reportNull$$$0(2);
        }
        return optPane;
    }

    private static boolean hasEmptyBody(@NotNull JSFunction function) {
        JSBlockStatement block;
        if (function == null) {
            JSMethodCanBeStaticInspection.$$$reportNull$$$0(3);
        }
        return (block = function.getBlock()) == null || block.getStatementListItems().length == 0;
    }

    private static boolean checkReferenceResolveResultDependsOnInstance(@NotNull ResolveResult resolveResult, @NotNull JSFunction function) {
        PsiElement resolvedMemberParent;
        JSAttributeList resolvedMemberAttrList;
        TypeScriptTypeParameterListOwner parameterOwner;
        if (resolveResult == null) {
            JSMethodCanBeStaticInspection.$$$reportNull$$$0(4);
        }
        if (function == null) {
            JSMethodCanBeStaticInspection.$$$reportNull$$$0(5);
        }
        if (!resolveResult.isValidResult()) {
            return true;
        }
        PsiElement resolve2 = resolveResult.getElement();
        if (resolve2 instanceof ImplicitJSVariableImpl && ("hostComponent".equals(((ImplicitJSVariableImpl)resolve2).getName()) || "outerDocument".equals(((ImplicitJSVariableImpl)resolve2).getName()))) {
            return true;
        }
        if (resolve2 instanceof TypeScriptTypeParameter && (parameterOwner = ((TypeScriptTypeParameter)resolve2).getOwner()) instanceof JSClass) {
            return true;
        }
        return resolve2 instanceof JSAttributeListOwner && !(resolve2 instanceof JSClass) ? (resolvedMemberAttrList = ((JSAttributeListOwner)resolve2).getAttributeList()) != null && !resolvedMemberAttrList.hasModifier(JSAttributeList.ModifierType.STATIC) && !JSResolveUtil.isConstructorFunction(resolve2) && resolve2 != function && (resolvedMemberParent = JSResolveUtil.findParent(resolve2)) instanceof JSClass : resolve2 instanceof JSImplicitElement && ((JSImplicitElement)resolve2).getType() == JSImplicitElement.Type.Tag;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/JSMethodCanBeStaticInspection";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResult";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSMethodCanBeStaticInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasEmptyBody";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkReferenceResolveResultDependsOnInstance";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

