/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.convertToClass.JSConvertToClassProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopeUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public class JSFunctionToES6ClassIntention
extends JavaScriptIntention {
    @TestOnly
    public boolean myGenerateTheWholeTree = false;

    public JSFunctionToES6ClassIntention() {
        this.setText(JavaScriptBundle.message("js.convert.to.es6.class", new Object[0]));
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element2) {
        if (project == null) {
            JSFunctionToES6ClassIntention.$$$reportNull$$$0(0);
        }
        if (element2 == null) {
            JSFunctionToES6ClassIntention.$$$reportNull$$$0(1);
        }
        if (!super.isAvailable(project, editor, element2) || !DialectDetector.isES6(element2) && !DialectDetector.isJSX(element2)) {
            return false;
        }
        JSFunction function = JSFunctionToES6ClassIntention.getWrappingFunction(element2);
        return function != null && function.getName() != null && JSFunctionToES6ClassIntention.checkContext(function);
    }

    private static boolean checkContext(@NotNull JSFunction function) {
        PsiElement psiElement;
        PsiElement nameIdentifier;
        if (function == null) {
            JSFunctionToES6ClassIntention.$$$reportNull$$$0(2);
        }
        if ((nameIdentifier = function.getNameIdentifier()) != null && (psiElement = nameIdentifier.getParent()) instanceof JSReferenceExpression) {
            JSReferenceExpression jsRef = (JSReferenceExpression)psiElement;
            if (jsRef.getQualifier() != null) {
                return false;
            }
            if (JSChangeUtil.isWellKnownPredefined(StringUtil.notNullize((String)jsRef.getReferenceName()))) {
                return false;
            }
        }
        if (function.getParent() instanceof JSClass) {
            return false;
        }
        if (function.getParent() instanceof TypeScriptObjectType && function.getParent().getParent() instanceof JSClass) {
            return false;
        }
        return JSFunctionToES6ClassIntention.hasInstanceProperties(function);
    }

    private static boolean hasInstanceProperties(@NotNull JSFunction function) {
        String name;
        if (function == null) {
            JSFunctionToES6ClassIntention.$$$reportNull$$$0(3);
        }
        String string = name = function.getQualifiedName() == null ? function.getName() : function.getQualifiedName();
        if (name == null) {
            return false;
        }
        GlobalSearchScope searchScope = GlobalSearchScopeUtil.toGlobalSearchScope((SearchScope)function.getUseScope(), (Project)function.getProject());
        return !JSClassResolver.getInstance().processNamespaceMembers(name, searchScope, function.getContainingFile(), (Processor<? super JSPsiElementBase>)((Processor)base -> {
            if (base instanceof JSImplicitElement || base.equals(function) || JSUtils.isMember((PsiElement)base)) {
                return true;
            }
            if (base.getJSContext() != JSContext.STATIC) {
                return false;
            }
            return !"prototype".equals(base.getName());
        }));
    }

    public static JSFunction getWrappingFunction(@NotNull PsiElement element2) {
        JSDefinitionExpression definition;
        PsiFile file;
        if (element2 == null) {
            JSFunctionToES6ClassIntention.$$$reportNull$$$0(4);
        }
        if (!((file = element2.getContainingFile()) instanceof JSFile) && PsiTreeUtil.getParentOfType((PsiElement)element2, JSEmbeddedContent.class) == null) {
            return null;
        }
        PsiElement parent = element2.getParent();
        if (parent instanceof JSParameter) {
            parent = parent.getParent();
        }
        if (parent instanceof JSParameterList) {
            parent = parent.getParent();
        }
        if (parent instanceof JSFunction) {
            return (JSFunction)parent;
        }
        if (parent instanceof JSVariable && ((JSVariable)parent).getInitializer() instanceof JSFunction) {
            return (JSFunction)((Object)((JSVariable)parent).getInitializer());
        }
        while (parent instanceof JSReferenceExpression || parent instanceof JSDefinitionExpression) {
            parent = parent.getParent();
        }
        JSDefinitionExpression jSDefinitionExpression = definition = parent instanceof JSAssignmentExpression ? ((JSAssignmentExpression)parent).getDefinitionExpression() : null;
        if (definition != null && definition.getInitializer() instanceof JSFunction) {
            return (JSFunction)((Object)definition.getInitializer());
        }
        return null;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element2) throws IncorrectOperationException {
        JSFunction function;
        if (project == null) {
            JSFunctionToES6ClassIntention.$$$reportNull$$$0(5);
        }
        if (element2 == null) {
            JSFunctionToES6ClassIntention.$$$reportNull$$$0(6);
        }
        if ((function = JSFunctionToES6ClassIntention.getWrappingFunction(element2)) == null || function.getName() == null || !JSFunctionToES6ClassIntention.checkContext(function)) {
            return;
        }
        JSConvertToClassProcessor processor = new JSConvertToClassProcessor(project, EmptyRunnable.getInstance(), function);
        if (this.myGenerateTheWholeTree) {
            processor.generateTheWholeTree();
        }
        processor.run();
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message("js.convert.to.es6.class.family.name", new Object[0]);
        if (string == null) {
            JSFunctionToES6ClassIntention.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/JSFunctionToES6ClassIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/JSFunctionToES6ClassIntention";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkContext";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasInstanceProperties";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getWrappingFunction";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7 -> new IllegalStateException(string);
        };
    }
}

