/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.lang.javascript.linter.JSLinterState;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLinterInput<T extends JSLinterState> {
    private final Project myProject;
    private final PsiFile myPsiFile;
    private final String myFileContent;
    private final T myState;
    private final EditorColorsScheme myColorsScheme;

    protected JSLinterInput(@NotNull PsiFile psiFile, @NotNull T state, @Nullable EditorColorsScheme colorsScheme) {
        if (psiFile == null) {
            JSLinterInput.$$$reportNull$$$0(0);
        }
        if (state == null) {
            JSLinterInput.$$$reportNull$$$0(1);
        }
        this.myProject = psiFile.getProject();
        this.myPsiFile = psiFile;
        this.myFileContent = JSLanguageServiceUtil.convertLineSeparatorsToFileOriginal(this.myProject, psiFile.getViewProvider().getDocument().getText(), this.myPsiFile.getViewProvider().getVirtualFile()).toString();
        this.myState = state;
        this.myColorsScheme = colorsScheme;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            JSLinterInput.$$$reportNull$$$0(2);
        }
        return project;
    }

    @NotNull
    public PsiFile getPsiFile() {
        PsiFile psiFile = this.myPsiFile;
        if (psiFile == null) {
            JSLinterInput.$$$reportNull$$$0(3);
        }
        return psiFile;
    }

    @NotNull
    public VirtualFile getVirtualFile() {
        VirtualFile virtualFile = this.myPsiFile.getViewProvider().getVirtualFile();
        if (virtualFile == null) {
            JSLinterInput.$$$reportNull$$$0(4);
        }
        return virtualFile;
    }

    @NotNull
    public String getFileContent() {
        String string = this.myFileContent;
        if (string == null) {
            JSLinterInput.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public T getState() {
        T t = this.myState;
        if (t == null) {
            JSLinterInput.$$$reportNull$$$0(6);
        }
        return t;
    }

    @Nullable
    public EditorColorsScheme getColorsScheme() {
        return this.myColorsScheme;
    }

    @NotNull
    public static <T extends JSLinterState> JSLinterInput<T> create(@NotNull PsiFile psiFile, @NotNull T state, @Nullable EditorColorsScheme colorsScheme) {
        if (psiFile == null) {
            JSLinterInput.$$$reportNull$$$0(7);
        }
        if (state == null) {
            JSLinterInput.$$$reportNull$$$0(8);
        }
        return new JSLinterInput<T>(psiFile, state, colorsScheme);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/JSLinterInput";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/JSLinterInput";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiFile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileContent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

