/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.config.JSFileImportsResolver;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.modules.JSModuleNameInfo;
import com.intellij.lang.javascript.modules.JSModuleNameInfoImpl;
import com.intellij.lang.javascript.modules.imports.JSModuleDescriptor;
import com.intellij.lang.javascript.modules.imports.path.JSImportModulePathStrategy;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class JSModuleDescriptorFactory {
    @NotNull
    public static JSModuleDescriptor createModuleDescriptor(@Nullable String unquotedModuleName, @NotNull VirtualFile module, @NotNull PsiElement place) {
        if (module == null) {
            JSModuleDescriptorFactory.$$$reportNull$$$0(0);
        }
        if (place == null) {
            JSModuleDescriptorFactory.$$$reportNull$$$0(1);
        }
        return JSModuleDescriptorFactory.createModuleDescriptor(unquotedModuleName, module, module, place, JSFileReferencesUtil.IMPLICIT_EXTENSIONS, JSModuleNameInfo.ExtensionSettings.DEFAULT);
    }

    @NotNull
    public static JSModuleDescriptor createModuleDescriptor(@Nullable String unquotedModuleName, @Nullable VirtualFile moduleFileOrDirectory, @NotNull VirtualFile resolvedFile, @NotNull PsiElement place, String @NotNull [] extensions, @NotNull JSModuleNameInfo.ExtensionSettings pathSettings) {
        if (resolvedFile == null) {
            JSModuleDescriptorFactory.$$$reportNull$$$0(2);
        }
        if (place == null) {
            JSModuleDescriptorFactory.$$$reportNull$$$0(3);
        }
        if (pathSettings == null) {
            JSModuleDescriptorFactory.$$$reportNull$$$0(4);
        }
        if (extensions == null) {
            JSModuleDescriptorFactory.$$$reportNull$$$0(5);
        }
        String moduleName = JSModuleDescriptorFactory.getModuleName(unquotedModuleName, moduleFileOrDirectory, place, extensions, pathSettings);
        return new JSModuleNameInfoImpl(moduleName, moduleFileOrDirectory, resolvedFile, place);
    }

    @NotNull
    public static JSModuleDescriptor createExactModuleDescriptor(@Nullable String unquotedModuleName, @Nullable VirtualFile moduleFileOrDirectory, @NotNull VirtualFile resolvedFile, @NotNull PsiElement place) {
        if (resolvedFile == null) {
            JSModuleDescriptorFactory.$$$reportNull$$$0(6);
        }
        if (place == null) {
            JSModuleDescriptorFactory.$$$reportNull$$$0(7);
        }
        return new JSModuleNameInfoImpl(unquotedModuleName, moduleFileOrDirectory, resolvedFile, place);
    }

    @NotNull
    public static String getModuleName(@Nullable String pathWithFileExtension, @Nullable VirtualFile moduleFileOrDirectory, @NotNull PsiElement place, String @NotNull [] extensions, @NotNull JSModuleNameInfo.ExtensionSettings pathSettings) {
        String extensionWithDot;
        if (place == null) {
            JSModuleDescriptorFactory.$$$reportNull$$$0(8);
        }
        if (pathSettings == null) {
            JSModuleDescriptorFactory.$$$reportNull$$$0(9);
        }
        if (extensions == null) {
            JSModuleDescriptorFactory.$$$reportNull$$$0(10);
        }
        if (StringUtil.isEmpty((String)pathWithFileExtension)) {
            return "";
        }
        boolean isFile = moduleFileOrDirectory == null || !moduleFileOrDirectory.isDirectory();
        String string = extensionWithDot = isFile && (moduleFileOrDirectory == null || pathWithFileExtension.endsWith(moduleFileOrDirectory.getName())) ? JSFileReferencesUtil.findExtension(pathWithFileExtension, extensions) : null;
        if (extensionWithDot == null) {
            String string2 = pathWithFileExtension;
            if (string2 == null) {
                JSModuleDescriptorFactory.$$$reportNull$$$0(11);
            }
            return string2;
        }
        JSModuleNameInfo.ExtensionSettings newPathSettings = JSModuleDescriptorFactory.getPathSettings(place, pathSettings, extensionWithDot);
        return switch (newPathSettings) {
            default -> throw new IncompatibleClassChangeError();
            case JSModuleNameInfo.ExtensionSettings.EXACT, JSModuleNameInfo.ExtensionSettings.FORCE_EXTENSION -> pathWithFileExtension;
            case JSModuleNameInfo.ExtensionSettings.FORCE_JS_EXTENSION -> JSModuleDescriptorFactory.getWithoutExtension(place, pathWithFileExtension, extensionWithDot) + JSModuleDescriptorFactory.getJSExtension(extensionWithDot);
            case JSModuleNameInfo.ExtensionSettings.DEFAULT, JSModuleNameInfo.ExtensionSettings.NO_EXTENSION -> JSModuleDescriptorFactory.getWithoutExtension(place, pathWithFileExtension, extensionWithDot);
        };
    }

    @NotNull
    private static String getWithoutExtension(@NotNull PsiElement place, @NotNull String pathWithFileExtension, @NotNull String extensionWithDot) {
        JSFileImportsResolver resolver;
        String extensionCandidate;
        TypeScriptConfig config;
        if (place == null) {
            JSModuleDescriptorFactory.$$$reportNull$$$0(12);
        }
        if (pathWithFileExtension == null) {
            JSModuleDescriptorFactory.$$$reportNull$$$0(13);
        }
        if (extensionWithDot == null) {
            JSModuleDescriptorFactory.$$$reportNull$$$0(14);
        }
        if ((config = TypeScriptConfigUtil.getConfigForPsiFile(place.getContainingFile())) != null && (extensionCandidate = JSFileReferencesUtil.findExtension(pathWithFileExtension, (resolver = config.getImportResolver()).getExtensionsWithDot())) != null) {
            extensionWithDot = extensionCandidate;
        }
        String string = StringUtil.trimEnd((String)pathWithFileExtension, (String)extensionWithDot);
        if (string == null) {
            JSModuleDescriptorFactory.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    private static String getJSExtension(@NotNull String extensionWithDot) {
        if (extensionWithDot == null) {
            JSModuleDescriptorFactory.$$$reportNull$$$0(16);
        }
        return switch (extensionWithDot) {
            case ".mts" -> ".mjs";
            case ".cts" -> ".cjs";
            default -> ".js";
        };
    }

    @NotNull
    public static JSModuleDescriptor copyWithModuleName(@NotNull PsiElement place, @NotNull JSModuleDescriptor descriptor, @NotNull String unquotedModuleName) {
        if (place == null) {
            JSModuleDescriptorFactory.$$$reportNull$$$0(17);
        }
        if (descriptor == null) {
            JSModuleDescriptorFactory.$$$reportNull$$$0(18);
        }
        if (unquotedModuleName == null) {
            JSModuleDescriptorFactory.$$$reportNull$$$0(19);
        }
        if (descriptor instanceof JSModuleNameInfo) {
            return new JSModuleNameInfoImpl(unquotedModuleName, ((JSModuleNameInfo)descriptor).getModuleFileOrDirectory(), ((JSModuleNameInfo)descriptor).getResolvedFile(), place);
        }
        return new JSModuleDescriptor.SimpleModuleDescriptor(descriptor.getModule(), unquotedModuleName);
    }

    @NotNull
    public static String getModuleName(@Nullable String path2, @Nullable VirtualFile moduleFileOrDirectory, @NotNull PsiElement place) {
        if (place == null) {
            JSModuleDescriptorFactory.$$$reportNull$$$0(20);
        }
        return JSModuleDescriptorFactory.getModuleName(path2, moduleFileOrDirectory, place, JSFileReferencesUtil.IMPLICIT_EXTENSIONS, JSModuleNameInfo.ExtensionSettings.DEFAULT);
    }

    @NotNull
    static JSModuleNameInfo.ExtensionSettings getPathSettings(@NotNull PsiElement place, @NotNull JSModuleNameInfo.ExtensionSettings pathSettings, @NotNull String extensionWithDot) {
        if (place == null) {
            JSModuleDescriptorFactory.$$$reportNull$$$0(21);
        }
        if (pathSettings == null) {
            JSModuleDescriptorFactory.$$$reportNull$$$0(22);
        }
        if (extensionWithDot == null) {
            JSModuleDescriptorFactory.$$$reportNull$$$0(23);
        }
        if (pathSettings != JSModuleNameInfo.ExtensionSettings.DEFAULT) {
            JSModuleNameInfo.ExtensionSettings extensionSettings = pathSettings;
            if (extensionSettings == null) {
                JSModuleDescriptorFactory.$$$reportNull$$$0(24);
            }
            return extensionSettings;
        }
        JSCodeStyleSettings.UseExplicitExtension codeStyleExtension = JSModuleDescriptorFactory.getCodeStyleExtension(place);
        boolean auto = codeStyleExtension == JSCodeStyleSettings.UseExplicitExtension.AUTO;
        for (JSImportModulePathStrategy strategy : JSModuleDescriptorFactory.getProviders(place)) {
            JSModuleNameInfo.ExtensionSettings pathExtension = strategy.getPathSettings(place, extensionWithDot, auto);
            if (pathExtension == null || pathExtension == JSModuleNameInfo.ExtensionSettings.DEFAULT) continue;
            JSModuleNameInfo.ExtensionSettings extensionSettings = pathExtension;
            if (extensionSettings == null) {
                JSModuleDescriptorFactory.$$$reportNull$$$0(25);
            }
            return extensionSettings;
        }
        return codeStyleExtension != JSCodeStyleSettings.UseExplicitExtension.ALWAYS_JS ? JSModuleNameInfo.ExtensionSettings.NO_EXTENSION : JSModuleDescriptorFactory.toExplicitJSExtensionSetting(place, extensionWithDot);
    }

    public static boolean isDirectoryImportAvailable(@NotNull PsiElement place, @NotNull String extensionWithDot) {
        JSCodeStyleSettings settings;
        JSCodeStyleSettings.UseExplicitExtension codeStyleExtension;
        if (place == null) {
            JSModuleDescriptorFactory.$$$reportNull$$$0(26);
        }
        if (extensionWithDot == null) {
            JSModuleDescriptorFactory.$$$reportNull$$$0(27);
        }
        boolean auto = JSCodeStyleSettings.UseExplicitExtension.AUTO == (codeStyleExtension = (settings = JSCodeStyleSettings.getSettings(place)).getUseExplicitJSExtension());
        for (JSImportModulePathStrategy strategy : JSModuleDescriptorFactory.getProviders(place)) {
            if (strategy.isDirectoryImportAvailable(place, extensionWithDot, auto)) continue;
            return false;
        }
        return codeStyleExtension != JSCodeStyleSettings.UseExplicitExtension.ALWAYS_JS && settings.isUseNodeResolution();
    }

    @NotNull
    private static @Unmodifiable List<JSImportModulePathStrategy> getProviders(@NotNull PsiElement place) {
        if (place == null) {
            JSModuleDescriptorFactory.$$$reportNull$$$0(28);
        }
        List list = ContainerUtil.filter((Collection)JSImportModulePathStrategy.EP_NAME.getExtensionList(), el -> el.isAvailable(place));
        if (list == null) {
            JSModuleDescriptorFactory.$$$reportNull$$$0(29);
        }
        return list;
    }

    @NotNull
    private static JSCodeStyleSettings.UseExplicitExtension getCodeStyleExtension(@NotNull PsiElement place) {
        if (place == null) {
            JSModuleDescriptorFactory.$$$reportNull$$$0(30);
        }
        JSCodeStyleSettings settings = JSCodeStyleSettings.getSettings(place);
        JSCodeStyleSettings.UseExplicitExtension useExplicitExtension = settings.getUseExplicitJSExtension();
        if (useExplicitExtension == null) {
            JSModuleDescriptorFactory.$$$reportNull$$$0(31);
        }
        return useExplicitExtension;
    }

    @NotNull
    public static JSModuleNameInfo.ExtensionSettings toExplicitJSExtensionSetting(@NotNull PsiElement place, @NotNull String extensionWithDot) {
        if (place == null) {
            JSModuleDescriptorFactory.$$$reportNull$$$0(32);
        }
        if (extensionWithDot == null) {
            JSModuleDescriptorFactory.$$$reportNull$$$0(33);
        }
        JSCodeStyleSettings.UseExplicitExtension codeStyleExtension = JSModuleDescriptorFactory.getCodeStyleExtension(place);
        JSModuleNameInfo.ExtensionSettings extensionSettings = TypeScriptUtil.isTypeScriptFile(extensionWithDot) && codeStyleExtension == JSCodeStyleSettings.UseExplicitExtension.ALWAYS_JS ? JSModuleNameInfo.ExtensionSettings.FORCE_JS_EXTENSION : JSModuleNameInfo.ExtensionSettings.FORCE_EXTENSION;
        if (extensionSettings == null) {
            JSModuleDescriptorFactory.$$$reportNull$$$0(34);
        }
        return extensionSettings;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 15, 24, 25, 29, 31, 34 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: 
            case 12: 
            case 17: 
            case 20: 
            case 21: 
            case 26: 
            case 28: 
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedFile";
                break;
            }
            case 4: 
            case 9: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathSettings";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensions";
                break;
            }
            case 11: 
            case 15: 
            case 24: 
            case 25: 
            case 29: 
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/modules/JSModuleDescriptorFactory";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathWithFileExtension";
                break;
            }
            case 14: 
            case 16: 
            case 23: 
            case 27: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionWithDot";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unquotedModuleName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/modules/JSModuleDescriptorFactory";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleName";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getWithoutExtension";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathSettings";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getProviders";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getCodeStyleExtension";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "toExplicitJSExtensionSetting";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createModuleDescriptor";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createExactModuleDescriptor";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getModuleName";
                break;
            }
            case 11: 
            case 15: 
            case 24: 
            case 25: 
            case 29: 
            case 31: 
            case 34: {
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getWithoutExtension";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getJSExtension";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "copyWithModuleName";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getPathSettings";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isDirectoryImportAvailable";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getProviders";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getCodeStyleExtension";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "toExplicitJSExtensionSetting";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 15, 24, 25, 29, 31, 34 -> new IllegalStateException(string);
        };
    }
}

