/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.JSAnalysisHandlersFactory;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.ecmascript6.TypeScriptAnnotatorCheckerProvider;
import com.intellij.lang.javascript.ecmascript6.TypeScriptTypeGuardFixHelper;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.evaluation.JSTypeEvaluationLocationProvider;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.JSComputedPropertyNameOwner;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTemplateLiteralType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSGeneratorReturnType;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSTypeComparingContextService;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.TypeScriptTypePredicateTypeImpl;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.psi.util.ControlFlowUtils;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.validation.JSEmptyTypeChecker;
import com.intellij.lang.javascript.validation.JSFunctionSignatureChecker;
import com.intellij.lang.javascript.validation.JSProblemReporter;
import com.intellij.lang.javascript.validation.JSReferenceChecker;
import com.intellij.lang.javascript.validation.JSReferenceProblemReporter;
import com.intellij.lang.javascript.validation.JSTypeChecker;
import com.intellij.lang.javascript.validation.JSTypeInspectionVisitor;
import com.intellij.lang.javascript.validation.ValidateTypesUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptTypeInspectionVisitor
extends JSTypeInspectionVisitor {
    @NotNull
    private final TypeScriptAnnotatorCheckerProvider myProvider;

    public TypeScriptTypeInspectionVisitor(@NotNull ProblemsHolder holder, @NotNull TypeScriptAnnotatorCheckerProvider provider) {
        if (holder == null) {
            TypeScriptTypeInspectionVisitor.$$$reportNull$$$0(0);
        }
        if (provider == null) {
            TypeScriptTypeInspectionVisitor.$$$reportNull$$$0(1);
        }
        super(holder);
        this.myProvider = provider;
    }

    private void validateFunctionReturnTypeElement(JSFunction function) {
        JSBlockStatement body;
        PsiElement typeElement = function.getReturnTypeElement();
        JSType returnType2 = function.getReturnType(function);
        boolean isGenerator = function.isGenerator();
        boolean isAsync = function.isAsync();
        if (!(typeElement == null || isAsync || isGenerator || returnType2 instanceof JSVoidType || returnType2 instanceof JSAnyType || returnType2 instanceof TypeScriptTypePredicateTypeImpl && ((TypeScriptTypePredicateTypeImpl)returnType2).isAssertion() || (body = function.getBlock()) == null || ControlFlowUtils.elementContainsReturn(body) || !ControlFlowUtils.statementMayCompleteNormally(body))) {
            this.getProblemReporter(typeElement).registerProblem(typeElement, null, JavaScriptBundle.message("javascript.validation.message.return.statement.required", new Object[0]), TypeScriptUtil.getProblemHighlightTypeForType(returnType2), new LocalQuickFix[0]);
            return;
        }
        if (isGenerator && returnType2 != null) {
            this.validateGeneratorReturnType(function, typeElement, returnType2, isAsync);
        }
        if (isAsync && !isGenerator && returnType2 != null && typeElement != null) {
            this.validateAsyncReturnType(typeElement, returnType2);
        }
        if (typeElement != null && function.isConstructor() && function.getParent() instanceof JSClass) {
            this.getProblemReporter(typeElement).registerProblem(typeElement, null, JavaScriptBundle.message("js.constructor.cant.have.return.type", new Object[0]), null, new LocalQuickFix[0]);
        }
    }

    private void validateAsyncReturnType(@NotNull PsiElement typeElement, @NotNull JSType returnType2) {
        if (typeElement == null) {
            TypeScriptTypeInspectionVisitor.$$$reportNull$$$0(2);
        }
        if (returnType2 == null) {
            TypeScriptTypeInspectionVisitor.$$$reportNull$$$0(3);
        }
        if (typeElement instanceof TypeScriptType && !JSTypeUtils.isExactlyPromiseLikeType(returnType2)) {
            this.getProblemReporter(typeElement).registerProblem(typeElement, null, JavaScriptBundle.message("typescript.validation.async.incorrect.type.annotation", returnType2.getTypeText(JSType.TypeTextFormat.PRESENTABLE)), TypeScriptUtil.getProblemHighlightTypeForType(returnType2), JSFixFactory.getInstance().createWrapWithGenericTypeFix("Promise", (TypeScriptType)typeElement));
        }
    }

    private void validateGeneratorReturnType(@NotNull JSFunction function, @Nullable PsiElement typeElement, @NotNull JSType returnType2, boolean isAsync) {
        if (function == null) {
            TypeScriptTypeInspectionVisitor.$$$reportNull$$$0(4);
        }
        if (returnType2 == null) {
            TypeScriptTypeInspectionVisitor.$$$reportNull$$$0(5);
        }
        if (typeElement != null) {
            ProcessingContext context2;
            JSType iterableRawType;
            JSGenericTypeImpl iterableIteratorGeneric;
            JSType componentType = JSTypeUtils.getIterableComponentType(returnType2);
            String iteratorClassName = JSGeneratorReturnType.getGeneratorClassName(function, isAsync);
            if (componentType == null && !JSTypeUtils.isAnyType(returnType2)) {
                LocalQuickFix[] localQuickFixArray;
                JSProblemReporter<Void> jSProblemReporter = this.getProblemReporter(function);
                String string = JavaScriptBundle.message("typescript.validation.generators.incorrect.type.annotation", returnType2.getTypeText(JSType.TypeTextFormat.PRESENTABLE));
                ProblemHighlightType problemHighlightType = TypeScriptUtil.getProblemHighlightTypeForType(returnType2);
                if (typeElement instanceof TypeScriptType) {
                    LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                    localQuickFixArray = localQuickFixArray2;
                    localQuickFixArray2[0] = JSFixFactory.getInstance().createWrapWithGenericTypeFix(iteratorClassName, (TypeScriptType)typeElement);
                } else {
                    localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
                }
                jSProblemReporter.registerProblem(typeElement, null, string, problemHighlightType, localQuickFixArray);
            } else if (componentType != null && !returnType2.isDirectlyAssignableType(iterableIteratorGeneric = new JSGenericTypeImpl((iterableRawType = JSNamedTypeFactory.createExplicitlyDeclaredType(iteratorClassName, typeElement)).getSource(), iterableRawType, componentType), context2 = JSTypeComparingContextService.createProcessingContextWithCache(function))) {
                LocalQuickFix[] localQuickFixArray;
                JSProblemReporter<Void> jSProblemReporter = this.getProblemReporter(function);
                String string = JavaScriptBundle.message("typescript.validation.generators.incorrect.type.annotation.iterable", iterableIteratorGeneric.getTypeText(JSType.TypeTextFormat.PRESENTABLE), returnType2.getTypeText(JSType.TypeTextFormat.PRESENTABLE));
                ProblemHighlightType problemHighlightType = TypeScriptUtil.getProblemHighlightTypeForType(returnType2);
                if (TypeScriptTypeInspectionVisitor.shouldSuggestWrapFix(returnType2, iteratorClassName)) {
                    LocalQuickFix[] localQuickFixArray3 = new LocalQuickFix[1];
                    localQuickFixArray = localQuickFixArray3;
                    localQuickFixArray3[0] = JSFixFactory.getInstance().createWrapWithGenericTypeFix(iteratorClassName, (TypeScriptType)typeElement);
                } else {
                    localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
                }
                jSProblemReporter.registerProblem(typeElement, null, string, problemHighlightType, localQuickFixArray);
            }
        } else {
            if (function.getBlock() == null) {
                return;
            }
            JSType elementType = returnType2 instanceof JSGenericTypeImpl ? (JSType)ContainerUtil.getFirstItem(((JSGenericTypeImpl)returnType2).getArguments()) : null;
            PsiElement identifier = TypeScriptTypeInspectionVisitor.getIdentifierElement(function);
            if ((elementType instanceof JSAnyType || elementType instanceof JSUndefinedType) && !elementType.isSourceStrict()) {
                this.getProblemReporter(identifier).registerProblem(identifier, null, JavaScriptBundle.message(isAsync ? "typescript.validation.generators.async.no.yield" : "typescript.validation.generators.no.yield", new Object[0]), ProblemHighlightType.GENERIC_ERROR, new LocalQuickFix[0]);
            }
        }
    }

    private static boolean shouldSuggestWrapFix(@Nullable JSType type2, @NotNull String iteratorClassName) {
        if (iteratorClassName == null) {
            TypeScriptTypeInspectionVisitor.$$$reportNull$$$0(6);
        }
        if (!(type2 instanceof JSGenericTypeImpl)) {
            return true;
        }
        JSType innerType = ((JSGenericTypeImpl)type2).getType();
        return !(innerType instanceof JSNamedType) || !iteratorClassName.equals(((JSNamedType)innerType).getQualifiedName().getQualifiedName());
    }

    @NotNull
    private static PsiElement getIdentifierElement(JSFunction function) {
        Object identifier = null;
        if (function instanceof JSFunctionExpression) {
            JSQualifiedNamedElement to = ((JSFunctionExpression)function).getElementAssignedTo();
            if (to != null) {
                identifier = to.getNameIdentifier();
            }
        } else {
            identifier = function.getNameIdentifier();
        }
        if (identifier == null && function instanceof JSComputedPropertyNameOwner) {
            identifier = ((JSComputedPropertyNameOwner)((Object)function)).getComputedPropertyName();
        }
        if (identifier == null) {
            identifier = function;
        }
        PsiElement psiElement = identifier;
        if (psiElement == null) {
            TypeScriptTypeInspectionVisitor.$$$reportNull$$$0(7);
        }
        return psiElement;
    }

    @Override
    protected void validateSetter(@NotNull JSFunction setter, @NotNull JSFunction getter, JSParameterListElement param, JSType setterType, JSType retType) {
        if (setter == null) {
            TypeScriptTypeInspectionVisitor.$$$reportNull$$$0(8);
        }
        if (getter == null) {
            TypeScriptTypeInspectionVisitor.$$$reportNull$$$0(9);
        }
    }

    @Override
    public void visitJSFunctionExpression(@NotNull JSFunctionExpression node) {
        if (node == null) {
            TypeScriptTypeInspectionVisitor.$$$reportNull$$$0(10);
        }
        if (!this.isAcceptable(node)) {
            return;
        }
        super.visitJSFunctionExpression(node);
        this.validateFunctionReturnTypeElement(node);
    }

    @Override
    protected void checkFunctionDeclaration(@NotNull JSFunction function) {
        if (function == null) {
            TypeScriptTypeInspectionVisitor.$$$reportNull$$$0(11);
        }
        if (!this.isAcceptable(function)) {
            return;
        }
        super.checkFunctionDeclaration(function);
        this.validateFunctionReturnTypeElement(function);
    }

    @Override
    protected boolean forCallExpression(JSCallExpression node) {
        if (!super.forCallExpression(node)) {
            return false;
        }
        JSExpression methodExpression = node.getMethodExpression();
        if (methodExpression instanceof JSReferenceExpression) {
            Object[] results = ((JSReferenceExpression)methodExpression).multiResolve(false);
            PsiElement element2 = JSResolveResult.resolve((ResolveResult[])results);
            if (element2 != null) {
                JSResolveResult resolveResult = (JSResolveResult)ContainerUtil.find((Object[])results, result2 -> result2 instanceof JSResolveResult && result2.getElement() == element2);
                JSTypeSubstitutor substitutor = resolveResult == null ? null : resolveResult.getTypeSubstitutor();
                this.getFunctionSignatureChecker((PsiElement)node).checkFunction(node, element2, substitutor == null ? JSTypeSubstitutor.EMPTY : substitutor);
            }
        } else if (methodExpression instanceof JSSuperExpression && JSClassUtils.canHaveClasses((PsiElement)node)) {
            PsiElement element3;
            PsiReference psiReference = methodExpression.getReference();
            PsiElement psiElement = element3 = psiReference != null ? psiReference.resolve() : null;
            if (element3 != null) {
                this.getFunctionSignatureChecker((PsiElement)node).checkFunction(node, element3);
            }
        } else if (methodExpression instanceof JSFunctionExpression) {
            this.getFunctionSignatureChecker((PsiElement)node).checkFunction(node, (PsiElement)methodExpression);
        }
        return true;
    }

    @NotNull
    private JSProblemReporter<Void> getProblemReporter(@NotNull PsiElement context2) {
        if (context2 == null) {
            TypeScriptTypeInspectionVisitor.$$$reportNull$$$0(12);
        }
        JSProblemReporter<Void> baseReporter = JSAnalysisHandlersFactory.forElement(context2).getProblemReporter(this.myHolder);
        JSProblemReporter<Void> jSProblemReporter = this.myProvider.getTypeCheckProblemReporter(baseReporter);
        if (jSProblemReporter == null) {
            TypeScriptTypeInspectionVisitor.$$$reportNull$$$0(13);
        }
        return jSProblemReporter;
    }

    @Override
    protected JSTypeChecker getNonEmptyTypeChecker(@NotNull PsiElement context2) {
        if (context2 == null) {
            TypeScriptTypeInspectionVisitor.$$$reportNull$$$0(14);
        }
        return JSAnalysisHandlersFactory.forElement(context2).getTypeChecker(this.getProblemReporter(context2));
    }

    @Override
    protected JSTypeChecker getTypeChecker(@NotNull PsiElement context2) {
        if (context2 == null) {
            TypeScriptTypeInspectionVisitor.$$$reportNull$$$0(15);
        }
        return this.myProvider.useEmptyTypeChecker() ? JSEmptyTypeChecker.getInstance() : this.getNonEmptyTypeChecker(context2);
    }

    @Override
    @NotNull
    protected JSFunctionSignatureChecker getFunctionSignatureChecker(@NotNull PsiElement context2) {
        if (context2 == null) {
            TypeScriptTypeInspectionVisitor.$$$reportNull$$$0(16);
        }
        JSFunctionSignatureChecker jSFunctionSignatureChecker = JSAnalysisHandlersFactory.forElement(context2).getFunctionSignatureChecker(this.myHolder, this.getNonEmptyTypeChecker(context2));
        if (jSFunctionSignatureChecker == null) {
            TypeScriptTypeInspectionVisitor.$$$reportNull$$$0(17);
        }
        return jSFunctionSignatureChecker;
    }

    @Override
    public void visitJSIndexedPropertyAccessExpression(@NotNull JSIndexedPropertyAccessExpression node) {
        JSExpression qualifier;
        JSType jsType;
        if (node == null) {
            TypeScriptTypeInspectionVisitor.$$$reportNull$$$0(18);
        }
        if (!this.isAcceptable((PsiElement)node)) {
            return;
        }
        super.visitJSIndexedPropertyAccessExpression(node);
        if (!node.isElvis() && (jsType = JSResolveUtil.getExpressionJSType(qualifier = node.getQualifier())) instanceof JSUnionType && ((JSUnionType)jsType).getTypes().stream().anyMatch(t -> JSTypeUtils.isNullOrUndefinedType(t))) {
            JSReferenceChecker checker = JSAnalysisHandlersFactory.forElement((PsiElement)node).getReferenceChecker(new JSReferenceProblemReporter(this.myHolder));
            SmartList fixes = new SmartList();
            checker.addSurroundWithTypeGuardFix(qualifier, (List<? super LocalQuickFix>)fixes, TypeScriptTypeGuardFixHelper.INDEXER_PROP);
            this.getNonEmptyTypeChecker((PsiElement)node).registerProblem((PsiElement)(qualifier instanceof JSReferenceExpression ? ((JSReferenceExpression)qualifier).getReferenceNameElement() : qualifier), JavaScriptBundle.message("javascript.term.nullable.indexer.qualifier", new Object[0]), ValidateTypesUtil.getHighlightTypeForTypeOrSignatureProblem((PsiElement)node), (LocalQuickFix[])ContainerUtil.toArray((Collection)fixes, LocalQuickFix[]::new));
        }
    }

    @Override
    public void visitTypeScriptTemplateLiteralType(@NotNull TypeScriptTemplateLiteralType templateLiteralType) {
        if (templateLiteralType == null) {
            TypeScriptTypeInspectionVisitor.$$$reportNull$$$0(19);
        }
        if (!this.isAcceptable((PsiElement)templateLiteralType)) {
            return;
        }
        super.visitTypeScriptTemplateLiteralType(templateLiteralType);
        JSTypeEvaluationLocationProvider.withTypeEvaluationLocation((PsiElement)templateLiteralType, () -> this.getTypeChecker((PsiElement)templateLiteralType).checkTemplateLiteralTypeSpansAssignability(templateLiteralType));
    }

    @Override
    protected boolean isAny(@Nullable JSType type2) {
        return type2 == null || type2 instanceof JSAnyType || type2 instanceof JSUnionType && ((JSUnionType)type2).isAnyType();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 13, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeElement";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnType";
                break;
            }
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iteratorClassName";
                break;
            }
            case 7: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/TypeScriptTypeInspectionVisitor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setter";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getter";
                break;
            }
            case 10: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateLiteralType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/TypeScriptTypeInspectionVisitor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdentifierElement";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getProblemReporter";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionSignatureChecker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "validateAsyncReturnType";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "validateGeneratorReturnType";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "shouldSuggestWrapFix";
                break;
            }
            case 7: 
            case 13: 
            case 17: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "validateSetter";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "visitJSFunctionExpression";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "checkFunctionDeclaration";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getProblemReporter";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getNonEmptyTypeChecker";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getTypeChecker";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionSignatureChecker";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "visitJSIndexedPropertyAccessExpression";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "visitTypeScriptTemplateLiteralType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 13, 17 -> new IllegalStateException(string);
        };
    }
}

