/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.javascript.validation.fixes.BaseCreateFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class JSRemoveInitializerQuickFix
implements LocalQuickFix {
    @Nls
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message("js.remove.redundant.initializer.fix", new Object[0]);
        if (string == null) {
            JSRemoveInitializerQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        JSType type2;
        JSVariable parent;
        if (project == null) {
            JSRemoveInitializerQuickFix.$$$reportNull$$$0(1);
        }
        if (descriptor == null) {
            JSRemoveInitializerQuickFix.$$$reportNull$$$0(2);
        }
        if ((parent = (JSVariable)ObjectUtils.tryCast((Object)descriptor.getStartElement().getParent(), JSVariable.class)) == null) {
            return;
        }
        JSExpression initializer = parent.getInitializer();
        DialectOptionHolder dialectOptionHolder = DialectDetector.dialectOfElement((PsiElement)initializer);
        if (dialectOptionHolder != null && dialectOptionHolder.isTypeScript && (type2 = JSResolveUtil.getExpressionJSType(initializer)) != null && parent.getTypeElement() == null) {
            JSRefactoringUtil.setType(parent, BaseCreateFix.getTypeText(type2, (PsiElement)initializer));
        }
        JSRefactoringUtil.removeInitializer(parent);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/fixes/JSRemoveInitializerQuickFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/fixes/JSRemoveInitializerQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

