/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.intentions;

import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.ecmascript6.TypeScriptQualifiedNameResolver;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.modules.JSImportCandidateDescriptor;
import com.intellij.lang.javascript.modules.imports.JSImportExportType;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.typescript.psi.TypeScriptExternalModuleReference;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptConvertImportRequireIntention
extends JavaScriptIntention {
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message("typescript.intention.convert.import.require", new Object[0]);
        if (string == null) {
            TypeScriptConvertImportRequireIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element2) throws IncorrectOperationException {
        JSImportCandidateDescriptor descriptor;
        if (project == null) {
            TypeScriptConvertImportRequireIntention.$$$reportNull$$$0(1);
        }
        if (element2 == null) {
            TypeScriptConvertImportRequireIntention.$$$reportNull$$$0(2);
        }
        if ((descriptor = TypeScriptConvertImportRequireIntention.createImportDescriptor(element2)) == null) {
            return;
        }
        JSSourceElement createdImport = ES6ImportPsiUtil.createImportOrExport(element2, descriptor);
        TypeScriptImportStatement importStatement = (TypeScriptImportStatement)PsiTreeUtil.getContextOfType((PsiElement)element2, (Class[])new Class[]{TypeScriptImportStatement.class});
        assert (importStatement != null);
        PsiElement replace = importStatement.replace((PsiElement)createdImport);
        ES6CreateImportUtil.optimizeImports(replace);
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element2) {
        JSImportCandidateDescriptor descriptor;
        if (project == null) {
            TypeScriptConvertImportRequireIntention.$$$reportNull$$$0(3);
        }
        if (element2 == null) {
            TypeScriptConvertImportRequireIntention.$$$reportNull$$$0(4);
        }
        if ((descriptor = TypeScriptConvertImportRequireIntention.createImportDescriptor(element2)) == null) {
            return false;
        }
        String text = ES6ImportPsiUtil.createImportOrExportText(element2, descriptor, false);
        String quote = ES6ImportPsiUtil.invertQuote(JSCodeStyleSettings.getQuote(element2));
        this.setText(JavaScriptBundle.message("typescript.intention.convert.import.require.text", quote + text + quote));
        return true;
    }

    @Nullable
    private static JSImportCandidateDescriptor createImportDescriptor(@NotNull TypeScriptImportStatement importStatement, @NotNull ES6ImportPsiUtil.ImportExportType importType) {
        if (importStatement == null) {
            TypeScriptConvertImportRequireIntention.$$$reportNull$$$0(5);
        }
        if (importType == null) {
            TypeScriptConvertImportRequireIntention.$$$reportNull$$$0(6);
        }
        TypeScriptExternalModuleReference reference = importStatement.getExternalModuleReference();
        assert (reference != null);
        String quoted = reference.getReferenceText();
        if (StringUtil.isEmpty((String)quoted)) {
            return null;
        }
        String text = JSStringUtil.unquoteAndUnescapeString(quoted);
        if (StringUtil.isEmpty((String)text)) {
            return null;
        }
        ES6ImportExportDeclaration.ImportExportPrefixKind kind = importStatement.isTypeImport() ? ES6ImportExportDeclaration.ImportExportPrefixKind.IMPORT_TYPE : ES6ImportExportDeclaration.ImportExportPrefixKind.IMPORT;
        String name = importStatement.getName();
        return new JSImportCandidateDescriptor(text, name, null, kind, (JSImportExportType)importType);
    }

    @Nullable
    private static ES6ImportPsiUtil.ImportExportType calculateImportType(@NotNull TypeScriptImportStatement importStatement) {
        VirtualFile file;
        if (importStatement == null) {
            TypeScriptConvertImportRequireIntention.$$$reportNull$$$0(7);
        }
        if ((file = PsiUtilCore.getVirtualFile((PsiElement)importStatement)) == null) {
            return ES6ImportPsiUtil.ImportExportType.IMPORT_BINDING_ALL;
        }
        TypeScriptConfig config = TypeScriptConfigService.Provider.get(importStatement.getProject()).getPreferableConfig(file);
        boolean allowDefault = config != null && (config.esModuleInterop() || config.allowSyntheticDefaultImports());
        TypeScriptQualifiedNameResolver resolver = new TypeScriptQualifiedNameResolver((PsiElement)importStatement);
        Collection<PsiElement> elements = resolver.expandElement((PsiElement)importStatement);
        if (elements.isEmpty()) {
            return null;
        }
        if (!allowDefault) {
            if (!ContainerUtil.and(elements, el -> el instanceof PsiFile || el instanceof TypeScriptModule)) {
                return null;
            }
            return ES6ImportPsiUtil.ImportExportType.IMPORT_BINDING_ALL;
        }
        if (elements.size() == 1) {
            PsiElement item = (PsiElement)ContainerUtil.getFirstItem(elements);
            if (!(item instanceof JSFile) || !ES6PsiUtil.isExternalModule(item)) {
                return ES6ImportPsiUtil.ImportExportType.DEFAULT;
            }
            VirtualFile itemVFile = ((JSFile)item).getVirtualFile();
            return TypeScriptUtil.isDefinitionFile(itemVFile) ? ES6ImportPsiUtil.ImportExportType.DEFAULT : ES6ImportPsiUtil.ImportExportType.IMPORT_BINDING_ALL;
        }
        return ES6ImportPsiUtil.ImportExportType.IMPORT_BINDING_ALL;
    }

    @Nullable
    private static JSImportCandidateDescriptor createImportDescriptor(@NotNull PsiElement element2) {
        TypeScriptImportStatement importStatement;
        if (element2 == null) {
            TypeScriptConvertImportRequireIntention.$$$reportNull$$$0(8);
        }
        if ((importStatement = (TypeScriptImportStatement)PsiTreeUtil.getContextOfType((PsiElement)element2, (Class[])new Class[]{TypeScriptImportStatement.class})) == null) {
            return null;
        }
        TypeScriptExternalModuleReference reference = importStatement.getExternalModuleReference();
        if (reference == null) {
            return null;
        }
        PsiElement parent = importStatement.getParent();
        if (!ES6PsiUtil.isExternalModule(parent)) {
            return null;
        }
        ES6ImportPsiUtil.ImportExportType importType = TypeScriptConvertImportRequireIntention.calculateImportType(importStatement);
        if (importType == null) {
            return null;
        }
        return TypeScriptConvertImportRequireIntention.createImportDescriptor(importStatement, importType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/intentions/TypeScriptConvertImportRequireIntention";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importStatement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/intentions/TypeScriptConvertImportRequireIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createImportDescriptor";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "calculateImportType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8 -> new IllegalArgumentException(string);
        };
    }
}

