/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.refactoring;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.evaluation.JSTypeEvaluationLocationProvider;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.names.JSNameSuggestionsUtil;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptConditionalType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptGenericOrMappedTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInferType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptMappedTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptParenthesizedType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptSingleType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptThisType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSUseScopeProvider;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.lang.javascript.refactoring.JSIntroduceTargetChooser;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseIntroduceHandler;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.introduce.inplace.OccurrencesChooser;
import com.intellij.refactoring.rename.inplace.InplaceRefactoring;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TypeScriptExtractNamedTypeHandler
implements RefactoringActionHandler {
    @NotNull
    private final JSIntroduceTargetChooser<JSTypeDeclaration> myTypeChooser;
    @NotNull
    private final ReplaceAllChooser myReplaceAllChooser;
    protected static final String DEFAULT_NAME = "Created";
    protected static final String THIS_GENERIC_NAME = "TThis";
    protected static final String INFER_GENERIC_NAME_PREFIX = "TInfer";
    protected static final String THIS_GENERIC_TEMP_NAME = "_tmp_WS_TThis";
    protected static final String INFER_GENERIC_TEMP_NAME_PREFIX = "_tmp_WS_TInfer";

    public TypeScriptExtractNamedTypeHandler(@NotNull JSIntroduceTargetChooser<JSTypeDeclaration> typeChooser, @NotNull ReplaceAllChooser chooser) {
        if (typeChooser == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(0);
        }
        if (chooser == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(1);
        }
        this.myTypeChooser = typeChooser;
        this.myReplaceAllChooser = chooser;
    }

    public TypeScriptExtractNamedTypeHandler() {
        this((editor, expressions, callback, renderer) -> IntroduceTargetChooser.showChooser((Editor)editor, (List)expressions, (Pass)Pass.create((Consumer)callback), (Function)renderer), TypeScriptExtractNamedTypeHandler::showOccurrencesChooser);
    }

    public boolean isAvailableOnEditorAndFile(@NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(2);
        }
        if (file == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(3);
        }
        return !ContainerUtil.isEmpty(this.getCandidates(editor, file));
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
        if (project == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(4);
        }
        if (elements == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(5);
        }
        throw new UnsupportedOperationException();
    }

    @NlsContexts.Command
    protected String getCommandName() {
        return JavaScriptBundle.message("extract.interface.command.name", new Object[0]);
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, DataContext dataContext) {
        if (project == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(6);
        }
        if (editor == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(7);
        }
        if (file == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(8);
        }
        this.invoke(editor, file);
    }

    public void invoke(@NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(9);
        }
        if (file == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(10);
        }
        List<Candidate> types = this.getCandidates(editor, file);
        Consumer<Candidate> callback = selectedType -> WriteCommandAction.runWriteCommandAction((Project)file.getProject(), (String)this.getCommandName(), null, () -> this.invokeForType(editor, (Candidate)selectedType), (PsiFile[])new PsiFile[]{file});
        this.chooseType(editor, types, TypeScriptExtractNamedTypeHandler.writeCallback(callback));
    }

    private void invokeForType(@NotNull Editor editor, @NotNull Candidate target2) {
        List<JSTypeDeclaration> occurrences;
        if (editor == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(11);
        }
        if (target2 == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(12);
        }
        target2 = this.adjustCandidate(target2);
        Pair<JSElement, GenericsInfo> pair = TypeScriptExtractNamedTypeHandler.getScopeAndGenerics(target2);
        JSElement scope2 = (JSElement)pair.first;
        if (scope2 == null) {
            return;
        }
        List<JSTypeDeclaration> list = occurrences = target2.relativeRange == null ? TypeScriptExtractNamedTypeHandler.findOccurrences(target2.type, scope2) : ContainerUtil.emptyList();
        if (occurrences.size() > 1) {
            Candidate finalTarget = target2;
            Consumer<OccurrencesChooser.ReplaceChoice> callback = choice -> {
                List toReplace = choice == OccurrencesChooser.ReplaceChoice.ALL ? occurrences : ContainerUtil.emptyList();
                this.invokeForOccurrences(editor, finalTarget, toReplace, scope2, (GenericsInfo)pair.second);
            };
            this.myReplaceAllChooser.invoke(editor, target2.type, occurrences, TypeScriptExtractNamedTypeHandler.writeCallback(callback));
        } else {
            this.invokeForOccurrences(editor, target2, occurrences, scope2, (GenericsInfo)pair.second);
        }
    }

    protected Candidate adjustCandidate(Candidate target2) {
        HashSet<String> names = new HashSet<String>();
        for (PsiElement parent = target2.type.getParent(); parent != null && !(parent instanceof PsiFile); parent = parent.getParent()) {
            if (!(parent instanceof TypeScriptTypeParameterListOwner)) continue;
            names.addAll(ContainerUtil.map((Object[])((TypeScriptTypeParameterListOwner)parent).getTypeParameters(), p -> p.getName()));
        }
        return TypeScriptExtractNamedTypeHandler.adjustWithGenerics(target2, names);
    }

    void invokeForOccurrences(@NotNull Editor editor, @NotNull Candidate target2, @NotNull List<JSTypeDeclaration> occurrences, @NotNull JSElement scope2, @NotNull GenericsInfo genericParameters) {
        if (editor == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(13);
        }
        if (target2 == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(14);
        }
        if (occurrences == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(15);
        }
        if (scope2 == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(16);
        }
        if (genericParameters == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(17);
        }
        JSTypeEvaluationLocationProvider.withTypeEvaluationLocation((PsiElement)scope2, () -> this.invokeForOccurrencesUnderEvalLocation(editor, target2, occurrences, scope2, genericParameters));
    }

    private void invokeForOccurrencesUnderEvalLocation(@NotNull Editor editor, @NotNull Candidate target2, @NotNull List<JSTypeDeclaration> occurrences, @NotNull JSElement scope2, @NotNull GenericsInfo genericParameters) {
        if (editor == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(18);
        }
        if (target2 == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(19);
        }
        if (occurrences == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(20);
        }
        if (scope2 == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(21);
        }
        if (genericParameters == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(22);
        }
        JSTypeDeclaration firstInScope = !occurrences.isEmpty() && occurrences.get(0).getTextRange().getStartOffset() < target2.type.getTextRange().getStartOffset() ? occurrences.get(0) : target2.type;
        PsiElement anchor = PsiTreeUtil.findFirstParent((PsiElement)firstInScope, t -> {
            PsiElement parent = t.getParent();
            return scope2.isEquivalentTo(parent) || parent instanceof JSBlockStatement && scope2.isEquivalentTo(parent.getParent());
        });
        if ((anchor = JSPsiImplUtils.findLeadingCommentOrSelf(anchor)) == null) {
            return;
        }
        JSType jsType = TypeScriptExtractNamedTypeHandler.getJSType(target2.type);
        List<String> nameCandidates = this.getNameCandidates(scope2, jsType);
        HashMap<String, String> customNames = new HashMap<String, String>();
        List genericNames = ContainerUtil.map(genericParameters.genericParameters, t -> t instanceof TypeScriptThisType ? THIS_GENERIC_TEMP_NAME : (t instanceof TypeScriptTypeParameter ? t.getText() : t.getName()));
        List allInferItems = ContainerUtil.map(genericParameters.inferParameters, t -> INFER_GENERIC_TEMP_NAME_PREFIX + t.getVariableName());
        ArrayList<String> names = new ArrayList<String>(genericNames.size() + allInferItems.size());
        names.addAll(genericNames);
        names.addAll(allInferItems);
        customNames.put(THIS_GENERIC_TEMP_NAME, JSNameSuggestionsUtil.ensureUniqueVariableName(THIS_GENERIC_NAME, null, names, true));
        for (String name : names) {
            if (!name.startsWith(INFER_GENERIC_TEMP_NAME_PREFIX)) continue;
            String realName = name.substring(INFER_GENERIC_TEMP_NAME_PREFIX.length());
            customNames.put(name, JSNameSuggestionsUtil.ensureUniqueVariableName(INFER_GENERIC_NAME_PREFIX + realName, null, names, true));
        }
        String introducedText = target2.relativeRange != null ? target2.relativeRange.substring(target2.type.getText()) : this.getSimplifiedType((JSTypeDeclaration)target2.type.copy(), customNames).getText();
        String genericParametersText = genericParameters.isEmpty() ? "" : "<" + StringUtil.join(names, t -> customNames.containsKey(t) ? (String)customNames.get(t) : t, (String)", ") + ">";
        JSClass typeDeclaration = this.buildTypeDeclarationFromText(nameCandidates.get(0), genericParametersText, introducedText, (PsiElement)target2.type);
        typeDeclaration = (JSClass)anchor.getParent().addBefore((PsiElement)typeDeclaration, anchor);
        JSChangeUtil.addWs(anchor.getParent().getNode(), anchor.getNode(), "\n");
        List generics = ContainerUtil.map(genericParameters.genericParameters, t -> t instanceof TypeScriptThisType ? "this" : t.getName());
        List inferArguments = ContainerUtil.map(genericParameters.inferParameters, t -> "infer " + t.getVariableName());
        ArrayList genericArguments = new ArrayList(inferArguments.size() + generics.size());
        genericArguments.addAll(generics);
        genericArguments.addAll(inferArguments);
        String genericArgumentsText = genericArguments.isEmpty() ? "" : "<" + StringUtil.join(genericArguments, (String)", ") + ">";
        String usageReplacementText = nameCandidates.get(0) + genericArgumentsText;
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)target2.type.getProject());
        List occurrencesPointers = ContainerUtil.mapNotNull(occurrences, o -> {
            if (o == target2.type) {
                return null;
            }
            JSReferenceExpression replacement = TypeScriptExtractNamedTypeHandler.replaceUsage(o, null, usageReplacementText);
            if (replacement == null) {
                return null;
            }
            return smartPointerManager.createSmartPsiElementPointer((PsiElement)replacement);
        });
        JSElement usageReplacement = TypeScriptExtractNamedTypeHandler.replaceUsage(target2.type, target2.relativeRange, usageReplacementText);
        if (usageReplacement == null) {
            return;
        }
        SmartPsiElementPointer usageReplacementPointer = smartPointerManager.createSmartPsiElementPointer((PsiElement)usageReplacement);
        FormatFixer fixer = FormatFixer.create(typeDeclaration, FormatFixer.Mode.Reformat);
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)typeDeclaration.getProject());
        Document document = documentManager.getDocument(typeDeclaration.getContainingFile());
        if (document == null) {
            return;
        }
        documentManager.doPostponedOperationsAndUnblockDocument(document);
        usageReplacement = (JSElement)usageReplacementPointer.getElement();
        if (usageReplacement == null) {
            return;
        }
        List filteredOccurrences = ContainerUtil.mapNotNull((Collection)occurrencesPointers, pointer -> (JSElement)pointer.getElement());
        TypeScriptExtractNamedTypeHandler.startTemplate(editor, usageReplacement, filteredOccurrences, nameCandidates, typeDeclaration, (PsiElement)scope2, () -> ApplicationManager.getApplication().runWriteAction(() -> fixer.fixFormat()));
    }

    protected boolean shouldForceSemicolons() {
        return true;
    }

    @NotNull
    protected JSTypeDeclaration getSimplifiedType(@NotNull JSTypeDeclaration targetType, Map<String, String> thisName) {
        if (targetType == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(23);
        }
        while (targetType instanceof TypeScriptParenthesizedType) {
            TypeScriptType innerType = ((TypeScriptParenthesizedType)targetType).getInnerType();
            if (innerType == null) {
                JSTypeDeclaration jSTypeDeclaration = targetType;
                if (jSTypeDeclaration == null) {
                    TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(24);
                }
                return jSTypeDeclaration;
            }
            targetType = innerType;
        }
        if (!this.shouldForceSemicolons()) {
            JSTypeDeclaration jSTypeDeclaration = targetType;
            if (jSTypeDeclaration == null) {
                TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(25);
            }
            return jSTypeDeclaration;
        }
        if (targetType instanceof TypeScriptObjectType) {
            String semicolon = JSCodeStyleSettings.getSemicolon((PsiElement)targetType);
            boolean emptySemicolon = StringUtil.isEmpty((String)semicolon);
            for (TypeScriptTypeMember member : ((TypeScriptObjectType)targetType).getTypeMembers()) {
                PsiElement sibling = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)member);
                IElementType elementType = PsiUtilCore.getElementType((PsiElement)sibling);
                if (elementType == JSTokenTypes.COMMA) {
                    if (emptySemicolon) {
                        Objects.requireNonNull(sibling).delete();
                        continue;
                    }
                    Objects.requireNonNull(sibling).replace(JSChangeUtil.createSemicolonPsiElement(sibling, semicolon));
                    continue;
                }
                if (elementType == JSTokenTypes.SEMICOLON || emptySemicolon) continue;
                member.getParent().addAfter(JSChangeUtil.createSemicolonPsiElement(member, semicolon), (PsiElement)member);
            }
        }
        JSTypeDeclaration jSTypeDeclaration = targetType;
        if (jSTypeDeclaration == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(26);
        }
        return jSTypeDeclaration;
    }

    @NotNull
    protected List<String> getNameCandidates(@NotNull JSElement scope2, JSType jsType) {
        List<String> nameCandidates;
        if (scope2 == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(27);
        }
        List<String> list = nameCandidates = jsType != null ? JSNameSuggestionsUtil.generateTypeNamesFromType(jsType, (PsiElement)scope2) : ContainerUtil.emptyList();
        if (nameCandidates.isEmpty()) {
            List<String> list2 = Collections.singletonList(JSNameSuggestionsUtil.ensureUniqueVariableName(DEFAULT_NAME, (PsiElement)scope2, new HashSet<String>(), false));
            if (list2 == null) {
                TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(28);
            }
            return list2;
        }
        List<String> list3 = nameCandidates;
        if (list3 == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(29);
        }
        return list3;
    }

    private static Candidate adjustWithGenerics(Candidate target2, Set<String> genericNames) {
        SyntaxTraverser.psiTraverser((PsiElement)target2.type).filter(TypeScriptTypeParameter.class).forEach(p -> TypeScriptExtractNamedTypeHandler.renameIfNeeded(p, genericNames));
        return target2;
    }

    private static void renameIfNeeded(TypeScriptTypeParameter p, Set<String> names) {
        String name = p.getName();
        if (name == null || !names.contains(name)) {
            return;
        }
        int i = 1;
        Object finalName = name;
        while (names.contains(finalName)) {
            finalName = name + i;
            ++i;
        }
        String finalName1 = finalName;
        ReferencesSearch.search((PsiElement)p).asIterable().forEach(r -> {
            PsiElement element2 = r.getElement();
            if (element2 instanceof JSReferenceExpression) {
                element2.replace((PsiElement)JSPsiElementFactory.createJSExpression(finalName1, element2));
            }
        });
        p.setName((String)finalName);
    }

    @Nullable
    private static JSReferenceExpression replaceUsage(@NotNull JSTypeDeclaration type2, @Nullable TextRange range, @NotNull String text) {
        String replacementText;
        if (type2 == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(30);
        }
        if (text == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(31);
        }
        String string = replacementText = range == null ? text : type2.getText().substring(0, range.getStartOffset()) + text + type2.getText().substring(range.getEndOffset());
        if (type2 instanceof TypeScriptParenthesizedType) {
            JSBaseIntroduceHandler.fixWhitespacesForParentheses(type2);
        }
        JSTypeDeclaration replacement = (JSTypeDeclaration)type2.replace((PsiElement)JSPsiElementFactory.createTypeScriptType(replacementText, (PsiElement)type2));
        TextRange absoluteRange = range != null ? range.shiftRight(replacement.getTextRange().getStartOffset()) : null;
        Ref result2 = new Ref();
        PsiTreeUtil.processElements((PsiElement)replacement, element2 -> {
            if (element2 instanceof JSReferenceExpression && (absoluteRange == null || absoluteRange.contains(element2.getTextRange()))) {
                result2.set((Object)((JSReferenceExpression)element2));
                return false;
            }
            return true;
        });
        return (JSReferenceExpression)result2.get();
    }

    private static void startTemplate(@NotNull Editor editor, @NotNull JSElement target2, @NotNull List<JSElement> occurrencesWithoutMain, @NotNull List<String> nameCandidates, @NotNull JSClass typeDeclaration, @NotNull PsiElement scope2, @NotNull Runnable onComplete) {
        if (editor == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(32);
        }
        if (target2 == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(33);
        }
        if (occurrencesWithoutMain == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(34);
        }
        if (nameCandidates == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(35);
        }
        if (typeDeclaration == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(36);
        }
        if (scope2 == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(37);
        }
        if (onComplete == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(38);
        }
        editor.getCaretModel().moveToOffset(target2.getTextRange().getEndOffset());
        MyInplaceRefactoring refactoring = new MyInplaceRefactoring(editor, typeDeclaration, scope2, nameCandidates, target2, occurrencesWithoutMain, onComplete);
        boolean success = refactoring.performInplaceRefactoring(nameCandidates.size() == 1 ? new LinkedHashSet() : new LinkedHashSet<String>(nameCandidates));
        if (!success) {
            refactoring.finish(true);
        }
    }

    @NotNull
    static Pair<JSElement, GenericsInfo> getScopeAndGenerics(@NotNull Candidate candidate) {
        if (candidate == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(39);
        }
        Ref localTypesScope = new Ref();
        GenericsInfo info = new GenericsInfo(new LinkedHashSet<TypeScriptInferType>(), new LinkedHashSet<JSElement>());
        TextRange absoluteRange = candidate.relativeRange != null ? candidate.relativeRange.shiftRight(candidate.type.getTextRange().getStartOffset()) : null;
        TypeScriptExtractNamedTypeHandler.getScopeAndGenerics((PsiElement)candidate.type, absoluteRange, (Ref<PsiElement>)localTypesScope, info);
        if (!localTypesScope.isNull()) {
            Pair pair = Pair.create((Object)((JSElement)ObjectUtils.tryCast((Object)localTypesScope.get(), JSElement.class)), (Object)info);
            if (pair == null) {
                TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(40);
            }
            return pair;
        }
        JSElement scope2 = (JSElement)PsiTreeUtil.findFirstParent((PsiElement)candidate.type, element2 -> element2 instanceof JSFile || element2 instanceof TypeScriptModule || element2 instanceof JSEmbeddedContent && !JSPsiImplUtils.isEmbeddedTypeContext(element2) && !JSPsiImplUtils.isEmbeddedExpressionContent(element2));
        Pair pair = Pair.create((Object)scope2, (Object)info);
        if (pair == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(41);
        }
        return pair;
    }

    private static boolean isInConditionalCondition(TypeScriptConditionalType type2, TextRange range) {
        TypeScriptType testType = type2.getTestType();
        return testType != null && testType.getTextRange().contains(range);
    }

    static void getScopeAndGenerics(@Nullable PsiElement candidate, @Nullable TextRange textRange, @NotNull Ref<PsiElement> scopeRef, @NotNull GenericsInfo generics) {
        if (scopeRef == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(42);
        }
        if (generics == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(43);
        }
        if (candidate == null) {
            return;
        }
        TextRange range = textRange != null ? textRange : candidate.getTextRange();
        PsiTreeUtil.processElements((PsiElement)candidate, element2 -> {
            PsiElement nameScope;
            if (element2 instanceof TypeScriptThisType) {
                if (generics.genericParameters.stream().noneMatch(e -> e instanceof TypeScriptThisType)) {
                    generics.genericParameters.add((TypeScriptThisType)element2);
                }
                return true;
            }
            if (TypeScriptExtractNamedTypeHandler.addInferType(generics.inferParameters, range, element2)) {
                return true;
            }
            if (!(element2 instanceof TypeScriptSingleType)) {
                return true;
            }
            if (textRange != null && !textRange.contains(element2.getTextRange())) {
                return true;
            }
            JSReferenceExpression refExpr = ((TypeScriptSingleType)element2).getReferenceExpression();
            if (refExpr == null) {
                return true;
            }
            PsiElement resolved = refExpr.resolve();
            if (resolved instanceof JSNamedElement && (nameScope = JSUseScopeProvider.getUseScopeElement((JSNamedElement)resolved)) != null && (scopeRef.get() == null || PsiTreeUtil.isAncestor((PsiElement)((PsiElement)scopeRef.get()), (PsiElement)nameScope, (boolean)true))) {
                scopeRef.set((Object)nameScope);
            }
            if (resolved instanceof TypeScriptTypeParameter) {
                TypeScriptTypeParameter typeParameter = (TypeScriptTypeParameter)resolved;
                if (range.contains(resolved.getTextOffset())) {
                    return true;
                }
                if (generics.genericParameters.add(typeParameter)) {
                    TypeScriptExtractNamedTypeHandler.getScopeAndGenerics((PsiElement)typeParameter.getDefault(), null, scopeRef, generics);
                    TypeScriptExtractNamedTypeHandler.getScopeAndGenerics((PsiElement)typeParameter.getTypeConstraint(), null, scopeRef, generics);
                }
            } else if (resolved instanceof TypeScriptMappedTypeParameter || resolved instanceof TypeScriptInferType) {
                if (range.contains(resolved.getTextOffset())) {
                    return true;
                }
                generics.genericParameters.add((TypeScriptGenericOrMappedTypeParameter)resolved);
            }
            return true;
        });
    }

    private static boolean addInferType(@NotNull Collection<TypeScriptInferType> genericParameters, TextRange range, PsiElement element2) {
        if (genericParameters == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(44);
        }
        if (!(element2 instanceof TypeScriptInferType)) {
            return false;
        }
        TypeScriptConditionalType type2 = (TypeScriptConditionalType)PsiTreeUtil.getParentOfType((PsiElement)element2, TypeScriptConditionalType.class, (boolean)true);
        while (type2 != null) {
            if (TypeScriptExtractNamedTypeHandler.isInConditionalCondition(type2, range) && type2.getInferTypes().contains(element2) && genericParameters.stream().noneMatch(e -> Objects.equals(e.getVariableName(), ((TypeScriptInferType)element2).getVariableName()))) {
                genericParameters.add((TypeScriptInferType)element2);
            }
            type2 = (TypeScriptConditionalType)PsiTreeUtil.getParentOfType((PsiElement)type2, TypeScriptConditionalType.class, (boolean)true);
        }
        return true;
    }

    @NotNull
    protected abstract JSClass buildTypeDeclarationFromText(@NotNull String var1, @NotNull String var2, @NotNull String var3, @NotNull PsiElement var4);

    protected boolean isAcceptableType(@NotNull JSTypeDeclaration declaration) {
        if (declaration == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(45);
        }
        return !(declaration.getParent() instanceof TypeScriptInterface);
    }

    @NotNull
    private static List<JSTypeDeclaration> findOccurrences(@NotNull JSTypeDeclaration typeDeclaration, @NotNull JSElement scope2) {
        if (typeDeclaration == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(46);
        }
        if (scope2 == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(47);
        }
        ArrayList<JSTypeDeclaration> results = new ArrayList<JSTypeDeclaration>();
        PsiTreeUtil.processElements((PsiElement)scope2, e -> {
            if (e instanceof JSTypeDeclaration && !(e.getParent() instanceof TypeScriptInterface) && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)e, (PsiElement)typeDeclaration)) {
                results.add((JSTypeDeclaration)e);
            }
            return true;
        });
        ArrayList<JSTypeDeclaration> arrayList = results;
        if (arrayList == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(48);
        }
        return arrayList;
    }

    private void chooseType(Editor editor, List<Candidate> candidates, Consumer<Candidate> callback) {
        if (candidates.isEmpty()) {
            return;
        }
        if (candidates.size() == 1) {
            callback.accept(candidates.get(0));
        } else {
            List list = ContainerUtil.map(candidates, t -> t.type);
            this.myTypeChooser.invoke(editor, list, (? super TExpression selected) -> callback.accept((Candidate)ContainerUtil.find((Iterable)candidates, t -> t.type == selected)), (Function<JSTypeDeclaration, String>)((Function)declaration -> declaration.getText()));
        }
    }

    @NotNull
    private List<Candidate> getCandidates(@NotNull Editor editor, @NotNull PsiFile file) {
        SelectionModel selectionModel;
        if (editor == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(49);
        }
        if (file == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(50);
        }
        if ((selectionModel = editor.getSelectionModel()).hasSelection()) {
            Candidate fromSelection = TypeScriptExtractNamedTypeHandler.findTypeInRange(file, new TextRange(selectionModel.getSelectionStart(), selectionModel.getSelectionEnd()));
            List<Candidate> list = fromSelection != null && this.isAcceptableType(fromSelection.type) ? Collections.singletonList(fromSelection) : ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(51);
            }
            return list;
        }
        return this.lookUpCandidates(file, editor.getCaretModel().getOffset());
    }

    @Nullable
    private static Candidate findTypeInRange(@NotNull PsiFile file, @NotNull TextRange range) {
        if (file == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(52);
        }
        if (range == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(53);
        }
        JSTypeDeclaration startElement = TypeScriptExtractNamedTypeHandler.findTypeElementAt(file, range.getStartOffset(), true);
        JSTypeDeclaration endElement = TypeScriptExtractNamedTypeHandler.findTypeElementAt(file, range.getEndOffset(), false);
        if (startElement == null || endElement == null) {
            return null;
        }
        Condition rangeContainsCondition = element2 -> range.contains(element2.getTextRange());
        startElement = TypeScriptExtractNamedTypeHandler.findTopmostType(startElement, (Condition<PsiElement>)rangeContainsCondition);
        endElement = TypeScriptExtractNamedTypeHandler.findTopmostType(endElement, (Condition<PsiElement>)rangeContainsCondition);
        if (startElement == null || endElement == null) {
            return null;
        }
        if (startElement == endElement && range.contains(startElement.getTextRange())) {
            return new Candidate(startElement, null);
        }
        if (startElement.getParent() == endElement.getParent() && startElement.getParent() instanceof TypeScriptUnionOrIntersectionType) {
            PsiElement parent = startElement.getParent();
            TextRange meaningfulRange = new TextRange(startElement.getTextRange().getStartOffset(), endElement.getTextRange().getEndOffset());
            return parent.getTextRange().contains(meaningfulRange) ? new Candidate((JSTypeDeclaration)parent, meaningfulRange.shiftLeft(parent.getTextRange().getStartOffset())) : null;
        }
        return null;
    }

    @NotNull
    private List<Candidate> lookUpCandidates(@NotNull PsiFile file, int offset) {
        JSTypeDeclaration current;
        if (file == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(54);
        }
        if ((current = TypeScriptExtractNamedTypeHandler.findTypeElementAt(file, offset, true)) == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(55);
            }
            return list;
        }
        ArrayList<Candidate> types = new ArrayList<Candidate>();
        while (current != null) {
            Candidate last = (Candidate)ContainerUtil.getLastItem(types);
            if ((last == null || !current.getTextRange().equals((Object)last.type.getTextRange())) && this.isAcceptableType(current)) {
                types.add(new Candidate(current, null));
            }
            if (!((current = (JSTypeDeclaration)PsiTreeUtil.getParentOfType((PsiElement)current, JSTypeDeclaration.class)) instanceof TypeScriptParenthesizedType)) continue;
            current = (JSTypeDeclaration)PsiTreeUtil.getParentOfType((PsiElement)current, JSTypeDeclaration.class);
        }
        ArrayList<Candidate> arrayList = types;
        if (arrayList == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(56);
        }
        return arrayList;
    }

    @Nullable
    private static JSTypeDeclaration findTopmostType(@NotNull JSTypeDeclaration element2, @NotNull Condition<PsiElement> condition) {
        if (element2 == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(57);
        }
        if (condition == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(58);
        }
        if (!condition.value((Object)element2)) {
            return null;
        }
        JSTypeDeclaration parent = (JSTypeDeclaration)PsiTreeUtil.getParentOfType((PsiElement)element2, JSTypeDeclaration.class);
        while (parent != null && condition.value((Object)parent)) {
            element2 = parent;
            parent = (JSTypeDeclaration)PsiTreeUtil.getParentOfType((PsiElement)element2, JSTypeDeclaration.class);
        }
        return element2;
    }

    @Nullable
    private static JSTypeDeclaration findTypeElementAt(@NotNull PsiFile file, int offset, boolean forward) {
        PsiElement element2;
        if (file == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(59);
        }
        if ((element2 = file.findElementAt(offset == file.getTextLength() && !forward && offset > 0 ? offset - 1 : offset)) == null) {
            return null;
        }
        if (!forward) {
            element2 = PsiTreeUtil.prevLeaf((PsiElement)element2);
        }
        while (element2 != null && (element2 instanceof PsiWhiteSpace || element2 instanceof PsiComment || element2.getNode().getElementType() == JSTokenTypes.LPAR || element2.getNode().getElementType() == JSTokenTypes.RPAR)) {
            element2 = forward ? PsiTreeUtil.nextLeaf((PsiElement)element2) : PsiTreeUtil.prevLeaf((PsiElement)element2);
        }
        return (JSTypeDeclaration)PsiTreeUtil.getParentOfType((PsiElement)element2, JSTypeDeclaration.class);
    }

    @Nullable
    private static JSType getJSType(@NotNull JSTypeDeclaration typeDeclaration) {
        JSTypeDeclarationOwner owner;
        if (typeDeclaration == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(60);
        }
        return (owner = (JSTypeDeclarationOwner)ObjectUtils.tryCast((Object)typeDeclaration.getParent(), JSTypeDeclarationOwner.class)) != null ? owner.getJSType() : null;
    }

    private static <T> Consumer<T> writeCallback(Consumer<? super T> callback) {
        return t -> ApplicationManager.getApplication().runWriteAction(() -> CommandProcessor.getInstance().runUndoTransparentAction(() -> callback.accept(t)));
    }

    private static void showOccurrencesChooser(Editor editor, JSTypeDeclaration main, List<JSTypeDeclaration> occurrences, Consumer<? super OccurrencesChooser.ReplaceChoice> callback) {
        OccurrencesChooser.simpleChooser((Editor)editor).showChooser((Object)main, occurrences, Pass.create(callback));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 24, 25, 26, 28, 29, 40, 41, 48, 51, 55, 56 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeChooser";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chooser";
                break;
            }
            case 2: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 18: 
            case 32: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 8: 
            case 10: 
            case 50: 
            case 52: 
            case 54: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 12: 
            case 14: 
            case 19: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "occurrences";
                break;
            }
            case 16: 
            case 21: 
            case 27: 
            case 37: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 17: 
            case 22: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "genericParameters";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetType";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 40: 
            case 41: 
            case 48: 
            case 51: 
            case 55: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/refactoring/TypeScriptExtractNamedTypeHandler";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "occurrencesWithoutMain";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameCandidates";
                break;
            }
            case 36: 
            case 46: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeDeclaration";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onComplete";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeRef";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generics";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/refactoring/TypeScriptExtractNamedTypeHandler";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getSimplifiedType";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameCandidates";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeAndGenerics";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "findOccurrences";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getCandidates";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "lookUpCandidates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableOnEditorAndFile";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "invokeForType";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "invokeForOccurrences";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "invokeForOccurrencesUnderEvalLocation";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getSimplifiedType";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 40: 
            case 41: 
            case 48: 
            case 51: 
            case 55: 
            case 56: {
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getNameCandidates";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "replaceUsage";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "startTemplate";
                break;
            }
            case 39: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getScopeAndGenerics";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "addInferType";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableType";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "findOccurrences";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getCandidates";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "findTypeInRange";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "lookUpCandidates";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "findTopmostType";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "findTypeElementAt";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getJSType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 24, 25, 26, 28, 29, 40, 41, 48, 51, 55, 56 -> new IllegalStateException(string);
        };
    }

    public static interface ReplaceAllChooser {
        public void invoke(Editor var1, JSTypeDeclaration var2, List<JSTypeDeclaration> var3, Consumer<OccurrencesChooser.ReplaceChoice> var4);
    }

    static class Candidate {
        @NotNull
        public final JSTypeDeclaration type;
        @Nullable
        public final TextRange relativeRange;

        Candidate(@NotNull JSTypeDeclaration type2, @Nullable TextRange relativeRange) {
            if (type2 == null) {
                Candidate.$$$reportNull$$$0(0);
            }
            this.type = type2;
            this.relativeRange = relativeRange;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/typescript/refactoring/TypeScriptExtractNamedTypeHandler$Candidate", "<init>"));
        }
    }

    public static final class GenericsInfo {
        @NotNull
        Collection<TypeScriptInferType> inferParameters;
        @NotNull
        Collection<JSElement> genericParameters;

        private GenericsInfo(@NotNull Collection<TypeScriptInferType> inferParameters, @NotNull Collection<JSElement> genericParameters) {
            if (inferParameters == null) {
                GenericsInfo.$$$reportNull$$$0(0);
            }
            if (genericParameters == null) {
                GenericsInfo.$$$reportNull$$$0(1);
            }
            this.inferParameters = inferParameters;
            this.genericParameters = genericParameters;
        }

        public boolean isEmpty() {
            return this.inferParameters.isEmpty() && this.genericParameters.isEmpty();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "inferParameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "genericParameters";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/typescript/refactoring/TypeScriptExtractNamedTypeHandler$GenericsInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class MyInplaceRefactoring
    extends InplaceRefactoring {
        private final PsiElement myScope;
        private final JSElement myTarget;
        private final List<JSElement> myOccurrencesWithoutMain;
        private final Runnable myOnComplete;

        private MyInplaceRefactoring(@NotNull Editor editor, @NotNull JSClass typeDeclaration, @NotNull PsiElement scope2, @NotNull List<String> nameCandidates, @NotNull JSElement target2, @NotNull List<JSElement> occurrencesWithoutMain, @NotNull Runnable onComplete) {
            if (editor == null) {
                MyInplaceRefactoring.$$$reportNull$$$0(0);
            }
            if (typeDeclaration == null) {
                MyInplaceRefactoring.$$$reportNull$$$0(1);
            }
            if (scope2 == null) {
                MyInplaceRefactoring.$$$reportNull$$$0(2);
            }
            if (nameCandidates == null) {
                MyInplaceRefactoring.$$$reportNull$$$0(3);
            }
            if (target2 == null) {
                MyInplaceRefactoring.$$$reportNull$$$0(4);
            }
            if (occurrencesWithoutMain == null) {
                MyInplaceRefactoring.$$$reportNull$$$0(5);
            }
            if (onComplete == null) {
                MyInplaceRefactoring.$$$reportNull$$$0(6);
            }
            super(editor, (PsiNamedElement)typeDeclaration, scope2.getProject(), nameCandidates.get(0), null);
            this.myScope = scope2;
            this.myTarget = target2;
            this.myOccurrencesWithoutMain = occurrencesWithoutMain;
            this.myOnComplete = onComplete;
        }

        protected void collectAdditionalElementsToRename(@NotNull List<? super Pair<PsiElement, TextRange>> stringUsages) {
            if (stringUsages == null) {
                MyInplaceRefactoring.$$$reportNull$$$0(7);
            }
            stringUsages.add((Pair<PsiElement, TextRange>)Pair.create((Object)this.myTarget, (Object)new TextRange(0, this.myTarget.getTextLength())));
            for (JSElement element2 : this.myOccurrencesWithoutMain) {
                stringUsages.add((Pair<PsiElement, TextRange>)Pair.create((Object)element2, (Object)new TextRange(0, element2.getTextLength())));
            }
        }

        protected boolean shouldSelectAll() {
            return false;
        }

        protected String getCommandName() {
            return JavaScriptBundle.message("command.name.extract.named.type", new Object[0]);
        }

        protected boolean performRefactoring() {
            this.myOnComplete.run();
            return false;
        }

        @NotNull
        protected PsiElement checkLocalScope() {
            PsiElement psiElement = this.myScope;
            if (psiElement == null) {
                MyInplaceRefactoring.$$$reportNull$$$0(8);
            }
            return psiElement;
        }

        protected Collection<PsiReference> collectRefs(SearchScope referencesSearchScope) {
            return new ArrayList<PsiReference>();
        }

        protected PsiElement getSelectedInEditorElement(@Nullable PsiElement nameIdentifier, @NotNull Collection<? extends PsiReference> refs, @NotNull Collection<? extends Pair<PsiElement, TextRange>> stringUsages, int offset) {
            if (refs == null) {
                MyInplaceRefactoring.$$$reportNull$$$0(9);
            }
            if (stringUsages == null) {
                MyInplaceRefactoring.$$$reportNull$$$0(10);
            }
            return this.myTarget;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 8 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeDeclaration";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nameCandidates";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "occurrencesWithoutMain";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "onComplete";
                    break;
                }
                case 7: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stringUsages";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/typescript/refactoring/TypeScriptExtractNamedTypeHandler$MyInplaceRefactoring";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "refs";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/typescript/refactoring/TypeScriptExtractNamedTypeHandler$MyInplaceRefactoring";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "checkLocalScope";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "collectAdditionalElementsToRename";
                    break;
                }
                case 8: {
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "getSelectedInEditorElement";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 8 -> new IllegalStateException(string);
            };
        }
    }
}

