/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.editor;

import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.dataSource.srcStorage.DbSrcUtilsCore;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.basic.BasicRoutine;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbRoutine;
import com.intellij.database.run.actions.PerformRoutineActionBase;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PerformRoutineFromFileActionBase
extends PerformRoutineActionBase {
    protected PerformRoutineFromFileActionBase(@NotNull Supplier<@NlsActions.ActionText String> procedureText, @NotNull Supplier<@NlsActions.ActionText String> functionText) {
        if (procedureText == null) {
            PerformRoutineFromFileActionBase.$$$reportNull$$$0(0);
        }
        if (functionText == null) {
            PerformRoutineFromFileActionBase.$$$reportNull$$$0(1);
        }
        super(procedureText, functionText);
    }

    @Override
    @Nullable
    protected PerformRoutineActionBase.ActionData getActionData(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            PerformRoutineFromFileActionBase.$$$reportNull$$$0(2);
        }
        if ((project = e.getProject()) == null) {
            return null;
        }
        Editor editor2 = (Editor)e.getData(CommonDataKeys.EDITOR);
        Document document = editor2 == null ? null : editor2.getDocument();
        VirtualFile file = document == null ? null : FileDocumentManager.getInstance().getFile(document);
        DbRoutine routine2 = file == null ? null : (DbRoutine)DbSrcUtilsCore.findDbElement((Project)project, (String)file.getPath(), DbRoutine.class);
        BasicRoutine basic = routine2 == null ? null : (BasicRoutine)ObjectUtils.tryCast((Object)DbImplUtilCore.unwrap((DasObject)routine2), BasicRoutine.class);
        return basic == null ? null : new PerformFromFileActionData(routine2.getDataSource(), basic, file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "procedureText";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionText";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/editor/PerformRoutineFromFileActionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getActionData";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class PerformFromFileActionData
    extends PerformRoutineActionBase.ActionData {
        private final VirtualFile myVirtualFile;

        PerformFromFileActionData(@NotNull DbDataSource dataSource, @NotNull BasicRoutine routine2, @NotNull VirtualFile virtualFile) {
            if (dataSource == null) {
                PerformFromFileActionData.$$$reportNull$$$0(0);
            }
            if (routine2 == null) {
                PerformFromFileActionData.$$$reportNull$$$0(1);
            }
            if (virtualFile == null) {
                PerformFromFileActionData.$$$reportNull$$$0(2);
            }
            super(dataSource, routine2);
            this.myVirtualFile = virtualFile;
        }

        @Override
        public DataRequest.OwnerEx owner() {
            return JdbcConsoleProvider.getValidConsole(this.dataSource.getProject(), this.myVirtualFile);
        }

        @Override
        @NotNull
        public Consumer<? super DatabaseSession> runInSession(@NotNull Consumer<PerformRoutineActionBase.OwnerInfo> runWithOwner) {
            if (runWithOwner == null) {
                PerformFromFileActionData.$$$reportNull$$$0(3);
            }
            Consumer consumer = session -> {
                JdbcConsole console = JdbcConsoleProvider.reattachConsole(this.dataSource.getProject(), session, this.myVirtualFile);
                if (console == null) {
                    return;
                }
                runWithOwner.consume((Object)new PerformRoutineActionBase.OwnerInfo(console, false));
            };
            if (consumer == null) {
                PerformFromFileActionData.$$$reportNull$$$0(4);
            }
            return consumer;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "routine";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "virtualFile";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runWithOwner";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/editor/PerformRoutineFromFileActionBase$PerformFromFileActionData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/editor/PerformRoutineFromFileActionBase$PerformFromFileActionData";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "runInSession";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "runInSession";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }
}

