/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.migration;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.model.migration.DbMigrationDialog;
import com.intellij.database.model.migration.DbMigrationDialogKt;
import com.intellij.database.model.migration.DbMigrationDiffDivider;
import com.intellij.database.model.migration.DbMigrationDiffPanel;
import com.intellij.database.model.migration.DbMigrationTreeModel;
import com.intellij.database.model.migration.DiffStatus;
import com.intellij.database.model.migration.SdColorsKt;
import com.intellij.database.model.migration.SdForallCheckbox;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsUtil;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.Tree;
import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.CubicCurve2D;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u00046789B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u0014\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\tH\u0002J\u0012\u0010\u001e\u001a\u00020\f2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0014J\u0010\u0010!\u001a\u00020\t2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010$\u001a\u00020\t2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010%\u001a\u00020\t2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010&\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020'H\u0002J\u0010\u0010(\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020'H\u0002J\u0016\u0010)\u001a\b\u0018\u00010*R\u00020\u00002\u0006\u0010+\u001a\u00020\u0019H\u0002J\u0010\u0010,\u001a\u00020-2\u0006\u0010+\u001a\u00020\u0019H\u0002J\u0012\u0010.\u001a\u0004\u0018\u00010/2\u0006\u0010+\u001a\u00020\u0019H\u0002J\u001c\u00100\u001a\u0004\u0018\u00010\u00102\u0006\u0010+\u001a\u00020\u00192\b\b\u0002\u00101\u001a\u00020-H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u00102\u001a\u0002038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u00105\u00a8\u0006:"}, d2={"Lcom/intellij/database/model/migration/DbMigrationDiffDivider;", "Ljavax/swing/JPanel;", "diffPanel", "Lcom/intellij/database/model/migration/DbMigrationDiffPanel;", "migrationDialog", "Lcom/intellij/database/model/migration/DbMigrationDialog;", "<init>", "(Lcom/intellij/database/model/migration/DbMigrationDiffPanel;Lcom/intellij/database/model/migration/DbMigrationDialog;)V", "rectWidth", "", "preferredWidth", "repaintTrees", "", "forallCheckBox", "Lcom/intellij/database/model/migration/DbMigrationDiffDivider$ForallCheckBox;", "getForallCheckBoxCenter", "Ljava/awt/Point;", "forallPanel", "getForallPanel", "()Ljavax/swing/JPanel;", "getToolTipText", "", "e", "Ljava/awt/event/MouseEvent;", "getTreePath", "Ljavax/swing/tree/TreePath;", "getTreePathForY", "tree", "Ljavax/swing/JTree;", "y", "paintComponent", "g", "Ljava/awt/Graphics;", "scrollPaneBorderOffset", "side", "Lcom/intellij/database/model/migration/DbMigrationTreeModel$Side;", "scrollOffset", "scrollPaneOffset", "paintCorrespondence", "Ljava/awt/Graphics2D;", "paintWarnings", "getIncludeChangeCheckBox", "Lcom/intellij/database/model/migration/DbMigrationDiffDivider$IncludeChangeCheckBox;", "path", "containsWarning", "", "getWarningIcon", "Lcom/intellij/database/model/migration/DbMigrationDiffDivider$WarningIcon;", "calculateIconCenter", "addOffset", "targetTree", "Lcom/intellij/ui/treeStructure/Tree;", "getTargetTree", "()Lcom/intellij/ui/treeStructure/Tree;", "DividerIcon", "WarningIcon", "IncludeChangeCheckBox", "ForallCheckBox", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDbMigrationDiffDivider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbMigrationDiffDivider.kt\ncom/intellij/database/model/migration/DbMigrationDiffDivider\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,325:1\n24#2:326\n*S KotlinDebug\n*F\n+ 1 DbMigrationDiffDivider.kt\ncom/intellij/database/model/migration/DbMigrationDiffDivider\n*L\n231#1:326\n*E\n"})
public final class DbMigrationDiffDivider
extends JPanel {
    @NotNull
    private final DbMigrationDiffPanel diffPanel;
    @NotNull
    private final DbMigrationDialog migrationDialog;
    private final int rectWidth;
    private final int preferredWidth;
    @NotNull
    private final ForallCheckBox forallCheckBox;
    @NotNull
    private final JPanel forallPanel;

    public DbMigrationDiffDivider(@NotNull DbMigrationDiffPanel diffPanel, @NotNull DbMigrationDialog migrationDialog) {
        Intrinsics.checkNotNullParameter((Object)diffPanel, (String)"diffPanel");
        Intrinsics.checkNotNullParameter((Object)((Object)migrationDialog), (String)"migrationDialog");
        this.diffPanel = diffPanel;
        this.migrationDialog = migrationDialog;
        this.rectWidth = AllIcons.Diff.GutterCheckBox.getIconWidth() * 2;
        this.preferredWidth = AllIcons.Diff.GutterCheckBox.getIconWidth() * 10;
        this.forallCheckBox = new ForallCheckBox(this);
        this.forallPanel = new JPanel(this){
            final /* synthetic */ DbMigrationDiffDivider this$0;
            {
                this.this$0 = $receiver;
                MouseAdapter mouseAdapter2 = new MouseAdapter($receiver, this){
                    final /* synthetic */ DbMigrationDiffDivider this$0;
                    final /* synthetic */ forallPanel.1 this$1;
                    {
                        this.this$0 = $receiver;
                        this.this$1 = $receiver2;
                    }

                    public void mouseClicked(MouseEvent e) {
                        if (e == null) {
                            return;
                        }
                        ForallCheckBox checkBox = DbMigrationDiffDivider.access$getForallCheckBox$p(this.this$0);
                        Point point = e.getPoint();
                        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getPoint(...)");
                        if (checkBox.contains(point)) {
                            checkBox.click();
                            DbMigrationDiffDivider.access$getMigrationDialog$p(this.this$0).refreshScript();
                            this.this$1.repaint();
                        }
                    }
                };
                this.addMouseListener(mouseAdapter2);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public String getToolTipText(MouseEvent e) {
                if (e == null) return null;
                ForallCheckBox forallCheckBox = DbMigrationDiffDivider.access$getForallCheckBox$p(this.this$0);
                Point point = e.getPoint();
                Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getPoint(...)");
                if (!forallCheckBox.contains(point)) return null;
                String string = DbMigrationDiffDivider.access$getForallCheckBox$p(this.this$0).getTooltip();
                return string;
            }

            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                DbMigrationDiffDivider.access$getForallCheckBox$p(this.this$0).paint(this, g);
            }
        };
        MouseAdapter mouseAdapter2 = new MouseAdapter(this){
            final /* synthetic */ DbMigrationDiffDivider this$0;
            {
                this.this$0 = $receiver;
            }

            public void mouseClicked(MouseEvent e) {
                if (e == null) {
                    return;
                }
                TreePath treePath = DbMigrationDiffDivider.access$getTreePath(this.this$0, e);
                if (treePath == null) {
                    return;
                }
                TreePath path = treePath;
                IncludeChangeCheckBox includeChangeCheckBox = DbMigrationDiffDivider.access$getIncludeChangeCheckBox(this.this$0, path);
                if (includeChangeCheckBox == null) {
                    return;
                }
                IncludeChangeCheckBox checkBox = includeChangeCheckBox;
                Point point = e.getPoint();
                Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getPoint(...)");
                if (checkBox.contains(point)) {
                    checkBox.toggle();
                    DbMigrationDiffDivider.access$getMigrationDialog$p(this.this$0).refreshScript();
                    this.this$0.repaint();
                    DbMigrationDiffDivider.access$getForallCheckBox$p(this.this$0).update();
                    this.this$0.getForallPanel().repaint();
                }
            }
        };
        this.addMouseListener(mouseAdapter2);
        this.setBackground(EditorColorsUtil.getGlobalOrDefaultColorScheme().getColor(EditorColors.GUTTER_BACKGROUND));
        this.setMinimumSize(new Dimension(this.preferredWidth, 0));
    }

    private final void repaintTrees() {
        this.diffPanel.getOriginPresentableTree().repaint();
        this.diffPanel.getTargetPresentableTree().repaint();
    }

    private final Point getForallCheckBoxCenter() {
        return new Point(this.forallPanel.getWidth() - this.rectWidth / 2, this.forallPanel.getHeight() / 2);
    }

    @NotNull
    public final JPanel getForallPanel() {
        return this.forallPanel;
    }

    @Override
    @Nullable
    public String getToolTipText(@Nullable MouseEvent e) {
        WarningIcon warning;
        if (e == null) {
            return null;
        }
        TreePath treePath = this.getTreePath(e);
        if (treePath == null) {
            return null;
        }
        TreePath path = treePath;
        IncludeChangeCheckBox checkBox = this.getIncludeChangeCheckBox(path);
        if (checkBox != null) {
            Point point = e.getPoint();
            Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getPoint(...)");
            if (checkBox.contains(point)) {
                return checkBox.getTooltip();
            }
        }
        if ((warning = this.getWarningIcon(path)) != null) {
            Point point = e.getPoint();
            Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getPoint(...)");
            if (warning.contains(point)) {
                return warning.getTooltip();
            }
        }
        return null;
    }

    private final TreePath getTreePath(MouseEvent e) {
        return this.getTreePathForY((JTree)this.getTargetTree(), e.getY() - this.scrollPaneOffset(DbMigrationTreeModel.Side.TARGET));
    }

    private final TreePath getTreePathForY(JTree tree, int y) {
        TreePath path;
        TreePath treePath = path = tree.getClosestPathForLocation(0, y);
        if (treePath == null) {
            return null;
        }
        Rectangle bounds = tree.getPathBounds(treePath);
        if (bounds == null) {
            return null;
        }
        int n = bounds.y;
        return (y < bounds.y + bounds.height ? n <= y : false) ? path : null;
    }

    @Override
    protected void paintComponent(@Nullable Graphics g) {
        if (!(g instanceof Graphics2D)) {
            return;
        }
        ((Graphics2D)g).setBackground(this.getBackground());
        ((Graphics2D)g).clearRect(0, 0, this.getWidth(), this.getHeight());
        this.paintCorrespondence((Graphics2D)g);
        this.paintWarnings((Graphics2D)g);
    }

    private final int scrollPaneBorderOffset(DbMigrationTreeModel.Side side) {
        JBScrollPane scrollPane = this.diffPanel.getScrollPane(side);
        int treeY = scrollPane.getViewport().getLocationOnScreen().y;
        int dividerY = this.getLocationOnScreen().y;
        return treeY - dividerY;
    }

    private final int scrollOffset(DbMigrationTreeModel.Side side) {
        return -this.diffPanel.getScrollPane(side).getVerticalScrollBar().getValue();
    }

    private final int scrollPaneOffset(DbMigrationTreeModel.Side side) {
        return this.scrollOffset(side) + this.scrollPaneBorderOffset(side);
    }

    private final void paintCorrespondence(Graphics2D g) {
        int originHalfCircleRadius = 3;
        DbMigrationDiffDivider.paintCorrespondence$paintDirectionArrow(g, this);
        for (DbMigrationTreeModel.MappingItem mappingItem : this.migrationDialog.getDividerMapping()) {
            Point targetEndpoint;
            boolean originFitsInside;
            Point originEndpoint;
            if (!DbMigrationDiffDivider.paintCorrespondence$isNodeVisible(this, mappingItem, DbMigrationTreeModel.Side.TARGET)) continue;
            DiffStatus status = mappingItem.getStatus();
            boolean targetBoxFitsInside = DbMigrationDiffDivider.paintCorrespondence$paintCheckBox(this, g, mappingItem);
            if (!DbMigrationDiffDivider.paintCorrespondence$isNodeVisible(this, mappingItem, DbMigrationTreeModel.Side.ORIGIN) || status != DiffStatus.ADDED && status != DiffStatus.MODIFIED) continue;
            g.setColor(SdColorsKt.borderColor(status));
            if (DbMigrationDiffDivider.paintCorrespondence$endpoint(this, mappingItem, DbMigrationTreeModel.Side.ORIGIN) == null) continue;
            int n = this.getHeight();
            int n2 = originEndpoint.y;
            boolean bl = 0 <= n2 ? n2 < n : (originFitsInside = false);
            if (originFitsInside) {
                DbMigrationDiffDivider.paintCorrespondence$paintOriginHalfCircle(g, originHalfCircleRadius, originEndpoint);
            }
            if (DbMigrationDiffDivider.paintCorrespondence$endpoint(this, mappingItem, DbMigrationTreeModel.Side.TARGET) == null || !originFitsInside || !targetBoxFitsInside) continue;
            DbMigrationDiffDivider.paintCorrespondence$connect(g, this, originHalfCircleRadius, originEndpoint, targetEndpoint);
        }
    }

    private final void paintWarnings(Graphics2D g) {
        int n = this.getTargetTree().getRowCount();
        for (int row = 0; row < n; ++row) {
            WarningIcon warning;
            TreePath path = this.getTargetTree().getPathForRow(row);
            Intrinsics.checkNotNull((Object)path);
            if (this.getWarningIcon(path) == null) continue;
            warning.paint(this, g);
        }
    }

    private final IncludeChangeCheckBox getIncludeChangeCheckBox(TreePath path) {
        DbMigrationTreeModel.Node node = DbMigrationDialogKt.last(path);
        if (!node.getContainsMapping()) {
            return null;
        }
        Point point = DbMigrationDiffDivider.calculateIconCenter$default(this, path, false, 2, null);
        if (point == null) {
            return null;
        }
        Point center = point;
        return new IncludeChangeCheckBox(node, center);
    }

    private final boolean containsWarning(TreePath path) {
        return this.getTargetTree().isCollapsed(path) && DbMigrationDialogKt.last(path).getIncludedChildrenMappingCount() > 0;
    }

    private final WarningIcon getWarningIcon(TreePath path) {
        if (!this.containsWarning(path)) {
            return null;
        }
        Point point = this.calculateIconCenter(path, DbMigrationDialogKt.last(path).getContainsMapping());
        if (point == null) {
            return null;
        }
        Point center = point;
        return new WarningIcon(center);
    }

    private final Point calculateIconCenter(TreePath path, boolean addOffset) {
        Rectangle rectangle = DbMigrationDialogKt.nodeBounds(this.getTargetTree(), path);
        if (rectangle == null) {
            return null;
        }
        Rectangle nodeBounds = rectangle;
        int iconX = this.getWidth() - this.rectWidth / 2;
        int iconY = nodeBounds.y + this.scrollPaneOffset(DbMigrationTreeModel.Side.TARGET) + nodeBounds.height / 2;
        return new Point(addOffset ? iconX - this.rectWidth : iconX, iconY);
    }

    static /* synthetic */ Point calculateIconCenter$default(DbMigrationDiffDivider dbMigrationDiffDivider, TreePath treePath, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return dbMigrationDiffDivider.calculateIconCenter(treePath, bl);
    }

    private final Tree getTargetTree() {
        return this.diffPanel.getTargetPresentableTree();
    }

    private static final Point paintCorrespondence$endpoint(DbMigrationDiffDivider this$0, DbMigrationTreeModel.MappingItem mappingItem, DbMigrationTreeModel.Side side) {
        Tree tree = this$0.diffPanel.getPresentableTree(side);
        Rectangle rectangle = DbMigrationDialogKt.nodeBounds(tree, mappingItem.getPath());
        if (rectangle == null) {
            return null;
        }
        Rectangle bounds = rectangle;
        int x = switch (WhenMappings.$EnumSwitchMapping$0[side.ordinal()]) {
            case 1 -> 0;
            case 2 -> this$0.getWidth() - this$0.rectWidth;
            default -> throw new NoWhenBranchMatchedException();
        };
        int y = bounds.y + bounds.height / 2 + this$0.scrollPaneOffset(side);
        return new Point(x, y);
    }

    private static final void paintCorrespondence$paintOriginHalfCircle(Graphics2D $g, int originHalfCircleRadius, Point originEndpoint) {
        $g.fillOval(originEndpoint.x - originHalfCircleRadius, originEndpoint.y - originHalfCircleRadius, 2 * originHalfCircleRadius, 2 * originHalfCircleRadius);
    }

    private static final void paintCorrespondence$connect(Graphics2D $g, DbMigrationDiffDivider this$0, int originHalfCircleRadius, Point originEndpoint, Point targetEndpoint) {
        Stroke oldStroke = $g.getStroke();
        $g.setStroke(new BasicStroke(2.0f));
        double ctrlProximity = (double)this$0.getWidth() * 0.1;
        double originX = (double)originEndpoint.x + (double)originHalfCircleRadius;
        double originY = originEndpoint.y;
        double targetX = targetEndpoint.x;
        double targetY = targetEndpoint.y;
        CubicCurve2D.Double curve = new CubicCurve2D.Double(originX, originY, originX + ctrlProximity, originY, targetX - ctrlProximity, targetY, targetX, targetY);
        $g.draw(curve);
        $g.setStroke(oldStroke);
    }

    private static final boolean paintCorrespondence$paintCheckBox(DbMigrationDiffDivider this$0, Graphics2D $g, DbMigrationTreeModel.MappingItem mappingItem) {
        Rectangle rectangle = DbMigrationDialogKt.nodeBounds(this$0.getTargetTree(), mappingItem.getPath());
        if (rectangle == null) {
            return false;
        }
        Rectangle nodeBounds = rectangle;
        IncludeChangeCheckBox checkBox = this$0.getIncludeChangeCheckBox(mappingItem.getPath());
        if (checkBox == null) {
            DbMigrationDiffDivider $this$thisLogger$iv = this$0;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(DbMigrationDiffDivider.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Check box not found for " + DbMigrationDialogKt.last(mappingItem.getPath()));
            return false;
        }
        int boxY = nodeBounds.y + this$0.scrollPaneOffset(DbMigrationTreeModel.Side.TARGET);
        int $i$f$thisLogger = -nodeBounds.height;
        if (!(boxY < this$0.getHeight() ? $i$f$thisLogger <= boxY : false)) {
            return false;
        }
        $g.setColor(SdColorsKt.getBackground(mappingItem.getStatus()));
        int x = this$0.getWidth() - this$0.rectWidth;
        int arcRadius = 5;
        int width = this$0.rectWidth + arcRadius;
        int height = nodeBounds.height;
        int d = 2 * arcRadius;
        $g.fillRoundRect(x, boxY, width, height, d, d);
        $g.setColor(SdColorsKt.borderColor(mappingItem.getStatus()));
        $g.drawRoundRect(x, boxY, width, height, d, d);
        checkBox.paint(this$0, $g);
        return true;
    }

    private static final void paintCorrespondence$paintDirectionArrow(Graphics2D $g, DbMigrationDiffDivider this$0) {
        AffineTransform affineTransform;
        Polygon polygon;
        int arrowWidth = 4;
        int arrowHeight = 6;
        Polygon $this$paintCorrespondence_u24paintDirectionArrow_u24lambda_u240 = polygon = new Polygon();
        boolean bl = false;
        $this$paintCorrespondence_u24paintDirectionArrow_u24lambda_u240.addPoint(-2, 1);
        $this$paintCorrespondence_u24paintDirectionArrow_u24lambda_u240.addPoint(0, 1);
        $this$paintCorrespondence_u24paintDirectionArrow_u24lambda_u240.addPoint(0, 3);
        $this$paintCorrespondence_u24paintDirectionArrow_u24lambda_u240.addPoint(2, 0);
        $this$paintCorrespondence_u24paintDirectionArrow_u24lambda_u240.addPoint(0, -3);
        $this$paintCorrespondence_u24paintDirectionArrow_u24lambda_u240.addPoint(0, -1);
        $this$paintCorrespondence_u24paintDirectionArrow_u24lambda_u240.addPoint(-2, -1);
        Polygon arrowPolygon = polygon;
        AffineTransform $this$paintCorrespondence_u24paintDirectionArrow_u24lambda_u241 = affineTransform = new AffineTransform();
        boolean bl2 = false;
        $this$paintCorrespondence_u24paintDirectionArrow_u24lambda_u241.translate((double)this$0.getWidth() / 2.0, (double)this$0.getHeight() / 2.0);
        $this$paintCorrespondence_u24paintDirectionArrow_u24lambda_u241.scale((double)this$0.getWidth() / 2.0 / (double)arrowWidth, (double)this$0.getHeight() / 8.0 / (double)arrowHeight);
        AffineTransform transform = affineTransform;
        $g.setColor(this$0.getBackground().darker());
        $g.fill(transform.createTransformedShape(arrowPolygon));
    }

    private static final boolean paintCorrespondence$isNodeVisible(DbMigrationDiffDivider this$0, DbMigrationTreeModel.MappingItem mappingItem, DbMigrationTreeModel.Side side) {
        return this$0.diffPanel.getPresentableTree(side).isVisible(mappingItem.getPath());
    }

    public static final /* synthetic */ ForallCheckBox access$getForallCheckBox$p(DbMigrationDiffDivider $this) {
        return $this.forallCheckBox;
    }

    public static final /* synthetic */ TreePath access$getTreePath(DbMigrationDiffDivider $this, MouseEvent e) {
        return $this.getTreePath(e);
    }

    public static final /* synthetic */ IncludeChangeCheckBox access$getIncludeChangeCheckBox(DbMigrationDiffDivider $this, TreePath path) {
        return $this.getIncludeChangeCheckBox(path);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\"\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0005J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eR\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013\u00a8\u0006\u001f"}, d2={"Lcom/intellij/database/model/migration/DbMigrationDiffDivider$DividerIcon;", "", "<init>", "()V", "center", "Ljava/awt/Point;", "getCenter", "()Ljava/awt/Point;", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "tooltip", "", "getTooltip", "()Ljava/lang/String;", "x", "", "getX", "()I", "y", "getY", "contains", "", "point", "paint", "", "c", "Ljava/awt/Component;", "g", "Ljava/awt/Graphics;", "intellij.database.impl"})
    private static abstract class DividerIcon {
        @NotNull
        public abstract Point getCenter();

        @NotNull
        public abstract Icon getIcon();

        @NotNull
        public abstract String getTooltip();

        private final int getX() {
            return this.getCenter().x - this.getIcon().getIconWidth() / 2;
        }

        private final int getY() {
            return this.getCenter().y - this.getIcon().getIconHeight() / 2;
        }

        public final boolean contains(@NotNull Point point) {
            Intrinsics.checkNotNullParameter((Object)point, (String)"point");
            return new Rectangle(this.getX(), this.getY(), this.getIcon().getIconWidth(), this.getIcon().getIconHeight()).contains(point);
        }

        public final void paint(@NotNull Component c2, @Nullable Graphics g) {
            Intrinsics.checkNotNullParameter((Object)c2, (String)"c");
            this.getIcon().paintIcon(c2, g, this.getX(), this.getY());
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0019"}, d2={"Lcom/intellij/database/model/migration/DbMigrationDiffDivider$ForallCheckBox;", "Lcom/intellij/database/model/migration/DbMigrationDiffDivider$DividerIcon;", "diffDivider", "Lcom/intellij/database/model/migration/DbMigrationDiffDivider;", "<init>", "(Lcom/intellij/database/model/migration/DbMigrationDiffDivider;)V", "checkbox", "Lcom/intellij/database/model/migration/SdForallCheckbox;", "getCheckbox", "()Lcom/intellij/database/model/migration/SdForallCheckbox;", "center", "Ljava/awt/Point;", "getCenter", "()Ljava/awt/Point;", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "tooltip", "", "getTooltip", "()Ljava/lang/String;", "click", "", "update", "intellij.database.impl"})
    private static final class ForallCheckBox
    extends DividerIcon {
        @NotNull
        private final DbMigrationDiffDivider diffDivider;
        @NotNull
        private final SdForallCheckbox checkbox;

        public ForallCheckBox(@NotNull DbMigrationDiffDivider diffDivider) {
            Intrinsics.checkNotNullParameter((Object)diffDivider, (String)"diffDivider");
            this.diffDivider = diffDivider;
            this.checkbox = new SdForallCheckbox();
        }

        @NotNull
        public final SdForallCheckbox getCheckbox() {
            return this.checkbox;
        }

        @Override
        @NotNull
        public Point getCenter() {
            return this.diffDivider.getForallCheckBoxCenter();
        }

        @Override
        @NotNull
        public Icon getIcon() {
            return this.checkbox.getIcon();
        }

        @Override
        @NotNull
        public String getTooltip() {
            return this.checkbox.getTooltip();
        }

        public final void click() {
            this.checkbox.click(this.diffDivider.migrationDialog.getMigrationTree());
            this.diffDivider.repaintTrees();
            this.diffDivider.repaint();
        }

        public final void update() {
            this.checkbox.update(this.diffDivider.migrationDialog.getMigrationTree());
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001b\u0012\n\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u0016\u001a\u00020\u0017R\u0015\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0019\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0018"}, d2={"Lcom/intellij/database/model/migration/DbMigrationDiffDivider$IncludeChangeCheckBox;", "Lcom/intellij/database/model/migration/DbMigrationDiffDivider$DividerIcon;", "node", "Lcom/intellij/database/model/migration/DbMigrationTreeModel$Node;", "Lcom/intellij/database/model/migration/DbMigrationTreeModel;", "center", "Ljava/awt/Point;", "<init>", "(Lcom/intellij/database/model/migration/DbMigrationDiffDivider;Lcom/intellij/database/model/migration/DbMigrationTreeModel$Node;Ljava/awt/Point;)V", "getNode", "()Lcom/intellij/database/model/migration/DbMigrationTreeModel$Node;", "getCenter", "()Ljava/awt/Point;", "icon", "Ljavax/swing/Icon;", "Lorg/jetbrains/annotations/NotNull;", "getIcon", "()Ljavax/swing/Icon;", "tooltip", "", "getTooltip", "()Ljava/lang/String;", "toggle", "", "intellij.database.impl"})
    private final class IncludeChangeCheckBox
    extends DividerIcon {
        @NotNull
        private final DbMigrationTreeModel.Node node;
        @NotNull
        private final Point center;

        public IncludeChangeCheckBox(@NotNull DbMigrationTreeModel.Node node, Point center) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)center, (String)"center");
            this.node = node;
            this.center = center;
        }

        @NotNull
        public final DbMigrationTreeModel.Node getNode() {
            return this.node;
        }

        @Override
        @NotNull
        public Point getCenter() {
            return this.center;
        }

        @Override
        @NotNull
        public Icon getIcon() {
            Icon icon = this.node.getIncluded() ? AllIcons.Diff.GutterCheckBoxSelected : AllIcons.Diff.GutterCheckBox;
            Intrinsics.checkNotNull((Object)icon);
            return icon;
        }

        @Override
        @NotNull
        public String getTooltip() {
            String string;
            if (this.node.getIncluded()) {
                String string2 = DatabaseBundle.message((String)"migration.window.exclude.action", (Object[])new Object[0]);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            } else {
                String string3 = DatabaseBundle.message((String)"migration.window.include.action", (Object[])new Object[0]);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
            }
            return string;
        }

        public final void toggle() {
            this.node.setIncluded(!this.node.getIncluded());
            DbMigrationDiffDivider.this.repaintTrees();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0019\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001e\u0010\r\u001a\f0\u000e\u00a2\u0006\u0002\b\n\u00a2\u0006\u0002\b\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/intellij/database/model/migration/DbMigrationDiffDivider$WarningIcon;", "Lcom/intellij/database/model/migration/DbMigrationDiffDivider$DividerIcon;", "center", "Ljava/awt/Point;", "<init>", "(Ljava/awt/Point;)V", "getCenter", "()Ljava/awt/Point;", "icon", "Ljavax/swing/Icon;", "Lorg/jetbrains/annotations/NotNull;", "getIcon", "()Ljavax/swing/Icon;", "tooltip", "", "Lorg/jetbrains/annotations/Nls;", "getTooltip", "()Ljava/lang/String;", "intellij.database.impl"})
    private static final class WarningIcon
    extends DividerIcon {
        @NotNull
        private final Point center;

        public WarningIcon(@NotNull Point center) {
            Intrinsics.checkNotNullParameter((Object)center, (String)"center");
            this.center = center;
        }

        @Override
        @NotNull
        public Point getCenter() {
            return this.center;
        }

        @Override
        @NotNull
        public Icon getIcon() {
            Icon icon = AllIcons.General.Warning;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Warning");
            return icon;
        }

        @Override
        @NotNull
        public String getTooltip() {
            String string = DatabaseBundle.message((String)"migration.window.divider.warning", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DbMigrationTreeModel.Side.values().length];
            try {
                nArray[DbMigrationTreeModel.Side.ORIGIN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DbMigrationTreeModel.Side.TARGET.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

