/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.gateway.ssh;

import com.intellij.remote.RemoteCredentials;
import com.intellij.ssh.config.unified.SshConfig;
import com.jetbrains.gateway.plugins.GatewayConnectionHelperKt;
import com.jetbrains.gateway.ssh.HighLevelHostAccessor;
import com.jetbrains.gateway.ssh.deploy.DeployTargetInfo;
import com.jetbrains.gateway.ssh.deploy.LoggingHostCommandExecutorWrapper;
import com.jetbrains.gateway.ssh.deploy.impl.SshCommandExecutor;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\u0004\u0005\u0006B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0001\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/gateway/ssh/HostDeployInputs;", "", "<init>", "()V", "WithHostInfo", "WithDeployedWorker", "FullySpecified", "Lcom/jetbrains/gateway/ssh/HostDeployInputs$WithHostInfo;", "intellij.gateway.core"})
public abstract class HostDeployInputs {
    private HostDeployInputs() {
    }

    public /* synthetic */ HostDeployInputs(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000f\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\u0004\u0018\u00010\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/gateway/ssh/HostDeployInputs$FullySpecified;", "Lcom/jetbrains/gateway/ssh/HostDeployInputs$WithDeployedWorker;", "remoteProjectPath", "", "deployTarget", "Lcom/jetbrains/gateway/ssh/deploy/DeployTargetInfo;", "remoteInfo", "<init>", "(Ljava/lang/String;Lcom/jetbrains/gateway/ssh/deploy/DeployTargetInfo;Lcom/jetbrains/gateway/ssh/HostDeployInputs$WithDeployedWorker;)V", "getRemoteProjectPath", "()Ljava/lang/String;", "getDeployTarget", "()Lcom/jetbrains/gateway/ssh/deploy/DeployTargetInfo;", "remoteTypeByTrace", "getRemoteTypeByTrace$intellij_gateway_core", "toString", "intellij.gateway.core"})
    public static final class FullySpecified
    extends WithDeployedWorker {
        @NotNull
        private final String remoteProjectPath;
        @NotNull
        private final DeployTargetInfo deployTarget;
        @Nullable
        private final String remoteTypeByTrace;

        public FullySpecified(@NotNull String remoteProjectPath, @NotNull DeployTargetInfo deployTarget, @NotNull WithDeployedWorker remoteInfo) {
            Intrinsics.checkNotNullParameter((Object)remoteProjectPath, (String)"remoteProjectPath");
            Intrinsics.checkNotNullParameter((Object)deployTarget, (String)"deployTarget");
            Intrinsics.checkNotNullParameter((Object)remoteInfo, (String)"remoteInfo");
            super(remoteInfo.getHostAccessor(), remoteInfo);
            this.remoteProjectPath = remoteProjectPath;
            this.deployTarget = deployTarget;
            this.remoteTypeByTrace = GatewayConnectionHelperKt.getRemoteTypeByStackTrace(1);
        }

        @NotNull
        public final String getRemoteProjectPath() {
            return this.remoteProjectPath;
        }

        @NotNull
        public final DeployTargetInfo getDeployTarget() {
            return this.deployTarget;
        }

        @Nullable
        public final String getRemoteTypeByTrace$intellij_gateway_core() {
            return this.remoteTypeByTrace;
        }

        @Override
        @NotNull
        public String toString() {
            return "FullySpecified(remoteProjectPath='" + this.remoteProjectPath + "', deployTarget=" + this.deployTarget + ", base=" + super.toString() + ")";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\b\u0010\u000f\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/gateway/ssh/HostDeployInputs$WithDeployedWorker;", "Lcom/jetbrains/gateway/ssh/HostDeployInputs$WithHostInfo;", "hostAccessor", "Lcom/jetbrains/gateway/ssh/HighLevelHostAccessor;", "hostInfo", "<init>", "(Lcom/jetbrains/gateway/ssh/HighLevelHostAccessor;Lcom/jetbrains/gateway/ssh/HostDeployInputs$WithHostInfo;)V", "getHostAccessor", "()Lcom/jetbrains/gateway/ssh/HighLevelHostAccessor;", "upgrade", "Lcom/jetbrains/gateway/ssh/HostDeployInputs$FullySpecified;", "remoteProjectPath", "", "deployTarget", "Lcom/jetbrains/gateway/ssh/deploy/DeployTargetInfo;", "toString", "intellij.gateway.core"})
    public static class WithDeployedWorker
    extends WithHostInfo {
        @NotNull
        private final HighLevelHostAccessor hostAccessor;

        public WithDeployedWorker(@NotNull HighLevelHostAccessor hostAccessor, @NotNull WithHostInfo hostInfo) {
            Intrinsics.checkNotNullParameter((Object)hostAccessor, (String)"hostAccessor");
            Intrinsics.checkNotNullParameter((Object)hostInfo, (String)"hostInfo");
            super(hostInfo.getLoggingCommandExecutor());
            this.hostAccessor = hostAccessor;
        }

        @NotNull
        public final HighLevelHostAccessor getHostAccessor() {
            return this.hostAccessor;
        }

        @NotNull
        public final FullySpecified upgrade(@NotNull String remoteProjectPath, @NotNull DeployTargetInfo deployTarget) {
            Intrinsics.checkNotNullParameter((Object)remoteProjectPath, (String)"remoteProjectPath");
            Intrinsics.checkNotNullParameter((Object)deployTarget, (String)"deployTarget");
            return new FullySpecified(remoteProjectPath, deployTarget, this);
        }

        @Override
        @NotNull
        public String toString() {
            return "WithDeployedWorker(hostAccessor=" + this.hostAccessor + ", base=" + super.toString() + ")";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\bB\u0011\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u0004\u0010\u000bJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/gateway/ssh/HostDeployInputs$WithHostInfo;", "Lcom/jetbrains/gateway/ssh/HostDeployInputs;", "loggingCommandExecutor", "Lcom/jetbrains/gateway/ssh/deploy/LoggingHostCommandExecutorWrapper;", "<init>", "(Lcom/jetbrains/gateway/ssh/deploy/LoggingHostCommandExecutorWrapper;)V", "sshConfig", "Lcom/intellij/ssh/config/unified/SshConfig;", "(Lcom/intellij/ssh/config/unified/SshConfig;)V", "remoteCredentials", "Lcom/intellij/remote/RemoteCredentials;", "(Lcom/intellij/remote/RemoteCredentials;)V", "getLoggingCommandExecutor", "()Lcom/jetbrains/gateway/ssh/deploy/LoggingHostCommandExecutorWrapper;", "upgrade", "Lcom/jetbrains/gateway/ssh/HostDeployInputs$WithDeployedWorker;", "executor", "Lcom/jetbrains/gateway/ssh/HighLevelHostAccessor;", "toString", "", "intellij.gateway.core"})
    public static class WithHostInfo
    extends HostDeployInputs {
        @NotNull
        private final LoggingHostCommandExecutorWrapper loggingCommandExecutor;

        public WithHostInfo(@NotNull LoggingHostCommandExecutorWrapper loggingCommandExecutor) {
            Intrinsics.checkNotNullParameter((Object)loggingCommandExecutor, (String)"loggingCommandExecutor");
            super(null);
            this.loggingCommandExecutor = loggingCommandExecutor;
        }

        @NotNull
        public final LoggingHostCommandExecutorWrapper getLoggingCommandExecutor() {
            return this.loggingCommandExecutor;
        }

        public WithHostInfo(@NotNull SshConfig sshConfig) {
            Intrinsics.checkNotNullParameter((Object)sshConfig, (String)"sshConfig");
            RemoteCredentials remoteCredentials = sshConfig.copyToCredentials();
            Intrinsics.checkNotNullExpressionValue((Object)remoteCredentials, (String)"copyToCredentials(...)");
            this(remoteCredentials);
        }

        public WithHostInfo(@NotNull RemoteCredentials remoteCredentials) {
            Intrinsics.checkNotNullParameter((Object)remoteCredentials, (String)"remoteCredentials");
            this(new LoggingHostCommandExecutorWrapper(new SshCommandExecutor(remoteCredentials, false, 2, null)));
        }

        @NotNull
        public final WithDeployedWorker upgrade(@NotNull HighLevelHostAccessor executor2) {
            Intrinsics.checkNotNullParameter((Object)executor2, (String)"executor");
            return new WithDeployedWorker(executor2, this);
        }

        @NotNull
        public String toString() {
            return "WithHostInfo(loggingCommandExecutor=" + this.loggingCommandExecutor + ")";
        }
    }
}

