/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.agent.compose.beans.DockerComposeConfiguration;
import com.intellij.docker.agent.compose.beans.v1.DockerComposeConfigurationV1;
import com.intellij.docker.agent.compose.beans.v2.DockerComposeConfigurationV2;
import com.intellij.docker.agent.util.DockerComposeUtilsKt;
import com.intellij.docker.compose.configuration.beans.parse.DockerComposeFileConfigurationProvider;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class DockerComposeConfigurationInfo {
    @NotNull
    private final List<Path> myConfigurationFiles;
    @NotNull
    private final Set<String> myServices;

    public DockerComposeConfigurationInfo(@NotNull List<Path> files, @NotNull Set<String> services) {
        if (files == null) {
            DockerComposeConfigurationInfo.$$$reportNull$$$0(0);
        }
        if (services == null) {
            DockerComposeConfigurationInfo.$$$reportNull$$$0(1);
        }
        this.myConfigurationFiles = List.copyOf(files);
        this.myServices = Collections.unmodifiableSet(new LinkedHashSet<String>(services));
    }

    @NotNull
    public List<Path> getConfigurationFiles() {
        List<Path> list = this.myConfigurationFiles;
        if (list == null) {
            DockerComposeConfigurationInfo.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public Set<String> getServices() {
        Set<String> set = this.myServices;
        if (set == null) {
            DockerComposeConfigurationInfo.$$$reportNull$$$0(3);
        }
        return set;
    }

    @NotNull
    public static DockerComposeConfigurationInfo getDockerComposeConfigurationInfo(@NotNull List<String> paths, @NotNull DockerCloudConfiguration cloudConfig) throws IOException {
        LinkedHashSet<String> services;
        List<Path> files;
        if (paths == null) {
            DockerComposeConfigurationInfo.$$$reportNull$$$0(4);
        }
        if (cloudConfig == null) {
            DockerComposeConfigurationInfo.$$$reportNull$$$0(5);
        }
        if (paths.isEmpty()) {
            return new DockerComposeConfigurationInfo(Collections.emptyList(), Collections.emptySet());
        }
        if (paths.size() == 1) {
            files = DockerComposeUtilsKt.findDockerComposeConfigurationFiles(paths.get(0));
            paths = ContainerUtil.map(files, Path::toString);
        } else {
            files = ContainerUtil.map(paths, path -> Paths.get(path, new String[0]));
        }
        try {
            DockerComposeConfiguration configuration = DockerComposeFileConfigurationProvider.getInstance().getConfigFor(cloudConfig, paths);
            services = new LinkedHashSet<String>((Collection)configuration.accept(new DockerComposeConfiguration.Visitor<Set<String>>(){

                @Override
                public Set<String> visit(@NotNull DockerComposeConfigurationV1 configuration) {
                    if (configuration == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return configuration.getServices().keySet();
                }

                @Override
                public Set<String> visit(@NotNull DockerComposeConfigurationV2 configuration) {
                    if (configuration == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return configuration.getServices().keySet();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/docker/remote/DockerComposeConfigurationInfo$1", "visit"));
                }
            }));
        }
        catch (IOException e) {
            throw new IOException(String.format("Error while parsing %s: %s", paths.stream().map(x -> "\"" + x + "\"").collect(Collectors.joining(", ")), e.getMessage()), e);
        }
        return new DockerComposeConfigurationInfo(files, services);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "services";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/remote/DockerComposeConfigurationInfo";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cloudConfig";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/remote/DockerComposeConfigurationInfo";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationFiles";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getServices";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDockerComposeConfigurationInfo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

