/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl;

import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public final class CssEscapeUtil {
    private CssEscapeUtil() {
    }

    static String unescapeCssString(@NotNull String s) {
        if (s == null) {
            CssEscapeUtil.$$$reportNull$$$0(0);
        }
        if (s.indexOf(92) < 0) {
            return s;
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\' && i < s.length() - 1) {
                char next = s.charAt(i + 1);
                if (StringUtil.isHexDigit((char)next)) {
                    int start = i + 1;
                    int limit = Math.min(start + 6, s.length());
                    for (int j = start; j < limit; ++j) {
                        char ch = s.charAt(j);
                        if (StringUtil.isHexDigit((char)ch) && !Character.isWhitespace(ch)) continue;
                        limit = j;
                        break;
                    }
                    c = (char)Integer.parseInt(s.substring(start, limit), 16);
                    i = s.length() > limit && s.charAt(limit) == ' ' ? limit : limit - 1;
                } else if (!StringUtil.isLineBreak((char)next)) {
                    c = next;
                    ++i;
                }
            }
            result.append(c);
        }
        return result.toString();
    }

    @NotNull
    public static String escapeSpecialCssChars(@NotNull String s) {
        if (s == null) {
            CssEscapeUtil.$$$reportNull$$$0(1);
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch >= '\u007f') {
                result.append(ch);
                continue;
            }
            if (ch < '\u0010') {
                result.append("\\00000").append(Integer.toString(ch, 16));
                continue;
            }
            if (ch < ' ') {
                result.append("\\0000").append(Integer.toString(ch, 16));
                continue;
            }
            if (ch == '-' || ch == '_' || ch >= '0' && ch <= '9' || ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z') {
                result.append(ch);
                continue;
            }
            result.append('\\').append(ch);
        }
        String string = result.toString();
        if (string == null) {
            CssEscapeUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/impl/CssEscapeUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/impl/CssEscapeUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeSpecialCssChars";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "unescapeCssString";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "escapeSpecialCssChars";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

