/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PythonTemplateRunner;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import org.jetbrains.annotations.NotNull;

public class CreateClassQuickFix
implements LocalQuickFix {
    @NotNull
    private final String myClassName;
    @NotNull
    private final SmartPsiElementPointer<PsiFile> myTargetFile;

    public CreateClassQuickFix(@NotNull String className, @NotNull PsiFile targetFile) {
        if (className == null) {
            CreateClassQuickFix.$$$reportNull$$$0(0);
        }
        if (targetFile == null) {
            CreateClassQuickFix.$$$reportNull$$$0(1);
        }
        this.myClassName = className;
        this.myTargetFile = SmartPointerManager.getInstance((Project)targetFile.getProject()).createSmartPsiElementPointer((PsiElement)targetFile);
    }

    @NotNull
    public String getName() {
        PsiFile targetFile = (PsiFile)this.myTargetFile.getElement();
        if (targetFile != null) {
            String string = PyPsiBundle.message("QFIX.create.class.in.module", this.myClassName, targetFile.getName());
            if (string == null) {
                CreateClassQuickFix.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = PyPsiBundle.message("QFIX.create.class.0", this.myClassName);
        if (string == null) {
            CreateClassQuickFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = PyPsiBundle.message("QFIX.create.class", new Object[0]);
        if (string == null) {
            CreateClassQuickFix.$$$reportNull$$$0(4);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        PsiElement unresolvedReference;
        if (project == null) {
            CreateClassQuickFix.$$$reportNull$$$0(5);
        }
        if (descriptor2 == null) {
            CreateClassQuickFix.$$$reportNull$$$0(6);
        }
        if ((unresolvedReference = descriptor2.getPsiElement()) == null) {
            return;
        }
        PsiFile targetFile = (PsiFile)this.myTargetFile.getElement();
        if (targetFile == null) {
            return;
        }
        boolean isPy3K = LanguageLevel.forElement((PsiElement)targetFile).isPy3K();
        String superClass = isPy3K ? "" : "(object)";
        PyClass pyClass = (PyClass)PyElementGenerator.getInstance(project).createFromText(LanguageLevel.getDefault(), PyClass.class, "class " + this.myClassName + superClass + ":\n    pass");
        InjectedLanguageManager injectionManager = InjectedLanguageManager.getInstance((Project)unresolvedReference.getProject());
        PsiLanguageInjectionHost injectionHost = injectionManager.getInjectionHost(unresolvedReference);
        if (unresolvedReference.getContainingFile() == targetFile) {
            insertionAnchor = PyPsiUtils.getParentRightBefore(unresolvedReference, (PsiElement)targetFile);
            assert (insertionAnchor != null);
            pyClass = (PyClass)insertionAnchor.getParent().addBefore((PsiElement)pyClass, insertionAnchor);
        } else if (injectionHost != null && injectionHost.getContainingFile() == targetFile) {
            insertionAnchor = PyPsiUtils.getParentRightBefore((PsiElement)injectionHost, (PsiElement)targetFile);
            assert (insertionAnchor != null);
            pyClass = (PyClass)insertionAnchor.getParent().addBefore((PsiElement)pyClass, insertionAnchor);
        } else {
            pyClass = (PyClass)targetFile.add((PsiElement)pyClass);
        }
        pyClass = (PyClass)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)pyClass);
        TemplateBuilder builder = TemplateBuilderFactory.getInstance().createTemplateBuilder((PsiElement)pyClass);
        if (!isPy3K) {
            builder.replaceElement((PsiElement)pyClass.getSuperClassExpressions()[0], "object");
        }
        builder.replaceElement((PsiElement)pyClass.getStatementList(), "pass");
        PythonTemplateRunner.runTemplate(pyClass.getContainingFile(), builder);
    }

    @NotNull
    public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
        if (target == null) {
            CreateClassQuickFix.$$$reportNull$$$0(7);
        }
        return new CreateClassQuickFix(this.myClassName, target);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFile";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/quickfix/CreateClassQuickFix";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/quickfix/CreateClassQuickFix";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFileModifierForPreview";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

