/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.validation;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyGlobalStatement;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.impl.ParamHelper;
import com.jetbrains.python.validation.PyAnnotator;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class GlobalAnnotator
extends PyAnnotator {
    @Override
    public void visitPyGlobalStatement(@NotNull PyGlobalStatement node) {
        PyFunction function;
        if (node == null) {
            GlobalAnnotator.$$$reportNull$$$0(0);
        }
        if ((function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)node, PyFunction.class)) != null) {
            PyParameterList paramList = function.getParameterList();
            final HashSet paramNames = new HashSet();
            ParamHelper.walkDownParamArray(paramList.getParameters(), new ParamHelper.ParamVisitor(){

                @Override
                public void visitNamedParameter(PyNamedParameter param, boolean first, boolean last) {
                    paramNames.add(param.getName());
                }
            });
            AnnotationHolder holder = this.getHolder();
            for (PyTargetExpression expr : node.getGlobals()) {
                String expr_name = expr.getReferencedName();
                if (!paramNames.contains(expr_name)) continue;
                holder.newAnnotation(HighlightSeverity.ERROR, PyPsiBundle.message("ANN.name.used.both.as.global.and.param", expr_name)).range((PsiElement)expr).create();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/python/validation/GlobalAnnotator", "visitPyGlobalStatement"));
    }
}

