package cloudapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeApiMarketAttributes invokes the cloudapi.DescribeApiMarketAttributes API synchronously
// api document: https://help.aliyun.com/api/cloudapi/describeapimarketattributes.html
func (client *Client) DescribeApiMarketAttributes(request *DescribeApiMarketAttributesRequest) (response *DescribeApiMarketAttributesResponse, err error) {
	response = CreateDescribeApiMarketAttributesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeApiMarketAttributesWithChan invokes the cloudapi.DescribeApiMarketAttributes API asynchronously
// api document: https://help.aliyun.com/api/cloudapi/describeapimarketattributes.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeApiMarketAttributesWithChan(request *DescribeApiMarketAttributesRequest) (<-chan *DescribeApiMarketAttributesResponse, <-chan error) {
	responseChan := make(chan *DescribeApiMarketAttributesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeApiMarketAttributes(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeApiMarketAttributesWithCallback invokes the cloudapi.DescribeApiMarketAttributes API asynchronously
// api document: https://help.aliyun.com/api/cloudapi/describeapimarketattributes.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeApiMarketAttributesWithCallback(request *DescribeApiMarketAttributesRequest, callback func(response *DescribeApiMarketAttributesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeApiMarketAttributesResponse
		var err error
		defer close(result)
		response, err = client.DescribeApiMarketAttributes(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeApiMarketAttributesRequest is the request struct for api DescribeApiMarketAttributes
type DescribeApiMarketAttributesRequest struct {
	*requests.RpcRequest
	GroupId       string `position:"Query" name:"GroupId"`
	SecurityToken string `position:"Query" name:"SecurityToken"`
	ApiId         string `position:"Query" name:"ApiId"`
}

// DescribeApiMarketAttributesResponse is the response struct for api DescribeApiMarketAttributes
type DescribeApiMarketAttributesResponse struct {
	*responses.BaseResponse
	RequestId          string `json:"RequestId" xml:"RequestId"`
	ApiId              string `json:"ApiId" xml:"ApiId"`
	NeedCharging       string `json:"NeedCharging" xml:"NeedCharging"`
	MarketChargingMode string `json:"MarketChargingMode" xml:"MarketChargingMode"`
}

// CreateDescribeApiMarketAttributesRequest creates a request to invoke DescribeApiMarketAttributes API
func CreateDescribeApiMarketAttributesRequest() (request *DescribeApiMarketAttributesRequest) {
	request = &DescribeApiMarketAttributesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudAPI", "2016-07-14", "DescribeApiMarketAttributes", "apigateway", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeApiMarketAttributesResponse creates a response to parse from DescribeApiMarketAttributes response
func CreateDescribeApiMarketAttributesResponse() (response *DescribeApiMarketAttributesResponse) {
	response = &DescribeApiMarketAttributesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
