package ddosbgp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeOpEntities invokes the ddosbgp.DescribeOpEntities API synchronously
// api document: https://help.aliyun.com/api/ddosbgp/describeopentities.html
func (client *Client) DescribeOpEntities(request *DescribeOpEntitiesRequest) (response *DescribeOpEntitiesResponse, err error) {
	response = CreateDescribeOpEntitiesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeOpEntitiesWithChan invokes the ddosbgp.DescribeOpEntities API asynchronously
// api document: https://help.aliyun.com/api/ddosbgp/describeopentities.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeOpEntitiesWithChan(request *DescribeOpEntitiesRequest) (<-chan *DescribeOpEntitiesResponse, <-chan error) {
	responseChan := make(chan *DescribeOpEntitiesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeOpEntities(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeOpEntitiesWithCallback invokes the ddosbgp.DescribeOpEntities API asynchronously
// api document: https://help.aliyun.com/api/ddosbgp/describeopentities.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeOpEntitiesWithCallback(request *DescribeOpEntitiesRequest, callback func(response *DescribeOpEntitiesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeOpEntitiesResponse
		var err error
		defer close(result)
		response, err = client.DescribeOpEntities(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeOpEntitiesRequest is the request struct for api DescribeOpEntities
type DescribeOpEntitiesRequest struct {
	*requests.RpcRequest
	StartTime        requests.Integer `position:"Query" name:"StartTime"`
	ResourceGroupId  string           `position:"Query" name:"ResourceGroupId"`
	SourceIp         string           `position:"Query" name:"SourceIp"`
	PageSize         requests.Integer `position:"Query" name:"PageSize"`
	Lang             string           `position:"Query" name:"Lang"`
	ResourceRegionId string           `position:"Query" name:"ResourceRegionId"`
	EndTime          requests.Integer `position:"Query" name:"EndTime"`
	OrderBy          string           `position:"Query" name:"OrderBy"`
	CurrentPage      requests.Integer `position:"Query" name:"CurrentPage"`
	OrderDir         string           `position:"Query" name:"OrderDir"`
	InstanceId       string           `position:"Query" name:"InstanceId"`
}

// DescribeOpEntitiesResponse is the response struct for api DescribeOpEntities
type DescribeOpEntitiesResponse struct {
	*responses.BaseResponse
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	TotalCount int        `json:"TotalCount" xml:"TotalCount"`
	OpEntities []OpEntity `json:"OpEntities" xml:"OpEntities"`
}

// CreateDescribeOpEntitiesRequest creates a request to invoke DescribeOpEntities API
func CreateDescribeOpEntitiesRequest() (request *DescribeOpEntitiesRequest) {
	request = &DescribeOpEntitiesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddosbgp", "2018-07-20", "DescribeOpEntities", "ddosbgp", "openAPI")
	return
}

// CreateDescribeOpEntitiesResponse creates a response to parse from DescribeOpEntities response
func CreateDescribeOpEntitiesResponse() (response *DescribeOpEntitiesResponse) {
	response = &DescribeOpEntitiesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
