package facebody

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SearchBodyTrace invokes the facebody.SearchBodyTrace API synchronously
func (client *Client) SearchBodyTrace(request *SearchBodyTraceRequest) (response *SearchBodyTraceResponse, err error) {
	response = CreateSearchBodyTraceResponse()
	err = client.DoAction(request, response)
	return
}

// SearchBodyTraceWithChan invokes the facebody.SearchBodyTrace API asynchronously
func (client *Client) SearchBodyTraceWithChan(request *SearchBodyTraceRequest) (<-chan *SearchBodyTraceResponse, <-chan error) {
	responseChan := make(chan *SearchBodyTraceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SearchBodyTrace(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SearchBodyTraceWithCallback invokes the facebody.SearchBodyTrace API asynchronously
func (client *Client) SearchBodyTraceWithCallback(request *SearchBodyTraceRequest, callback func(response *SearchBodyTraceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SearchBodyTraceResponse
		var err error
		defer close(result)
		response, err = client.SearchBodyTrace(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SearchBodyTraceRequest is the request struct for api SearchBodyTrace
type SearchBodyTraceRequest struct {
	*requests.RpcRequest
	MinScore requests.Float   `position:"Body" name:"MinScore"`
	Limit    requests.Integer `position:"Body" name:"Limit"`
	Images   string           `position:"Body" name:"Images"`
	DbId     requests.Integer `position:"Body" name:"DbId"`
}

// SearchBodyTraceResponse is the response struct for api SearchBodyTrace
type SearchBodyTraceResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateSearchBodyTraceRequest creates a request to invoke SearchBodyTrace API
func CreateSearchBodyTraceRequest() (request *SearchBodyTraceRequest) {
	request = &SearchBodyTraceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("facebody", "2019-12-30", "SearchBodyTrace", "facebody", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSearchBodyTraceResponse creates a response to parse from SearchBodyTrace response
func CreateSearchBodyTraceResponse() (response *SearchBodyTraceResponse) {
	response = &SearchBodyTraceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
