package idrsservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateDepartment invokes the idrsservice.CreateDepartment API synchronously
func (client *Client) CreateDepartment(request *CreateDepartmentRequest) (response *CreateDepartmentResponse, err error) {
	response = CreateCreateDepartmentResponse()
	err = client.DoAction(request, response)
	return
}

// CreateDepartmentWithChan invokes the idrsservice.CreateDepartment API asynchronously
func (client *Client) CreateDepartmentWithChan(request *CreateDepartmentRequest) (<-chan *CreateDepartmentResponse, <-chan error) {
	responseChan := make(chan *CreateDepartmentResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateDepartment(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateDepartmentWithCallback invokes the idrsservice.CreateDepartment API asynchronously
func (client *Client) CreateDepartmentWithCallback(request *CreateDepartmentRequest, callback func(response *CreateDepartmentResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateDepartmentResponse
		var err error
		defer close(result)
		response, err = client.CreateDepartment(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateDepartmentRequest is the request struct for api CreateDepartment
type CreateDepartmentRequest struct {
	*requests.RpcRequest
	ClientToken string `position:"Query" name:"ClientToken"`
	Description string `position:"Query" name:"Description"`
	Label       string `position:"Query" name:"Label"`
	Name        string `position:"Query" name:"Name"`
}

// CreateDepartmentResponse is the response struct for api CreateDepartment
type CreateDepartmentResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateCreateDepartmentRequest creates a request to invoke CreateDepartment API
func CreateCreateDepartmentRequest() (request *CreateDepartmentRequest) {
	request = &CreateDepartmentRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("idrsservice", "2020-06-30", "CreateDepartment", "idrsservice", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateDepartmentResponse creates a response to parse from CreateDepartment response
func CreateCreateDepartmentResponse() (response *CreateDepartmentResponse) {
	response = &CreateDepartmentResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
