/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote.run.runtime;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerCloudType;
import com.intellij.docker.agent.DockerAgentImage;
import com.intellij.docker.agent.settings.DockerPathMappingImpl;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.remote.DockerComposeCredentialsCase;
import com.intellij.docker.remote.DockerComposeCredentialsHolder;
import com.intellij.docker.remote.DockerCredentialsCase;
import com.intellij.docker.remote.DockerCredentialsHolder;
import com.intellij.docker.remote.run.runtime.UnixPathUtil;
import com.intellij.docker.remoteRunRuntime.RemoteDockerRuntime;
import com.intellij.docker.utils.DockerEngineUtil;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remote.ext.CredentialsCase;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import com.intellij.remoteServer.util.ServerRuntimeException;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DockerUtil {
    public static final String JETBRAINS_HELPERS_LABEL = "com.jetbrains.docker.helper.image";
    private static final Pattern CANNOT_START_CONTAINER_PATTERN = Pattern.compile("(?s)Cannot start container [^:]+: \\[8\\] (.*)");
    private static final String HTTPS_PROTOCOL_PREFIX = "https://";
    private static final String DEFAULT_IP_FOR_UNIX_URL_SCHEME = "127.0.0.1";
    private static final char UNIX_PATH_SEPARATOR = '/';
    public static final String PYCHARM_HELPERS_IMAGE_REPOSITORY = "pycharm_helpers";

    private DockerUtil() {
    }

    @NotNull
    public static String toUnixPath(@NotNull String path) {
        if (path == null) {
            DockerUtil.$$$reportNull$$$0(0);
        }
        String string = UnixPathUtil.toUnixPath(path);
        if (string == null) {
            DockerUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    public static boolean isNoSuchImageCause(@NotNull String message) {
        if (message == null) {
            DockerUtil.$$$reportNull$$$0(2);
        }
        return message.contains("No such image:");
    }

    public static boolean isNoSuchFileCause(@NotNull String message) {
        if (message == null) {
            DockerUtil.$$$reportNull$$$0(3);
        }
        return message.contains("System error: exec:") && message.contains("no such file or directory");
    }

    public static boolean isAbsentInPathCause(@NotNull String message) {
        if (message == null) {
            DockerUtil.$$$reportNull$$$0(4);
        }
        return message.contains("System error: exec:") && message.contains("executable file not found in $PATH");
    }

    @NotNull
    public static RemoteSdkException propagateNotFoundException(@NotNull ServerRuntimeException e, @NotNull String imageName) throws RemoteSdkException {
        if (e == null) {
            DockerUtil.$$$reportNull$$$0(5);
        }
        if (imageName == null) {
            DockerUtil.$$$reportNull$$$0(6);
        }
        if (DockerUtil.isNoSuchImageCause(e.getMessage())) {
            throw new RemoteSdkException(DockerBundle.message("DockerUtil.error.docker.image.could.be.found", imageName), (Throwable)e);
        }
        String ending = DockerUtil.removeCannotStartContainerPrefix((Exception)((Object)e));
        if (ending == null) {
            throw new RemoteSdkException(e.getMessage(), (Throwable)e);
        }
        throw new RemoteSdkException(ending, (Throwable)e);
    }

    @NotNull
    public static RemoteSdkException propagateInternalServerErrorException(@NotNull ServerRuntimeException e) throws RemoteSdkException {
        String ending;
        if (e == null) {
            DockerUtil.$$$reportNull$$$0(7);
        }
        if ((ending = DockerUtil.removeCannotStartContainerPrefix((Exception)((Object)e))) != null) {
            throw new RemoteSdkException(ending, (Throwable)e);
        }
        throw new RemoteSdkException(e.getMessage(), (Throwable)e);
    }

    @NotNull
    public static RemoteSdkException propagateRemoteSdkException(@NotNull Throwable e) throws RemoteSdkException {
        if (e == null) {
            DockerUtil.$$$reportNull$$$0(8);
        }
        throw new RemoteSdkException(e.getMessage(), e);
    }

    @NotNull
    public static <R extends RuntimeException, E extends Exception> R propagateRuntimeExceptionCause(@NotNull R e, @NotNull Class<E> cause) throws E {
        if (e == null) {
            DockerUtil.$$$reportNull$$$0(9);
        }
        if (cause == null) {
            DockerUtil.$$$reportNull$$$0(10);
        }
        if (e.getCause() != null && cause.isAssignableFrom(e.getCause().getClass())) {
            throw (Exception)e.getCause();
        }
        throw e;
    }

    @Nullable
    @NlsSafe
    private static String removeCannotStartContainerPrefix(@NotNull Exception exception) {
        String message;
        Matcher matcher;
        if (exception == null) {
            DockerUtil.$$$reportNull$$$0(11);
        }
        if ((matcher = CANNOT_START_CONTAINER_PATTERN.matcher(message = Optional.ofNullable(exception.getMessage()).orElse(""))).matches()) {
            return matcher.group(1);
        }
        return null;
    }

    public static String getDockerHost(@NotNull DockerCloudConfiguration account) throws RemoteSdkException {
        if (account == null) {
            DockerUtil.$$$reportNull$$$0(12);
        }
        return DockerUtil.getDockerHost(DockerEngineUtil.getDockerApiUri(account));
    }

    @NotNull
    public static String getDockerHost(URI dockerApiUri) {
        if (DockerEngineUtil.isUnixSocket(dockerApiUri) || DockerEngineUtil.isWindowsPipe(dockerApiUri)) {
            return DEFAULT_IP_FOR_UNIX_URL_SCHEME;
        }
        String string = StringUtil.notNullize((String)dockerApiUri.getHost());
        if (string == null) {
            DockerUtil.$$$reportNull$$$0(13);
        }
        return string;
    }

    private static boolean isTlsVerifyEnabled(@Nullable String url) {
        return url != null && url.startsWith(HTTPS_PROTOCOL_PREFIX);
    }

    public static List<String[]> getNotTemplateImages(@NotNull DockerCloudConfiguration account) throws ServerRuntimeException {
        if (account == null) {
            DockerUtil.$$$reportNull$$$0(14);
        }
        RemoteDockerRuntime dockerRuntime = RemoteDockerRuntime.create(account, null);
        Set helpers = Arrays.stream(dockerRuntime.getImages(JETBRAINS_HELPERS_LABEL)).map(DockerAgentImage::getImageId).collect(Collectors.toSet());
        return Arrays.stream(dockerRuntime.getImages()).filter(image -> !helpers.contains(image.getImageId()) && !DockerUtil.isOldStyleHelperImage(image)).map(DockerAgentImage::getImageRepoTags).collect(Collectors.toList());
    }

    @Nullable
    public static String getImageArch(@NotNull DockerCloudConfiguration account, @NotNull String name2) throws ServerRuntimeException {
        RemoteDockerRuntime runtime;
        DockerAgentImage image;
        if (account == null) {
            DockerUtil.$$$reportNull$$$0(15);
        }
        if (name2 == null) {
            DockerUtil.$$$reportNull$$$0(16);
        }
        if ((image = (runtime = RemoteDockerRuntime.create(account, null)).findImageByName(name2)) == null) {
            return null;
        }
        return image.getArch();
    }

    private static boolean isOldStyleHelperImage(@NotNull DockerAgentImage image) {
        if (image == null) {
            DockerUtil.$$$reportNull$$$0(17);
        }
        for (String tag : image.getImageRepoTags()) {
            if (!tag.startsWith("pycharm_helpers:")) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static String getDockerHost(@NotNull RemoteSdkAdditionalData remoteSdkAdditionalData) {
        if (remoteSdkAdditionalData == null) {
            DockerUtil.$$$reportNull$$$0(18);
        }
        final Ref serverHostRef = Ref.create();
        remoteSdkAdditionalData.switchOnConnectionType(new CredentialsCase[]{new DockerCredentialsCase(){

            public void process(DockerCredentialsHolder credentials) {
                serverHostRef.set((Object)DockerUtil.getDockerHostForAccount(credentials.getAccountName()));
            }
        }, new DockerComposeCredentialsCase(){

            public void process(DockerComposeCredentialsHolder credentials) {
                serverHostRef.set((Object)DockerUtil.getDockerHostForAccount(credentials.getAccountName()));
            }
        }});
        if (serverHostRef.isNull()) {
            throw new IllegalArgumentException("Remote SDK has neither Docker nor Docker Compose type");
        }
        String string = (String)serverHostRef.get();
        if (string == null) {
            DockerUtil.$$$reportNull$$$0(19);
        }
        return string;
    }

    @NotNull
    private static String getDockerHostForAccount(@Nullable String accountName) {
        if (accountName == null) {
            throw new IllegalStateException("Docker account is not specified");
        }
        RemoteServer dockerServer = RemoteServersManager.getInstance().findByName(accountName, (ServerType)DockerCloudType.getInstance());
        if (dockerServer == null) {
            throw new IllegalStateException("Docker account " + accountName + " does not exist");
        }
        try {
            URI uri = new URI(((DockerCloudConfiguration)dockerServer.getConfiguration()).getApiUrl());
            return DockerUtil.getDockerHost(uri);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Failed to parse Docker API URL of the Docker account " + accountName, e);
        }
    }

    @NotNull
    public static String toDockerEnginePath(@NotNull DockerCloudConfiguration configuration, @NotNull String path) {
        if (configuration == null) {
            DockerUtil.$$$reportNull$$$0(20);
        }
        if (path == null) {
            DockerUtil.$$$reportNull$$$0(21);
        }
        if (!FileUtil.isAbsolute((String)path)) {
            String string = FileUtil.toSystemIndependentName((String)path);
            if (string == null) {
                DockerUtil.$$$reportNull$$$0(22);
            }
            return string;
        }
        List<DockerPathMappingImpl> mappings2 = configuration.getPathMappings();
        for (DockerPathMappingImpl mapping : mappings2) {
            String relativePath;
            String localPath = mapping.getLocalPath();
            String dockerEnginePath = mapping.getVirtualMachinePath();
            if (localPath == null || dockerEnginePath == null || !FileUtil.startsWith((String)path, (String)localPath) || (relativePath = FileUtil.getRelativePath((String)localPath, (String)path, (char)File.separatorChar)) == null) continue;
            String string = FileUtil.toCanonicalPath((String)DockerUtil.join(dockerEnginePath, FileUtil.normalize((String)relativePath)), (char)'/');
            if (string == null) {
                DockerUtil.$$$reportNull$$$0(23);
            }
            return string;
        }
        return DockerUtil.mapDefault(path);
    }

    @NotNull
    private static String join(@NotNull String basePath, @NotNull String relativePath) {
        if (basePath == null) {
            DockerUtil.$$$reportNull$$$0(24);
        }
        if (relativePath == null) {
            DockerUtil.$$$reportNull$$$0(25);
        }
        String string = basePath + "/" + relativePath;
        if (string == null) {
            DockerUtil.$$$reportNull$$$0(26);
        }
        return string;
    }

    @NotNull
    public static String mapDefault(@NotNull String path) {
        if (path == null) {
            DockerUtil.$$$reportNull$$$0(27);
        }
        if (SystemInfo.isWindows && OSAgnosticPathUtil.startsWithWindowsDrive((String)path)) {
            String relativePath = FileUtil.normalize((String)path.substring(2));
            String string = FileUtil.toCanonicalPath((String)DockerUtil.join("/" + Character.toLowerCase(path.charAt(0)), relativePath));
            if (string == null) {
                DockerUtil.$$$reportNull$$$0(28);
            }
            return string;
        }
        String string = path;
        if (string == null) {
            DockerUtil.$$$reportNull$$$0(29);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 13, 19, 22, 23, 26, 28, 29 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 13: 
            case 19: 
            case 22: 
            case 23: 
            case 26: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/remote/run/runtime/DockerUtil";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imageName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cause";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exception";
                break;
            }
            case 12: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "account";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "image";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteSdkAdditionalData";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "basePath";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/remote/run/runtime/DockerUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "toUnixPath";
                break;
            }
            case 13: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getDockerHost";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "toDockerEnginePath";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "join";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "mapDefault";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "toUnixPath";
                break;
            }
            case 1: 
            case 13: 
            case 19: 
            case 22: 
            case 23: 
            case 26: 
            case 28: 
            case 29: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isNoSuchImageCause";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isNoSuchFileCause";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAbsentInPathCause";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "propagateNotFoundException";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "propagateInternalServerErrorException";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "propagateRemoteSdkException";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "propagateRuntimeExceptionCause";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "removeCannotStartContainerPrefix";
                break;
            }
            case 12: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getDockerHost";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getNotTemplateImages";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getImageArch";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isOldStyleHelperImage";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "toDockerEnginePath";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "join";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "mapDefault";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 13, 19, 22, 23, 26, 28, 29 -> new IllegalStateException(string);
        };
    }
}

