/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.qml.highlighting;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.highlighting.JSHighlighter;
import com.intellij.lang.javascript.validation.JSKeywordHighlighterVisitor;
import com.intellij.lang.qml.QmlElementTypes;
import com.intellij.lang.qml.QmlLanguageDialect;
import com.intellij.lang.qml.psi.impl.QmlElementDeclarationImpl;
import com.intellij.lang.qml.psi.impl.QmlImportDeclarationImpl;
import com.intellij.lang.qml.psi.impl.QmlPropertyDeclarationImpl;
import com.intellij.lang.qml.psi.impl.QmlTypeExpressionImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QmlKeywordHighlighterVisitor
extends JSKeywordHighlighterVisitor {
    public QmlKeywordHighlighterVisitor(HighlightInfoHolder holder) {
        super(holder, new JSHighlighter(QmlLanguageDialect.QML));
    }

    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            QmlKeywordHighlighterVisitor.$$$reportNull$$$0(0);
        }
        if (element instanceof QmlImportDeclarationImpl) {
            this.highlightChildKeywordOfType(element, JSTokenTypes.AS_KEYWORD);
        } else if (element instanceof QmlElementDeclarationImpl) {
            this.highlightChildKeywordOfType(element, JSTokenTypes.ON_KEYWORD);
        } else if (element instanceof QmlPropertyDeclarationImpl) {
            IElementType[] iElementTypeArray;
            for (IElementType keywordType : JSKeywordSets.SpecialWordsHolder.QML_SPECIAL_WORDS.getTypes()) {
                this.highlightChildKeywordOfType(element, keywordType);
            }
            @Nullable ASTNode classNode = ((QmlPropertyDeclarationImpl)element).findChildByType(QmlElementTypes.QML_TYPE_REFERENCE_EXPRESSION);
            if (classNode != null && (iElementTypeArray = classNode.getPsi()) instanceof QmlTypeExpressionImpl) {
                QmlTypeExpressionImpl qmlType = (QmlTypeExpressionImpl)iElementTypeArray;
                for (IElementType keywordType : JSKeywordSets.SpecialWordsHolder.QML_SPECIAL_WORDS.getTypes()) {
                    this.highlightChildKeywordOfType((PsiElement)qmlType, keywordType);
                }
                this.highlightChildKeywordOfType((PsiElement)qmlType, JSTokenTypes.STRING_KEYWORD);
                this.highlightChildKeywordOfType((PsiElement)qmlType, JSTokenTypes.INT_KEYWORD);
                this.highlightChildKeywordOfType((PsiElement)qmlType, JSTokenTypes.VAR_KEYWORD);
            }
        }
        super.visitElement(element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/qml/highlighting/QmlKeywordHighlighterVisitor", "visitElement"));
    }
}

