/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.AstLoadingFilter;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.TreeTraversal;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.angular2.Angular2DecoratorUtil;
import org.angular2.entities.Angular2Entity;
import org.angular2.entities.source.Angular2SourceEntityListProcessor;
import org.angular2.inspections.Angular2SourceEntityListValidator;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b \u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\f\b\u0001\u0010\u0003*\u0006\u0012\u0002\b\u00030\u00042\b\u0012\u0004\u0012\u0002H\u00010\u0005:\u0002\"#B7\b\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\u0010\b\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00010\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0004J\b\u0010\u0017\u001a\u00020\u0012H\u0002J3\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00028\u00012\b\b\u0001\u0010\u001a\u001a\u00020\r2\u0012\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001d0\u001c\"\u00020\u001dH\u0004\u00a2\u0006\u0002\u0010\u001eJ;\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00028\u00012\b\b\u0001\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020 2\u0012\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001d0\u001c\"\u00020\u001dH\u0004\u00a2\u0006\u0002\u0010!R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/angular2/inspections/Angular2SourceEntityListValidator;", "T", "Lorg/angular2/entities/Angular2Entity;", "E", "", "Lorg/angular2/entities/source/Angular2SourceEntityListProcessor;", "decorator", "Lcom/intellij/lang/javascript/psi/ecma6/ES6Decorator;", "results", "Lorg/angular2/inspections/Angular2SourceEntityListValidator$ValidationResults;", "entityClass", "Ljava/lang/Class;", "propertyName", "", "<init>", "(Lcom/intellij/lang/javascript/psi/ecma6/ES6Decorator;Lorg/angular2/inspections/Angular2SourceEntityListValidator$ValidationResults;Ljava/lang/Class;Ljava/lang/String;)V", "myIterator", "Lcom/intellij/util/containers/TreeTraversal$TracingIt;", "Lcom/intellij/psi/PsiElement;", "validate", "", "hasForwardRefCall", "", "locateProblemElement", "registerProblem", "problemType", "message", "quickFixes", "", "Lcom/intellij/codeInspection/LocalQuickFix;", "(Ljava/lang/Enum;Ljava/lang/String;[Lcom/intellij/codeInspection/LocalQuickFix;)V", "severity", "Lcom/intellij/codeInspection/ProblemHighlightType;", "(Ljava/lang/Enum;Ljava/lang/String;Lcom/intellij/codeInspection/ProblemHighlightType;[Lcom/intellij/codeInspection/LocalQuickFix;)V", "ValidationProblem", "ValidationResults", "intellij.angular"})
@SourceDebugExtension(value={"SMAP\nAngular2SourceEntityListValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Angular2SourceEntityListValidator.kt\norg/angular2/inspections/Angular2SourceEntityListValidator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,132:1\n1755#2,3:133\n*S KotlinDebug\n*F\n+ 1 Angular2SourceEntityListValidator.kt\norg/angular2/inspections/Angular2SourceEntityListValidator\n*L\n50#1:133,3\n*E\n"})
public abstract class Angular2SourceEntityListValidator<T extends Angular2Entity, E extends Enum<?>>
extends Angular2SourceEntityListProcessor<T> {
    @NotNull
    private final ES6Decorator decorator;
    @NotNull
    private final ValidationResults<? super E> results;
    @NotNull
    private final String propertyName;
    private TreeTraversal.TracingIt<PsiElement> myIterator;

    protected Angular2SourceEntityListValidator(@NotNull ES6Decorator decorator, @NotNull ValidationResults<? super E> results, @NotNull Class<T> entityClass, @NotNull String propertyName) {
        Intrinsics.checkNotNullParameter((Object)decorator, (String)"decorator");
        Intrinsics.checkNotNullParameter(results, (String)"results");
        Intrinsics.checkNotNullParameter(entityClass, (String)"entityClass");
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        super(entityClass, (PsiElement)decorator);
        this.decorator = decorator;
        this.results = results;
        this.propertyName = propertyName;
    }

    public void validate() {
        JSProperty jSProperty = Angular2DecoratorUtil.getProperty(this.decorator, this.propertyName);
        if (jSProperty == null) {
            return;
        }
        JSProperty property = jSProperty;
        AstLoadingFilter.forceAllowTreeLoading((PsiFile)property.getContainingFile(), () -> Angular2SourceEntityListValidator.validate$lambda$2(property, this));
    }

    protected final boolean hasForwardRefCall() {
        boolean bl;
        block4: {
            TreeTraversal.TracingIt<PsiElement> tracingIt = this.myIterator;
            if (tracingIt == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myIterator");
                tracingIt = null;
            }
            JBIterable jBIterable = tracingIt.backtrace();
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"backtrace(...)");
            Iterable $this$any$iv = (Iterable)jBIterable;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PsiElement it = (PsiElement)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)it);
                    if (!Angular2DecoratorUtil.INSTANCE.isForwardRefCall(it)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final PsiElement locateProblemElement() {
        PsiFile psiFile = this.decorator.getContainingFile().getOriginalFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getOriginalFile(...)");
        PsiFile file = psiFile;
        TreeTraversal.TracingIt<PsiElement> tracingIt = this.myIterator;
        if (tracingIt == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myIterator");
            tracingIt = null;
        }
        Iterable iterable = CollectionsKt.listOf((Object)tracingIt.current());
        TreeTraversal.TracingIt<PsiElement> tracingIt2 = this.myIterator;
        if (tracingIt2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myIterator");
            tracingIt2 = null;
        }
        for (PsiElement el : ContainerUtil.concat((Iterable)iterable, (Iterable)((Iterable)tracingIt2.backtrace()))) {
            if (!Intrinsics.areEqual((Object)file, (Object)el.getContainingFile().getOriginalFile()) || !this.decorator.getTextRange().contains(el.getTextRange())) continue;
            Intrinsics.checkNotNull((Object)el);
            return el;
        }
        return (PsiElement)this.decorator;
    }

    protected final void registerProblem(@NotNull E problemType, @Nls @NotNull String message, LocalQuickFix ... quickFixes) {
        Intrinsics.checkNotNullParameter(problemType, (String)"problemType");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)quickFixes, (String)"quickFixes");
        this.results.registerProblem$intellij_angular(this.locateProblemElement(), problemType, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, Arrays.copyOf(quickFixes, quickFixes.length));
    }

    protected final void registerProblem(@NotNull E problemType, @Nls @NotNull String message, @NotNull ProblemHighlightType severity, LocalQuickFix ... quickFixes) {
        Intrinsics.checkNotNullParameter(problemType, (String)"problemType");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)severity, (String)"severity");
        Intrinsics.checkNotNullParameter((Object)quickFixes, (String)"quickFixes");
        this.results.registerProblem$intellij_angular(this.locateProblemElement(), problemType, message, severity, Arrays.copyOf(quickFixes, quickFixes.length));
    }

    private static final Iterable validate$lambda$2$lambda$0(HashSet $visited, Angular2SourceEntityListValidator this$0, PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return $visited.add(element) ? this$0.resolve(element) : CollectionsKt.emptyList();
    }

    private static final Iterable validate$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
        return (Iterable)$tmp0.invoke(p0);
    }

    private static final void validate$lambda$2(JSProperty $property, Angular2SourceEntityListValidator this$0) {
        JSExpression value = $property.getValue();
        if (value == null) {
            return;
        }
        HashSet visited = new HashSet();
        this$0.myIterator = (TreeTraversal.TracingIt)TreeTraversal.LEAVES_DFS.traversal((Iterable)CollectionsKt.listOf((Object)value), arg_0 -> Angular2SourceEntityListValidator.validate$lambda$2$lambda$1(arg_0 -> Angular2SourceEntityListValidator.validate$lambda$2$lambda$0(visited, this$0, arg_0), arg_0)).typedIterator();
        while (true) {
            TreeTraversal.TracingIt<PsiElement> tracingIt;
            if ((tracingIt = this$0.myIterator) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myIterator");
                tracingIt = null;
            }
            if (!tracingIt.advance()) break;
            ProgressManager.checkCanceled();
            TreeTraversal.TracingIt<PsiElement> tracingIt2 = this$0.myIterator;
            if (tracingIt2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myIterator");
                tracingIt2 = null;
            }
            ((PsiElement)tracingIt2.current()).accept((PsiElementVisitor)this$0.getResultsVisitor());
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0017\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00020\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u0010X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0014\u00c0\u0006\u0001"}, d2={"Lorg/angular2/inspections/Angular2SourceEntityListValidator$ValidationProblem;", "", "location", "Lcom/intellij/psi/PsiElement;", "getLocation", "()Lcom/intellij/psi/PsiElement;", "message", "", "Lorg/jetbrains/annotations/Nls;", "getMessage", "()Ljava/lang/String;", "severity", "Lcom/intellij/codeInspection/ProblemHighlightType;", "getSeverity", "()Lcom/intellij/codeInspection/ProblemHighlightType;", "fixes", "", "Lcom/intellij/codeInspection/LocalQuickFix;", "getFixes", "()[Lcom/intellij/codeInspection/LocalQuickFix;", "intellij.angular"})
    public static interface ValidationProblem {
        @NotNull
        public PsiElement getLocation();

        @NotNull
        public String getMessage();

        @NotNull
        public ProblemHighlightType getSeverity();

        @NotNull
        public LocalQuickFix[] getFixes();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0010\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 \u001f*\f\b\u0002\u0010\u0001*\u0006\u0012\u0002\b\u00030\u00022\u00020\u0003:\u0001\u001fB\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001d\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00028\u00022\u0006\u0010\f\u001a\u00020\rH\u0016\u00a2\u0006\u0002\u0010\u000eJ\u0019\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u00102\u0006\u0010\u000b\u001a\u00028\u0002\u00a2\u0006\u0002\u0010\u0011JE\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00028\u00022\b\b\u0001\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0012\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001c0\u001b\"\u00020\u001cH\u0000\u00a2\u0006\u0004\b\u001d\u0010\u001eR\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/angular2/inspections/Angular2SourceEntityListValidator$ValidationResults;", "T", "", "", "<init>", "()V", "results", "Lcom/intellij/util/containers/MultiMap;", "Lorg/angular2/inspections/Angular2SourceEntityListValidator$ValidationProblem;", "registerProblems", "", "problemType", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "(Ljava/lang/Enum;Lcom/intellij/codeInspection/ProblemsHolder;)V", "getProblems", "", "(Ljava/lang/Enum;)Ljava/util/Collection;", "registerProblem", "element", "Lcom/intellij/psi/PsiElement;", "type", "message", "", "severity", "Lcom/intellij/codeInspection/ProblemHighlightType;", "quickFixes", "", "Lcom/intellij/codeInspection/LocalQuickFix;", "registerProblem$intellij_angular", "(Lcom/intellij/psi/PsiElement;Ljava/lang/Enum;Ljava/lang/String;Lcom/intellij/codeInspection/ProblemHighlightType;[Lcom/intellij/codeInspection/LocalQuickFix;)V", "Companion", "intellij.angular"})
    public static class ValidationResults<T extends Enum<?>> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final MultiMap<T, ValidationProblem> results = new MultiMap();
        @NotNull
        private static final Companion.EMPTY.1 EMPTY = new ValidationResults<Enum<?>>(){

            public void registerProblems(Enum<?> problemType, ProblemsHolder holder) {
                Intrinsics.checkNotNullParameter(problemType, (String)"problemType");
                Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            }
        };

        public void registerProblems(@NotNull T problemType, @NotNull ProblemsHolder holder) {
            Intrinsics.checkNotNullParameter(problemType, (String)"problemType");
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            for (ValidationProblem problem : this.results.get(problemType)) {
                LocalQuickFix[] localQuickFixArray = problem.getFixes();
                holder.registerProblem(problem.getLocation(), problem.getMessage(), problem.getSeverity(), Arrays.copyOf(localQuickFixArray, localQuickFixArray.length));
            }
        }

        @NotNull
        public final Collection<ValidationProblem> getProblems(@NotNull T problemType) {
            Intrinsics.checkNotNullParameter(problemType, (String)"problemType");
            Collection collection = this.results.get(problemType);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"get(...)");
            return collection;
        }

        public final void registerProblem$intellij_angular(@NotNull PsiElement element, @NotNull T type, @Nls @NotNull String message, @NotNull ProblemHighlightType severity, LocalQuickFix ... quickFixes) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter(type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)severity, (String)"severity");
            Intrinsics.checkNotNullParameter((Object)quickFixes, (String)"quickFixes");
            this.results.putValue(type, (Object)new ValidationProblem(message, element, severity, quickFixes){
                final /* synthetic */ String $message;
                final /* synthetic */ PsiElement $element;
                final /* synthetic */ ProblemHighlightType $severity;
                final /* synthetic */ LocalQuickFix[] $quickFixes;
                {
                    this.$message = $message;
                    this.$element = $element;
                    this.$severity = $severity;
                    this.$quickFixes = $quickFixes;
                }

                public String getMessage() {
                    return this.$message;
                }

                public PsiElement getLocation() {
                    return this.$element;
                }

                public ProblemHighlightType getSeverity() {
                    return this.$severity;
                }

                public LocalQuickFix[] getFixes() {
                    return this.$quickFixes;
                }
            });
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0010\n\u0000\n\u0002\b\u0003*\u0001\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\f\b\u0003\u0010\u0006*\u0006\u0012\u0002\b\u00030\u0007R\u0010\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/angular2/inspections/Angular2SourceEntityListValidator$ValidationResults$Companion;", "", "<init>", "()V", "empty", "Lorg/angular2/inspections/Angular2SourceEntityListValidator$ValidationResults;", "T", "", "EMPTY", "org/angular2/inspections/Angular2SourceEntityListValidator$ValidationResults$Companion$EMPTY$1", "Lorg/angular2/inspections/Angular2SourceEntityListValidator$ValidationResults$Companion$EMPTY$1;", "intellij.angular"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final <T extends Enum<?>> ValidationResults<T> empty() {
                EMPTY.1 v0 = EMPTY;
                Intrinsics.checkNotNull((Object)v0, (String)"null cannot be cast to non-null type org.angular2.inspections.Angular2SourceEntityListValidator.ValidationResults<T of org.angular2.inspections.Angular2SourceEntityListValidator.ValidationResults.Companion.empty>");
                return v0;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

