/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder.components;

import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.view.BaseGraphMouseWheelListener;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.util.MathUtil;
import java.awt.Point;
import org.jetbrains.annotations.NotNull;

public final class CustomGraphBuilderWheelListener
extends BaseGraphMouseWheelListener {
    public CustomGraphBuilderWheelListener(@NotNull GraphBuilder<?, ?> customBuilder) {
        if (customBuilder == null) {
            CustomGraphBuilderWheelListener.$$$reportNull$$$0(0);
        }
        super(customBuilder);
    }

    @Override
    protected void doZoomChange() {
        GraphBuilder<?, ?> customBuilder = this.getBuilder();
        Graph2DView customView = customBuilder.getView();
        double currentZoomDelta = this.getCurrentZoomDelta();
        Point lastZoomPoint = this.getLastZoomPoint();
        double newZoom = MathUtil.clamp((double)(customView.getZoom() * currentZoomDelta), (double)-2.147483648E9, (double)20.0);
        double oldX = customView.toWorldCoordX(lastZoomPoint.x);
        double oldY = customView.toWorldCoordY(lastZoomPoint.y);
        customBuilder.setZoom(newZoom);
        double newX = customView.toWorldCoordX(lastZoomPoint.x);
        double newY = customView.toWorldCoordY(lastZoomPoint.y);
        double cx = customView.getCenter().getX();
        double cy = customView.getCenter().getY();
        customView.setCenter(cx + oldX - newX, cy + oldY - newY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "customBuilder", "com/intellij/openapi/graph/builder/components/CustomGraphBuilderWheelListener", "<init>"));
    }
}

