/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.layout.tile;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.plot.base.layout.Thickness;
import org.jetbrains.letsPlot.core.plot.builder.coord.CoordProvider;
import org.jetbrains.letsPlot.core.plot.builder.layout.AxisLayoutInfo;
import org.jetbrains.letsPlot.core.plot.builder.layout.AxisLayoutInfoQuad;
import org.jetbrains.letsPlot.core.plot.builder.layout.AxisLayoutQuad;
import org.jetbrains.letsPlot.core.plot.builder.layout.GeomMarginsLayout;
import org.jetbrains.letsPlot.core.plot.builder.layout.tile.TopDownTileLayout;
import org.jetbrains.letsPlot.core.plot.builder.layout.util.GeomAreaInsets;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/layout/tile/PolarTileLayout;", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/tile/TopDownTileLayout;", "axisLayoutQuad", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/AxisLayoutQuad;", "hDomain", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "vDomain", "marginsLayout", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/GeomMarginsLayout;", "panelInset", "Lorg/jetbrains/letsPlot/core/plot/base/layout/Thickness;", "(Lorg/jetbrains/letsPlot/core/plot/builder/layout/AxisLayoutQuad;Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;Lorg/jetbrains/letsPlot/core/plot/builder/layout/GeomMarginsLayout;Lorg/jetbrains/letsPlot/core/plot/base/layout/Thickness;)V", "computeAxisInfos", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/util/GeomAreaInsets;", "plotSize", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "coordProvider", "Lorg/jetbrains/letsPlot/core/plot/builder/coord/CoordProvider;", "computeGeomWithAxisBounds", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "geomOuterBounds", "axisInfos", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/AxisLayoutInfoQuad;", "plot-builder"})
public final class PolarTileLayout
extends TopDownTileLayout {
    @NotNull
    private final AxisLayoutQuad axisLayoutQuad;
    @NotNull
    private final DoubleSpan hDomain;
    @NotNull
    private final DoubleSpan vDomain;

    public PolarTileLayout(@NotNull AxisLayoutQuad axisLayoutQuad, @NotNull DoubleSpan hDomain, @NotNull DoubleSpan vDomain, @NotNull GeomMarginsLayout marginsLayout, @NotNull Thickness panelInset) {
        Intrinsics.checkNotNullParameter((Object)axisLayoutQuad, (String)"axisLayoutQuad");
        Intrinsics.checkNotNullParameter((Object)hDomain, (String)"hDomain");
        Intrinsics.checkNotNullParameter((Object)vDomain, (String)"vDomain");
        Intrinsics.checkNotNullParameter((Object)marginsLayout, (String)"marginsLayout");
        Intrinsics.checkNotNullParameter((Object)panelInset, (String)"panelInset");
        super(axisLayoutQuad, hDomain, vDomain, marginsLayout, panelInset);
        this.axisLayoutQuad = axisLayoutQuad;
        this.hDomain = hDomain;
        this.vDomain = vDomain;
    }

    @Override
    @NotNull
    protected DoubleRectangle computeGeomWithAxisBounds(@NotNull DoubleRectangle geomOuterBounds, @NotNull AxisLayoutInfoQuad axisInfos) {
        Intrinsics.checkNotNullParameter((Object)geomOuterBounds, (String)"geomOuterBounds");
        Intrinsics.checkNotNullParameter((Object)axisInfos, (String)"axisInfos");
        Object object = axisInfos.getLeft();
        return DoubleRectangle.Companion.LTRB(object != null && (object = ((AxisLayoutInfo)object).axisBoundsAbsolute(geomOuterBounds)) != null ? ((DoubleRectangle)object).getLeft() : geomOuterBounds.getLeft(), geomOuterBounds.getTop(), geomOuterBounds.getRight(), geomOuterBounds.getBottom());
    }

    @Override
    @NotNull
    protected GeomAreaInsets computeAxisInfos(@NotNull DoubleVector plotSize2, @NotNull CoordProvider coordProvider) {
        Intrinsics.checkNotNullParameter((Object)plotSize2, (String)"plotSize");
        Intrinsics.checkNotNullParameter((Object)coordProvider, (String)"coordProvider");
        GeomAreaInsets insetsInitial = GeomAreaInsets.Companion.init(this.axisLayoutQuad);
        double axisHeightEstim = this.geomContentBounds(insetsInitial, plotSize2, coordProvider).getDimension().getY() / (double)2;
        GeomAreaInsets insetsVAxis = insetsInitial.layoutVAxis(this.vDomain, axisHeightEstim);
        DoubleRectangle contentBounds = this.geomContentBounds(insetsVAxis, plotSize2, coordProvider);
        double hAxisLength = contentBounds.getWidth() * 1.5;
        return insetsVAxis.layoutHAxis(this.hDomain, hAxisLength);
    }
}

