/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.relocated.apache.batik.ext.awt.color;

import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;

public class ICCColorSpaceExt
extends ICC_ColorSpace {
    public static final int PERCEPTUAL = 0;
    public static final int RELATIVE_COLORIMETRIC = 1;
    public static final int ABSOLUTE_COLORIMETRIC = 2;
    public static final int SATURATION = 3;
    public static final int AUTO = 4;
    static final ColorSpace sRGB = ColorSpace.getInstance(1000);
    int intent;

    public ICCColorSpaceExt(ICC_Profile p, int intent) {
        super(p);
        this.intent = intent;
        switch (intent) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        if (intent != 4) {
            byte[] hdr = p.getData(1751474532);
            hdr[64] = (byte)intent;
        }
    }

    public float[] intendedToRGB(float[] values2) {
        switch (this.intent) {
            case 2: {
                return this.absoluteColorimetricToRGB(values2);
            }
            case 0: 
            case 4: {
                return this.perceptualToRGB(values2);
            }
            case 1: {
                return this.relativeColorimetricToRGB(values2);
            }
            case 3: {
                return this.saturationToRGB(values2);
            }
        }
        throw new RuntimeException("invalid intent:" + this.intent);
    }

    public float[] perceptualToRGB(float[] values2) {
        return this.toRGB(values2);
    }

    public float[] relativeColorimetricToRGB(float[] values2) {
        float[] ciexyz = this.toCIEXYZ(values2);
        return sRGB.fromCIEXYZ(ciexyz);
    }

    public float[] absoluteColorimetricToRGB(float[] values2) {
        return this.perceptualToRGB(values2);
    }

    public float[] saturationToRGB(float[] values2) {
        return this.perceptualToRGB(values2);
    }
}

