/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.diff.extensions;

import com.intellij.diff.DiffContext;
import com.intellij.diff.DiffTool;
import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.SuppressiveDiffTool;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.fragmented.UnifiedDiffTool;
import com.intellij.diff.tools.simple.SimpleDiffTool;
import com.intellij.diff.tools.simple.SimpleDiffViewer;
import com.intellij.diff.tools.simple.SimpleOnesideDiffViewer;
import com.intellij.diff.tools.simple.SimpleThreesideDiffViewer;
import com.intellij.jupyter.core.jupyter.JupyterBundle;
import com.intellij.jupyter.diff.extensions.RequestSubstitutors;
import com.intellij.jupyter.diff.util.JupyterDiffViewerUtils;
import com.intellij.notebooks.jupyter.core.jupyter.JupyterFileType;
import com.intellij.openapi.util.registry.Registry;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\bH\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0016\u0010\u0010\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u00120\u0011H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/intellij/jupyter/diff/extensions/JupyterDiffTool;", "Lcom/intellij/diff/FrameDiffTool;", "Lcom/intellij/diff/SuppressiveDiffTool;", "<init>", "()V", "getName", "", "canShow", "", "context", "Lcom/intellij/diff/DiffContext;", "request", "Lcom/intellij/diff/requests/DiffRequest;", "isEnabled", "createComponent", "Lcom/intellij/diff/FrameDiffTool$DiffViewer;", "getSuppressedTools", "", "Ljava/lang/Class;", "Lcom/intellij/diff/DiffTool;", "intellij.jupyter.diff"})
@SourceDebugExtension(value={"SMAP\nJupyterDiffTool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterDiffTool.kt\ncom/intellij/jupyter/diff/extensions/JupyterDiffTool\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,51:1\n1734#2,3:52\n1734#2,3:55\n*S KotlinDebug\n*F\n+ 1 JupyterDiffTool.kt\ncom/intellij/jupyter/diff/extensions/JupyterDiffTool\n*L\n30#1:52,3\n31#1:55,3\n*E\n"})
public final class JupyterDiffTool
implements FrameDiffTool,
SuppressiveDiffTool {
    @NotNull
    public String getName() {
        return JupyterBundle.message((String)"jupyter.diff.viewer", (Object[])new Object[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canShow(@NotNull DiffContext context, @NotNull DiffRequest request) {
        DiffContent it;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (!(request instanceof ContentDiffRequest)) return false;
        if (!this.isEnabled()) {
            return false;
        }
        List list = ((ContentDiffRequest)request).getContents();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getContents(...)");
        List contents = list;
        int n = contents.size();
        if (1 > n) return false;
        if (n >= 4) return false;
        boolean bl2 = true;
        if (!bl2) return false;
        Iterable $this$all$iv = contents;
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            bl = true;
        } else {
            for (Object element$iv : $this$all$iv) {
                it = (DiffContent)element$iv;
                boolean bl3 = false;
                if (!(it instanceof DocumentContent) || !(((DocumentContent)it).getContentType() instanceof JupyterFileType)) {
                    if (!(it instanceof EmptyContent)) return false;
                }
                boolean bl4 = true;
                if (bl4) continue;
                return false;
            }
            bl = true;
        }
        if (!bl) return false;
        $this$all$iv = contents;
        $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$all$iv.iterator();
        do {
            Object element$iv;
            if (!iterator.hasNext()) return false;
            element$iv = iterator.next();
            it = (DiffContent)element$iv;
            boolean bl5 = false;
        } while (it instanceof EmptyContent);
        return true;
    }

    private final boolean isEnabled() {
        return Registry.Companion.is("jupyter.diff.viewer");
    }

    @NotNull
    public FrameDiffTool.DiffViewer createComponent(@NotNull DiffContext context, @NotNull DiffRequest request) {
        FrameDiffTool.DiffViewer diffViewer;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        DiffRequest diffRequest = RequestSubstitutors.INSTANCE.substituteDiffRequest(context, request);
        if (diffRequest == null) {
            FrameDiffTool.DiffViewer diffViewer2 = SimpleDiffTool.INSTANCE.createComponent(context, request);
            Intrinsics.checkNotNullExpressionValue((Object)diffViewer2, (String)"createComponent(...)");
            return diffViewer2;
        }
        DiffRequest newRequest = diffRequest;
        if (SimpleOnesideDiffViewer.canShowRequest((DiffContext)context, (DiffRequest)request)) {
            diffViewer = (FrameDiffTool.DiffViewer)JupyterDiffViewerUtils.INSTANCE.oneSide(context, newRequest);
        } else if (SimpleDiffViewer.canShowRequest((DiffContext)context, (DiffRequest)request)) {
            diffViewer = (FrameDiffTool.DiffViewer)JupyterDiffViewerUtils.INSTANCE.twoSide(context, newRequest);
        } else if (SimpleThreesideDiffViewer.canShowRequest((DiffContext)context, (DiffRequest)request)) {
            diffViewer = (FrameDiffTool.DiffViewer)JupyterDiffViewerUtils.INSTANCE.threeSide(context, newRequest);
        } else {
            throw new IllegalArgumentException(request.toString());
        }
        return diffViewer;
    }

    @NotNull
    public List<Class<? extends DiffTool>> getSuppressedTools() {
        Object[] objectArray = new Class[]{UnifiedDiffTool.class, SimpleDiffTool.class};
        return CollectionsKt.mutableListOf((Object[])objectArray);
    }
}

