/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run;

import com.intellij.execution.CantRunException;
import com.intellij.execution.Executor;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RefactoringListenerProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.impl.statistics.FusAwareRunConfiguration;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.util.ProgramParametersUtil;
import com.intellij.execution.util.ScriptFileUtil;
import com.intellij.ide.browsers.StartBrowserSettings;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.javascript.JSRunProfileWithCompileBeforeLaunchOption;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.debug.NodeDebugRunConfiguration;
import com.intellij.javascript.nodejs.execution.AbstractNodeTargetRunProfile;
import com.intellij.javascript.nodejs.execution.runConfiguration.NodeRunConfigurationExtensionsManager;
import com.intellij.javascript.nodejs.interpreter.NodeInterpreterUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.monorepo.JSMonorepoNameUtils;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.buildTools.npm.rc.StartBrowserSettingsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.io.PathKt;
import com.intellij.util.text.SemVer;
import com.jetbrains.nodejs.NodeJSBundle;
import com.jetbrains.nodejs.run.NodeJsRunConfigurationEditor;
import com.jetbrains.nodejs.run.NodeJsRunConfigurationFus;
import com.jetbrains.nodejs.run.NodeJsRunConfigurationRefactoringHandler;
import com.jetbrains.nodejs.run.NodeJsRunConfigurationState;
import com.jetbrains.nodejs.run.NodeJsRunConfigurationType;
import com.jetbrains.nodejs.run.NodeJsRunProfileState;
import com.jetbrains.nodejs.run.NodeJsRunTypeScriptLoader;
import com.jetbrains.nodejs.run.TypeScriptFileLoader;
import com.jetbrains.nodejs.run.profile.settings.NodeProfilingSettings;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class NodeJsRunConfiguration
extends AbstractNodeTargetRunProfile
implements NodeDebugRunConfiguration,
RefactoringListenerProvider,
JSRunProfileWithCompileBeforeLaunchOption,
FusAwareRunConfiguration,
StartBrowserSettingsHolder {
    @NotNull
    private StartBrowserSettings myStartBrowserSettings = new StartBrowserSettings();
    @NotNull
    private NodeProfilingSettings myNodeProfilingSettings;
    @NotNull
    private EnvironmentVariablesData myEnvData = EnvironmentVariablesData.DEFAULT;

    NodeJsRunConfiguration(Project project, ConfigurationFactory factory, @Nullable String name) {
        super(project, factory, name);
        this.myNodeProfilingSettings = new NodeProfilingSettings();
    }

    @NotNull
    protected NodeJsRunConfigurationState getOptions() {
        NodeJsRunConfigurationState nodeJsRunConfigurationState = (NodeJsRunConfigurationState)super.getOptions();
        if (nodeJsRunConfigurationState == null) {
            NodeJsRunConfiguration.$$$reportNull$$$0(0);
        }
        return nodeJsRunConfigurationState;
    }

    @TestOnly
    public void setNodeInterpreter(@NotNull String path) {
        if (path == null) {
            NodeJsRunConfiguration.$$$reportNull$$$0(1);
        }
        this.getOptions().setInterpreterRef(NodeJsInterpreterRef.create((NodeJsInterpreter)new NodeJsLocalInterpreter(path)));
    }

    @NotNull
    public StartBrowserSettings getStartBrowserSettings() {
        StartBrowserSettings startBrowserSettings = this.myStartBrowserSettings;
        if (startBrowserSettings == null) {
            NodeJsRunConfiguration.$$$reportNull$$$0(2);
        }
        return startBrowserSettings;
    }

    public void setStartBrowserSettings(@NotNull StartBrowserSettings settings) {
        if (settings == null) {
            NodeJsRunConfiguration.$$$reportNull$$$0(3);
        }
        this.myStartBrowserSettings = settings;
    }

    @NotNull
    public NodeProfilingSettings getNodeProfilingSettings() {
        NodeProfilingSettings nodeProfilingSettings = this.myNodeProfilingSettings;
        if (nodeProfilingSettings == null) {
            NodeJsRunConfiguration.$$$reportNull$$$0(4);
        }
        return nodeProfilingSettings;
    }

    public void setNodeProfilingSettings(@NotNull NodeProfilingSettings nodeProfilingSettings) {
        if (nodeProfilingSettings == null) {
            NodeJsRunConfiguration.$$$reportNull$$$0(5);
        }
        this.myNodeProfilingSettings = nodeProfilingSettings;
    }

    public RunConfiguration clone() {
        NodeJsRunConfiguration clone = (NodeJsRunConfiguration)super.clone();
        clone.myNodeProfilingSettings = new NodeProfilingSettings(this.myNodeProfilingSettings);
        return clone;
    }

    public void onNewConfigurationCreated() {
        String workingDir = this.getWorkingDirectory();
        if (StringUtil.isEmptyOrSpaces((String)workingDir)) {
            this.getOptions().setWorkingDir(StringUtil.notNullize((String)this.getProject().getBasePath()));
        }
    }

    @NotNull
    public NodeJsRunConfigurationEditor createConfigurationEditor() {
        return new NodeJsRunConfigurationEditor(this.getProject());
    }

    public boolean shouldShowLogsTab() {
        return true;
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) {
        if (executor == null) {
            NodeJsRunConfiguration.$$$reportNull$$$0(6);
        }
        if (environment == null) {
            NodeJsRunConfiguration.$$$reportNull$$$0(7);
        }
        return new NodeJsRunProfileState(environment, this);
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        Path workingDir;
        NodeJsInterpreter interpreter = this.getInterpreter();
        NodeInterpreterUtil.checkForRunConfiguration((NodeJsInterpreter)interpreter);
        NodeRunConfigurationExtensionsManager.getInstance().checkConfiguration((AbstractNodeTargetRunProfile)this);
        NodeJsRunConfiguration.validateTypeScriptLoader(this.getTypeScriptLoader(), interpreter);
        String workingDirPath = this.getWorkingDirectory();
        Path path = workingDir = workingDirPath == null ? null : Paths.get(workingDirPath, new String[0]);
        if (workingDir == null || !workingDir.isAbsolute() || !workingDir.toFile().isDirectory()) {
            throw new RuntimeConfigurationError(NodeJSBundle.message("rc.nodejs.error.incorrect.workingDirectory.text", new Object[0]));
        }
        String mainScriptFilePath = this.getMainScriptFilePath();
        String pathToJsFile = ProgramParametersUtil.expandPathAndMacros((String)mainScriptFilePath, null, (Project)this.getProject());
        if (Objects.equals(pathToJsFile, mainScriptFilePath)) {
            NodeJsRunConfiguration.validatePath(workingDir, pathToJsFile);
        }
        StartBrowserSettingsHolder.checkBrowserSettings((StartBrowserSettings)this.myStartBrowserSettings);
        this.myNodeProfilingSettings.check(pathToJsFile);
    }

    private static void validateTypeScriptLoader(@NotNull NodeJsRunTypeScriptLoader loader, @Nullable NodeJsInterpreter interpreter) throws RuntimeConfigurationError {
        if (loader == null) {
            NodeJsRunConfiguration.$$$reportNull$$$0(8);
        }
        if (loader != NodeJsRunTypeScriptLoader.BUNDLED) {
            return;
        }
        SemVer version = Optional.ofNullable(interpreter).map(NodeJsInterpreter::getCachedVersion).map(Ref::get).orElse(null);
        if (version == null || version.isGreaterOrEqualThan(TypeScriptFileLoader.NODE_MINIMUM_VERSION)) {
            return;
        }
        throw new RuntimeConfigurationError(NodeJSBundle.message("rc.nodejs.error.bundled.loader.requires.higher.node.text", new Object[0]));
    }

    public static void validatePath(@NotNull Path workingDir, @Nullable String jsFilePath) throws RuntimeConfigurationError {
        BasicFileAttributes attributes;
        if (workingDir == null) {
            NodeJsRunConfiguration.$$$reportNull$$$0(9);
        }
        if (jsFilePath == null) {
            return;
        }
        if (ScriptFileUtil.isMemoryScriptPath((String)jsFilePath)) {
            if (ScriptFileUtil.findScriptFileByPath((String)jsFilePath) == null) {
                throw new RuntimeConfigurationError(NodeJSBundle.message("rc.nodejs.error.script.not.found.text", new Object[0]));
            }
            return;
        }
        Path jsFile = NodeJsRunConfiguration.getPath(jsFilePath);
        if (jsFile != null && jsFile.isAbsolute() && (attributes = PathKt.basicAttributesIfExists((Path)jsFile)) != null && (attributes.isRegularFile() || attributes.isSymbolicLink())) {
            return;
        }
        try {
            jsFile = workingDir.resolve(jsFilePath);
            attributes = PathKt.basicAttributesIfExists((Path)jsFile);
            if (attributes != null && (attributes.isRegularFile() || attributes.isSymbolicLink())) {
                return;
            }
        }
        catch (InvalidPathException invalidPathException) {
            // empty catch block
        }
        throw new RuntimeConfigurationError(NodeJSBundle.message("rc.nodejs.error.incorrect.file.path.text", new Object[0]));
    }

    @Nullable
    private static Path getPath(@Nullable String filePath) {
        if (filePath == null) {
            return null;
        }
        try {
            return Paths.get(filePath, new String[0]);
        }
        catch (InvalidPathException e) {
            return null;
        }
    }

    @Nullable
    public NodeJsInterpreter getInterpreter() {
        return this.getOptions().getInterpreterRef().resolve(this.getProject());
    }

    @NotNull
    public NodeJsInterpreterRef getInterpreterRef() {
        NodeJsInterpreterRef nodeJsInterpreterRef = this.getOptions().getInterpreterRef();
        if (nodeJsInterpreterRef == null) {
            NodeJsRunConfiguration.$$$reportNull$$$0(10);
        }
        return nodeJsInterpreterRef;
    }

    @NotNull
    public NodeJsRunTypeScriptLoader getTypeScriptLoader() {
        NodeJsRunTypeScriptLoader nodeJsRunTypeScriptLoader = this.getOptions().getTypeScriptLoader();
        if (nodeJsRunTypeScriptLoader == null) {
            NodeJsRunConfiguration.$$$reportNull$$$0(11);
        }
        return nodeJsRunTypeScriptLoader;
    }

    public void setTypeScriptLoader(@NotNull NodeJsRunTypeScriptLoader loader) {
        if (loader == null) {
            NodeJsRunConfiguration.$$$reportNull$$$0(12);
        }
        this.getOptions().setTypeScriptLoader(loader);
    }

    public String suggestedName() {
        String packageName = JSMonorepoNameUtils.guessContextPackageName((Project)this.getProject(), (VirtualFile)this.getContextFile());
        return this.suggestName(packageName);
    }

    @Nullable
    private VirtualFile getContextFile() {
        String filePath = this.getOptions().getPathToFile();
        return filePath != null ? LocalFileSystem.getInstance().findFileByPath(filePath) : null;
    }

    @Nullable
    public String getActionName() {
        if (JSMonorepoNameUtils.isComposed((String)this.getName()) && this.isGeneratedName()) {
            return this.suggestName(null);
        }
        return super.getActionName();
    }

    @NotNull
    @Nls
    private String suggestName(@Nullable @Nls String contextPackageName) {
        String baseName = PathUtil.getFileName((String)StringUtil.notNullize((String)this.getOptions().getPathToFile()));
        String string = JSMonorepoNameUtils.buildContextName((String)contextPackageName, (String)baseName);
        if (string == null) {
            NodeJsRunConfiguration.$$$reportNull$$$0(13);
        }
        return string;
    }

    public void addCoffeeScriptNodeOptionIfNeeded() {
        String pathToFile = this.getOptions().getPathToFile();
        if (pathToFile == null || !pathToFile.endsWith(".coffee")) {
            return;
        }
        String packageName = NodeJsRunConfiguration.guessCoffeeScriptPackage(this.getProject());
        String nodeOption = "--require " + packageName + "/register";
        Object nodeParameters = StringUtil.notNullize((String)this.getOptions().getNodeParameters());
        if (!((String)nodeParameters).contains(nodeOption)) {
            if (!((String)(nodeParameters = StringUtil.trimEnd((String)nodeParameters, (String)" "))).isEmpty()) {
                nodeParameters = (String)nodeParameters + " ";
            }
            this.getOptions().setNodeParameters((String)nodeParameters + nodeOption);
        }
    }

    @NotNull
    private static String guessCoffeeScriptPackage(@NotNull Project project) {
        VirtualFile root;
        VirtualFile packageJson;
        if (project == null) {
            NodeJsRunConfiguration.$$$reportNull$$$0(14);
        }
        if ((packageJson = PackageJsonUtil.findChildPackageJsonFile((VirtualFile)(root = project.isDefault() ? null : ProjectUtil.guessProjectDir((Project)project)))) != null) {
            String oldPackageName = "coffee-script";
            if (PackageJsonData.getOrCreate((VirtualFile)packageJson).isDependencyOfAnyType(oldPackageName)) {
                String string = oldPackageName;
                if (string == null) {
                    NodeJsRunConfiguration.$$$reportNull$$$0(15);
                }
                return string;
            }
        }
        return "coffeescript";
    }

    public void readConfiguration(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            NodeJsRunConfiguration.$$$reportNull$$$0(16);
        }
        this.myEnvData = EnvironmentVariablesData.readExternal((Element)element);
    }

    public void writeConfiguration(@NotNull Element element) {
        if (element == null) {
            NodeJsRunConfiguration.$$$reportNull$$$0(17);
        }
        this.myEnvData.writeExternalNoDefault(element);
    }

    @Nullable
    public RefactoringElementListener getRefactoringElementListener(PsiElement element) {
        return NodeJsRunConfigurationRefactoringHandler.createRefactoringElementListener(this, element);
    }

    @Nullable
    public String getNodeOptions() {
        String nodeOptions = this.getOptions().getNodeParameters();
        if (this.getOptions().getTypeScriptLoader() != NodeJsRunTypeScriptLoader.BUNDLED) {
            return nodeOptions;
        }
        String loaderOptions = TypeScriptFileLoader.getLoaderOptions(this.getInterpreter());
        return Stream.of(loaderOptions, nodeOptions).filter(Objects::nonNull).collect(Collectors.joining(" "));
    }

    public void setNodeOptions(@Nullable String nodeOptions) {
        this.getOptions().setNodeParameters(nodeOptions);
    }

    @Nullable
    public String getApplicationParameters() {
        return this.getOptions().getApplicationParameters();
    }

    public void setApplicationParameters(@Nullable String applicationParameters) {
        this.getOptions().setApplicationParameters(applicationParameters);
    }

    @NotNull
    public Map<String, String> getEnvs() {
        Map map = this.myEnvData.getEnvs();
        if (map == null) {
            NodeJsRunConfiguration.$$$reportNull$$$0(18);
        }
        return map;
    }

    public void setEnvs(@NotNull Map<String, String> envs) {
        if (envs == null) {
            NodeJsRunConfiguration.$$$reportNull$$$0(19);
        }
        this.myEnvData = EnvironmentVariablesData.create(envs, (boolean)this.myEnvData.isPassParentEnvs());
    }

    @NotNull
    public EnvironmentVariablesData getEnvData() {
        EnvironmentVariablesData environmentVariablesData = this.myEnvData;
        if (environmentVariablesData == null) {
            NodeJsRunConfiguration.$$$reportNull$$$0(20);
        }
        return environmentVariablesData;
    }

    public void setEnvData(@NotNull EnvironmentVariablesData envData) {
        if (envData == null) {
            NodeJsRunConfiguration.$$$reportNull$$$0(21);
        }
        this.myEnvData = envData;
    }

    @Nullable
    public static NodeJsRunConfiguration getDefaultRunConfiguration(@NotNull Project project) {
        if (project == null) {
            NodeJsRunConfiguration.$$$reportNull$$$0(22);
        }
        RunManager runManager = RunManager.getInstance((Project)project);
        RunnerAndConfigurationSettings settings = runManager.getConfigurationTemplate((ConfigurationFactory)NodeJsRunConfigurationType.getInstance());
        return (NodeJsRunConfiguration)((Object)ObjectUtils.tryCast((Object)settings.getConfiguration(), NodeJsRunConfiguration.class));
    }

    @Nullable
    public String getWorkingDirectory() {
        return NodeJsRunConfiguration.toSystemDependentNameAndTrim(this.getOptions().getWorkingDir());
    }

    public void setWorkingDirectory(@Nullable String value) {
        this.getOptions().setWorkingDir(FileUtil.toSystemIndependentName((String)StringUtil.notNullize((String)value)));
    }

    @Nullable
    public String getMainScriptFilePath() {
        return NodeJsRunConfiguration.toSystemDependentNameAndTrim(this.getOptions().getPathToFile());
    }

    public void setMainScriptFilePath(@Nullable String value) {
        this.getOptions().setPathToFile(PathUtil.toSystemIndependentName((String)StringUtil.nullize((String)value)));
    }

    @Nullable
    private static String toSystemDependentNameAndTrim(@Nullable String path) {
        return StringUtil.nullize((String)StringUtil.notNullize((String)PathUtil.toSystemDependentName((String)path)).trim());
    }

    @Nullable
    public VirtualFile findMainScriptVirtualFile() throws CantRunException {
        Path path = this.findMainScriptPath();
        return path != null ? LocalFileSystem.getInstance().findFileByNioFile(path) : null;
    }

    @Nullable
    public Path findMainScriptPath() throws CantRunException {
        String workingDirectory;
        String mainScriptFilePath = this.getMainScriptFilePath();
        if (mainScriptFilePath == null) {
            return null;
        }
        String expandedPath = ProgramParametersUtil.expandPathAndMacros((String)mainScriptFilePath, null, (Project)this.getProject());
        String appFilePath = ScriptFileUtil.getLocalFilePath((String)expandedPath);
        Path file = Path.of(appFilePath, new String[0]);
        if (!file.isAbsolute() && (workingDirectory = this.getWorkingDirectory()) != null) {
            return Path.of(workingDirectory, appFilePath);
        }
        return file;
    }

    public int getConfiguredDebugPort() {
        return NodeCommandLineUtil.findDebugPort((String)this.getNodeOptions());
    }

    @Deprecated
    @Nullable
    public String getProgramParameters() {
        return this.getNodeOptions();
    }

    @Deprecated
    public void setProgramParameters(@Nullable String value) {
        this.setNodeOptions(value);
    }

    @Deprecated
    @Nullable
    public String getInputPath() {
        return this.getMainScriptFilePath();
    }

    @Deprecated
    public void setInputPath(@Nullable String value) {
        this.setMainScriptFilePath(value);
    }

    @NotNull
    public List<EventPair<?>> getAdditionalUsageData() {
        List<EventPair<?>> list = NodeJsRunConfigurationFus.getAdditionalUsageData(this);
        if (list == null) {
            NodeJsRunConfiguration.$$$reportNull$$$0(23);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3, 5, 6, 7, 8, 9, 12, 14, 16, 17, 19, 21, 22 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/run/NodeJsRunConfiguration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeProfilingSettings";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDir";
                break;
            }
            case 14: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envs";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptions";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/run/NodeJsRunConfiguration";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getStartBrowserSettings";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeProfilingSettings";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterpreterRef";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeScriptLoader";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestName";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "guessCoffeeScriptPackage";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvs";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvData";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalUsageData";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setNodeInterpreter";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setStartBrowserSettings";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setNodeProfilingSettings";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "validateTypeScriptLoader";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "validatePath";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setTypeScriptLoader";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "guessCoffeeScriptPackage";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "readConfiguration";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "writeConfiguration";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setEnvs";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "setEnvData";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultRunConfiguration";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3, 5, 6, 7, 8, 9, 12, 14, 16, 17, 19, 21, 22 -> new IllegalArgumentException(string);
        };
    }
}

