/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.v8log.reading;

import com.jetbrains.nodejs.run.profile.cpu.v8log.reading.StackLineData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class FlameData {
    private final int myFirstTickOffset;
    private final List<Long> myTimes;
    private final List<TreeMap<Long, StackLineData>> myStackLineData;
    private int myTickIdx;
    private List<Long> myPrevStack;

    public FlameData(int firstTickOffset, List<Long> times) {
        this.myFirstTickOffset = firstTickOffset;
        this.myTimes = times;
        this.myStackLineData = new ArrayList<TreeMap<Long, StackLineData>>();
        this.myTickIdx = 0;
    }

    public void tick(List<Long> stack) {
        int lastCommonId;
        Long ts = this.myTimes.get(this.myTickIdx);
        Collections.reverse(stack);
        int n = lastCommonId = this.myPrevStack == null ? -1 : FlameData.getLastCommonId(this.myPrevStack, stack);
        if (this.myPrevStack != null) {
            this.finishStack(ts, lastCommonId);
        }
        for (int i = lastCommonId + 1; i < stack.size(); ++i) {
            TreeMap<Object, Object> map;
            if (this.myStackLineData.size() <= i) {
                map = new TreeMap();
                this.myStackLineData.add(map);
            } else {
                map = this.myStackLineData.get(i);
            }
            map.put(ts, new StackLineData(0L, stack.get(i)));
        }
        this.myPrevStack = stack;
        ++this.myTickIdx;
    }

    public List<TreeMap<Long, StackLineData>> getStackLineData() {
        return this.myStackLineData;
    }

    public List<Long> getTimes() {
        return this.myTimes;
    }

    public int getFirstTickOffset() {
        return this.myFirstTickOffset;
    }

    private void finishStack(Long ts, int lastCommonId) {
        for (int i = lastCommonId + 1; i < this.myPrevStack.size(); ++i) {
            Map.Entry<Long, StackLineData> entry = this.myStackLineData.get(i).lastEntry();
            StackLineData lineData = entry.getValue();
            lineData.setDuration(ts - entry.getKey());
        }
    }

    public void finish() {
        if (this.myTimes.isEmpty()) {
            return;
        }
        long lastTs = this.myTimes.get(this.myTimes.size() - 1) + 2000L;
        for (int i = 0; i < this.myPrevStack.size(); ++i) {
            Map.Entry<Long, StackLineData> entry;
            StackLineData lineData;
            Long id = this.myPrevStack.get(i);
            if (!id.equals((lineData = (entry = this.myStackLineData.get(i).lastEntry()).getValue()).getStringId())) continue;
            lineData.setDuration(lastTs - entry.getKey());
        }
    }

    private static int getLastCommonId(List<Long> one, List<Long> two) {
        int idx;
        for (idx = 0; idx < one.size() && idx < two.size(); ++idx) {
            if (one.get(idx).equals(two.get(idx))) continue;
            return idx - 1;
        }
        return idx - 1;
    }

    static List<Long> filterUnknown(List<Long> stack) {
        Iterator<Long> iterator = stack.iterator();
        while (iterator.hasNext()) {
            Long code = iterator.next();
            if (code != 1L) continue;
            iterator.remove();
        }
        return stack;
    }
}

