/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.view.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.jetbrains.nodejs.NodeJSBundle;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapEdge;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapEntry;
import com.jetbrains.nodejs.run.profile.heap.view.components.ChainTreeTableModel;
import com.jetbrains.nodejs.run.profile.heap.view.components.V8MainTreeNavigator;
import com.jetbrains.nodejs.run.profile.heap.view.models.V8HeapContainmentTreeTableModel;
import icons.NodeJSIcons;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public class V8NavigateToMainTreeAction
extends DumbAwareAction {
    public static final DataKey<V8MainTreeNavigator> MAIN_TREE_NAVIGATOR = DataKey.create((String)"V8_MAIN_TREE_NAVIGATOR");
    public static final DataKey<TreePath> TREE_PATH = DataKey.create((String)"V8_TREE_PATH");
    public static final DataKey<Pair<V8HeapEntry, V8HeapEdge>> TREE_NODE = DataKey.create((String)"V8_TREE_NODE");
    private V8MainTreeNavigator myFixedNavigator;
    private TreeTable myTable;

    public V8NavigateToMainTreeAction() {
        super(NodeJSBundle.messagePointer("action.V8NavigateToMainTreeAction.navigate.in.main.tree.text", new Object[0]), NodeJSIcons.Navigate_inMainTree);
    }

    public void setFixedNavigator(V8MainTreeNavigator fixedNavigator) {
        this.myFixedNavigator = fixedNavigator;
    }

    public void setTable(TreeTable table) {
        this.myTable = table;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            V8NavigateToMainTreeAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            V8NavigateToMainTreeAction.$$$reportNull$$$0(1);
        }
        boolean enabled = new DataGetter(e).enabled();
        e.getPresentation().setEnabled(enabled);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DataGetter getter;
        if (e == null) {
            V8NavigateToMainTreeAction.$$$reportNull$$$0(2);
        }
        if (!(getter = new DataGetter(e)).enabled()) {
            return;
        }
        if (getter.getTreePath() != null) {
            getter.getNavigator().navigateTo(getter.getTreePath());
        } else {
            Pair<V8HeapEntry, V8HeapEdge> node = getter.getNode();
            getter.getNavigator().navigateTo((V8HeapEntry)node.getFirst(), (V8HeapEdge)node.getSecond());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/run/profile/heap/view/actions/V8NavigateToMainTreeAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/run/profile/heap/view/actions/V8NavigateToMainTreeAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }

    private class DataGetter {
        private V8MainTreeNavigator myNavigator;
        private final TreePath myTreePath;
        private Pair<V8HeapEntry, V8HeapEdge> myNode;

        DataGetter(AnActionEvent e) {
            TreePath path;
            DataContext dc = e.getDataContext();
            this.myNavigator = (V8MainTreeNavigator)MAIN_TREE_NAVIGATOR.getData(dc);
            this.myTreePath = (TreePath)TREE_PATH.getData(dc);
            this.myNode = (Pair)TREE_NODE.getData(dc);
            if (V8NavigateToMainTreeAction.this.myFixedNavigator != null) {
                this.myNavigator = V8NavigateToMainTreeAction.this.myFixedNavigator;
            }
            if (V8NavigateToMainTreeAction.this.myTable != null && (path = V8NavigateToMainTreeAction.this.myTable.getTree().getSelectionPath()) != null) {
                Object t;
                if (path.getLastPathComponent() instanceof V8HeapContainmentTreeTableModel.NamedEntry) {
                    this.myNode = Pair.create((Object)((V8HeapContainmentTreeTableModel.NamedEntry)path.getLastPathComponent()).getEntry(), null);
                } else if (path.getLastPathComponent() instanceof ChainTreeTableModel.Node && (t = ((ChainTreeTableModel.Node)path.getLastPathComponent()).getT()) instanceof V8HeapContainmentTreeTableModel.NamedEntry) {
                    V8HeapContainmentTreeTableModel.NamedEntry namedEntry = (V8HeapContainmentTreeTableModel.NamedEntry)t;
                    this.myNode = Pair.create((Object)namedEntry.getEntry(), null);
                }
            }
        }

        public boolean enabled() {
            return this.myNavigator != null && (this.myTreePath != null || this.myNode != null);
        }

        public V8MainTreeNavigator getNavigator() {
            return this.myNavigator;
        }

        public TreePath getTreePath() {
            return this.myTreePath;
        }

        public Pair<V8HeapEntry, V8HeapEdge> getNode() {
            return this.myNode;
        }
    }
}

