/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.data;

import com.intellij.ide.startup.importSettings.data.ThemeService;
import com.intellij.ide.startup.importSettings.data.WizardScheme;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.laf.UIThemeLookAndFeelInfo;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Color;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u0005H\u0016R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001f\u0010\n\u001a\u0013\u0012\t\u0012\u00070\u0005\u00a2\u0006\u0002\b\u0006\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0016\u0010\u0018\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006!"}, d2={"Lcom/intellij/ide/startup/importSettings/data/ThemeServiceImpl;", "Lcom/intellij/ide/startup/importSettings/data/ThemeService;", "<init>", "()V", "vs", "", "Lcom/intellij/openapi/util/NlsSafe;", "vsa", "rider", "IDEA", "map", "", "Lcom/intellij/ide/startup/importSettings/data/WizardScheme;", "value", "Lcom/intellij/ide/startup/importSettings/data/ThemeService$Theme;", "currentTheme", "getCurrentTheme", "()Lcom/intellij/ide/startup/importSettings/data/ThemeService$Theme;", "setCurrentTheme", "(Lcom/intellij/ide/startup/importSettings/data/ThemeService$Theme;)V", "schemesList", "", "getSchemesList", "()Ljava/util/List;", "initialSchemeId", "getInitialSchemeId", "()Ljava/lang/String;", "onStepEnter", "", "isForwardDirection", "", "updateScheme", "schemeId", "intellij.ide.startup.importSettings"})
public final class ThemeServiceImpl
implements ThemeService {
    @NotNull
    private String vs = "Visual Studio";
    @NotNull
    private String vsa = "Visual Assist";
    @NotNull
    private String rider = "Rider";
    @NotNull
    private String IDEA = "IDEA";
    @NotNull
    private final Map<String, WizardScheme> map;
    @NotNull
    private final List<WizardScheme> schemesList;
    @Nullable
    private final String initialSchemeId;

    public ThemeServiceImpl() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)this.vs, (Object)new WizardScheme(this.vs, this.vs, IconLoader.getIcon((String)"wizardPreviews_stub/vs.png", this.getClass()), (Color)new JBColor(0xFFFFFF, 0x1E1E1E))), TuplesKt.to((Object)this.rider, (Object)new WizardScheme(this.rider, this.rider, IconLoader.getIcon((String)"wizardPreviews_stub/rider.png", this.getClass()), (Color)new JBColor(0xFFFFFF, 0x262626))), TuplesKt.to((Object)this.vsa, (Object)new WizardScheme(this.vsa, this.vsa, IconLoader.getIcon((String)"wizardPreviews_stub/vs.png", this.getClass()), (Color)new JBColor(0xFFFFFF, 0x1E1E1E))), TuplesKt.to((Object)this.IDEA, (Object)new WizardScheme(this.IDEA, this.IDEA, IconLoader.getIcon((String)"wizardPreviews_stub/ij.png", this.getClass()), (Color)new JBColor(0xFFFFFF, 0x2B2B2B)))};
        this.map = MapsKt.mapOf((Pair[])pairArray);
        this.schemesList = CollectionsKt.toList((Iterable)this.map.values());
    }

    @Override
    @NotNull
    public ThemeService.Theme getCurrentTheme() {
        return StartupUiUtil.INSTANCE.isDarkTheme() ? ThemeService.Theme.Dark : ThemeService.Theme.Light;
    }

    @Override
    public void setCurrentTheme(@NotNull ThemeService.Theme value) {
        block0: {
            LafManager lafManager;
            UIThemeLookAndFeelInfo laf;
            Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
            LafManager lm = LafManager.getInstance();
            UIThemeLookAndFeelInfo uIThemeLookAndFeelInfo = laf = value.isDark() ? lm.getDefaultDarkLaf() : LafManager.getInstance().getDefaultLightLaf();
            if (uIThemeLookAndFeelInfo == null) break block0;
            UIThemeLookAndFeelInfo it = uIThemeLookAndFeelInfo;
            boolean bl = false;
            LafManager $this$_set_currentTheme__u24lambda_u241_u24lambda_u240 = lafManager = lm;
            boolean bl2 = false;
            $this$_set_currentTheme__u24lambda_u241_u24lambda_u240.setCurrentUIThemeLookAndFeel(it);
            $this$_set_currentTheme__u24lambda_u241_u24lambda_u240.updateUI();
            $this$_set_currentTheme__u24lambda_u241_u24lambda_u240.repaintUI();
        }
    }

    @Override
    @NotNull
    public List<WizardScheme> getSchemesList() {
        return this.schemesList;
    }

    @Override
    @Nullable
    public String getInitialSchemeId() {
        return this.initialSchemeId;
    }

    @Override
    public void onStepEnter(boolean isForwardDirection) {
    }

    @Override
    public void updateScheme(@NotNull String schemeId) {
        Intrinsics.checkNotNullParameter((Object)schemeId, (String)"schemeId");
    }
}

