/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.core.actions;

import com.intellij.diagram.DiagramAction;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramBuilderFactory;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.state.DiagramFullSnapshot;
import com.intellij.diagram.util.DiagramUpdateService;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.graph.util.Futures;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiFile;
import com.intellij.uml.undo.UmlUndoableAction;
import com.intellij.uml.utils.DiagramBundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class UmlShowDependencies
extends DiagramAction {
    @NotNull
    private static final Key<Boolean> SHOW_DEPENDENCIES_ACTION_IN_PROGRESS_KEY = Key.create((String)"com.intellij.uml.core.actions.UmlShowDependencies.SHOW_DEPENDENCIES_ACTION_IN_PROGRESS_KEY");

    public UmlShowDependencies() {
        super(UmlShowDependencies.getName(), UmlShowDependencies.getName(), AllIcons.Nodes.Related);
    }

    @Override
    public boolean isUndoable(@NotNull AnActionEvent e) {
        if (e == null) {
            UmlShowDependencies.$$$reportNull$$$0(0);
        }
        return false;
    }

    @Override
    public boolean isSelected(@NotNull AnActionEvent e, @NotNull DiagramBuilder b) {
        if (e == null) {
            UmlShowDependencies.$$$reportNull$$$0(1);
        }
        if (b == null) {
            UmlShowDependencies.$$$reportNull$$$0(2);
        }
        return b.getDataModel().isShowDependencies();
    }

    public static boolean isShowDependenciesActionInProgress(@NotNull DiagramBuilder builder) {
        if (builder == null) {
            UmlShowDependencies.$$$reportNull$$$0(3);
        }
        return DiagramBuilderFactory.getInstance().getModelBuilder(builder).getUserData(SHOW_DEPENDENCIES_ACTION_IN_PROGRESS_KEY) == Boolean.TRUE;
    }

    private static void setShowDependenciesActionInProgress(@NotNull DiagramBuilder builder, boolean isEnabled) {
        if (builder == null) {
            UmlShowDependencies.$$$reportNull$$$0(4);
        }
        DiagramBuilderFactory.getInstance().getModelBuilder(builder).putUserData(SHOW_DEPENDENCIES_ACTION_IN_PROGRESS_KEY, isEnabled);
    }

    @Override
    public void perform(@NotNull AnActionEvent e) {
        DiagramBuilder builder;
        if (e == null) {
            UmlShowDependencies.$$$reportNull$$$0(5);
        }
        if ((builder = UmlShowDependencies.getBuilder(e)) == null) {
            return;
        }
        WriteCommandAction.writeCommandAction((Project)builder.getProject()).withName(this.getActionName()).withGroupId(this.getActionGroupId(e)).run(() -> {
            PsiFile[] files = this.getAffectedFiles(e);
            final DiagramFullSnapshot oldSnapshot = DiagramFullSnapshot.Factory.getInstance().makeSnapshot(builder);
            UmlShowDependencies.doShowDependencies(builder);
            UndoManager.getInstance((Project)builder.getProject()).undoableActionPerformed((UndoableAction)new BasicUndoableAction(UmlUndoableAction.getAffectedDocuments(builder, files)){

                public void undo() {
                    oldSnapshot.restoreAsync(builder);
                }

                public void redo() {
                    UmlShowDependencies.doShowDependencies(builder);
                }
            });
        });
    }

    private static void doShowDependencies(@NotNull DiagramBuilder builder) {
        if (builder == null) {
            UmlShowDependencies.$$$reportNull$$$0(6);
        }
        UmlShowDependencies.setShowDependenciesActionInProgress(builder, true);
        DiagramDataModel<?> dataModel = builder.getDataModel();
        dataModel.setShowDependencies(!dataModel.isShowDependencies());
        DiagramUpdateService.getInstance().requestDataModelRefreshPreservingLayout(builder).runAsync().thenRunAsync(() -> UmlShowDependencies.setShowDependenciesActionInProgress(builder, false), Futures.inEdt());
    }

    @Override
    @NotNull
    public String getActionName() {
        return UmlShowDependencies.getName();
    }

    @NotNull
    @Nls
    private static String getName() {
        String string = DiagramBundle.message("action.name.show.dependencies", new Object[0]);
        if (string == null) {
            UmlShowDependencies.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/core/actions/UmlShowDependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/core/actions/UmlShowDependencies";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isUndoable";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isSelected";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isShowDependenciesActionInProgress";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setShowDependenciesActionInProgress";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doShowDependencies";
                break;
            }
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7 -> new IllegalStateException(string);
        };
    }
}

