/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.dvcs.actions.DvcsCompareWithAction;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.VcsDiffUtil;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitContentRevision;
import git4idea.GitReference;
import git4idea.GitRevisionNumber;
import git4idea.GitTag;
import git4idea.GitUtil;
import git4idea.changes.GitChangeUtils;
import git4idea.history.GitHistoryUtils;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.ui.branch.compareWith.GitCompareWithBranchPopup;
import git4idea.ui.branch.compareWith.GitCompareWithBranchPopupStep;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class GitCompareWithRefAction
extends DvcsCompareWithAction<GitRepository> {
    @NotNull
    protected JBPopup createPopup(@NotNull Project project, @NotNull GitRepository repository, @NotNull VirtualFile file) {
        if (project == null) {
            GitCompareWithRefAction.$$$reportNull$$$0(0);
        }
        if (repository == null) {
            GitCompareWithRefAction.$$$reportNull$$$0(1);
        }
        if (file == null) {
            GitCompareWithRefAction.$$$reportNull$$$0(2);
        }
        Consumer<GitReference> selectionHandler = selected -> GitCompareWithRefAction.showDiff(repository, file, selected);
        return new GitCompareWithBranchPopup(project, new GitCompareWithBranchPopupStep(project, repository, selectionHandler));
    }

    protected boolean nothingToCompare(@NotNull GitRepository repository) {
        boolean haveRemotes;
        if (repository == null) {
            GitCompareWithRefAction.$$$reportNull$$$0(3);
        }
        int locals = repository.getBranches().getLocalBranches().size();
        boolean bl = haveRemotes = !repository.getBranches().getRemoteBranches().isEmpty();
        if (repository.isOnBranch()) {
            return locals < 2 && !haveRemotes;
        }
        return locals == 0 && !haveRemotes;
    }

    @NotNull
    protected GitRepositoryManager getRepositoryManager(@NotNull Project project) {
        if (project == null) {
            GitCompareWithRefAction.$$$reportNull$$$0(4);
        }
        GitRepositoryManager gitRepositoryManager = GitUtil.getRepositoryManager(project);
        if (gitRepositoryManager == null) {
            GitCompareWithRefAction.$$$reportNull$$$0(5);
        }
        return gitRepositoryManager;
    }

    @NotNull
    public static Collection<Change> getDiffChanges(@NotNull GitRepository repository, @NotNull VirtualFile file, @NotNull GitReference refToCompare) throws VcsException {
        if (repository == null) {
            GitCompareWithRefAction.$$$reportNull$$$0(6);
        }
        if (file == null) {
            GitCompareWithRefAction.$$$reportNull$$$0(7);
        }
        if (refToCompare == null) {
            GitCompareWithRefAction.$$$reportNull$$$0(8);
        }
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)file);
        GitRevisionNumber revisionNumber = new GitRevisionNumber(refToCompare.getFullName());
        Project project = repository.getProject();
        List changes = GitChangeUtils.getDiffWithWorkingDir(project, repository.getRoot(), refToCompare.getFullName(), Collections.singletonList(filePath), false);
        if (changes.isEmpty() && GitHistoryUtils.getCurrentRevision(project, filePath, refToCompare.getFullName()) == null) {
            throw new VcsException(GitCompareWithRefAction.getErrorMessage(file, refToCompare));
        }
        ContentRevision contentRevision = GitContentRevision.createRevision(filePath, (VcsRevisionNumber)revisionNumber, project);
        List list = changes.isEmpty() && !filePath.isDirectory() ? VcsDiffUtil.createChangesWithCurrentContentForFile((FilePath)filePath, (ContentRevision)contentRevision) : changes;
        if (list == null) {
            GitCompareWithRefAction.$$$reportNull$$$0(9);
        }
        return list;
    }

    private static void showDiff(@NotNull GitRepository repository, @NotNull VirtualFile file, @NotNull GitReference reference) {
        if (repository == null) {
            GitCompareWithRefAction.$$$reportNull$$$0(10);
        }
        if (file == null) {
            GitCompareWithRefAction.$$$reportNull$$$0(11);
        }
        if (reference == null) {
            GitCompareWithRefAction.$$$reportNull$$$0(12);
        }
        String presentableRevisionName = GitCompareWithRefAction.getPresentableCurrentBranchName((Repository)repository);
        String revNumTitle1 = VcsDiffUtil.getRevisionTitle((String)reference.getName(), (boolean)false);
        String revNumTitle2 = VcsDiffUtil.getRevisionTitle((String)presentableRevisionName, (boolean)true);
        GitCompareWithRefAction.showDiffBetweenRevision((Project)repository.getProject(), (VirtualFile)file, (String)revNumTitle1, (String)revNumTitle2, () -> GitCompareWithRefAction.getDiffChanges(repository, file, reference));
    }

    @NotNull
    @Nls
    private static String getErrorMessage(@NotNull VirtualFile file, @NotNull GitReference refToCompare) {
        if (file == null) {
            GitCompareWithRefAction.$$$reportNull$$$0(13);
        }
        if (refToCompare == null) {
            GitCompareWithRefAction.$$$reportNull$$$0(14);
        }
        int choice = file.isDirectory() ? 2 : 1;
        String string = refToCompare instanceof GitTag ? GitBundle.message("git.compare.with.tag.file.not.found.in.tag", choice, file.getPresentableUrl(), refToCompare.getName()) : DvcsBundle.message((String)"error.text.file.not.found.in.branch", (Object[])new Object[]{choice, file.getPresentableUrl(), refToCompare.getName()});
        if (string == null) {
            GitCompareWithRefAction.$$$reportNull$$$0(15);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 9, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 2: 
            case 7: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/actions/GitCompareWithRefAction";
                break;
            }
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refToCompare";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/actions/GitCompareWithRefAction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositoryManager";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiffChanges";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createPopup";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "nothingToCompare";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getRepositoryManager";
                break;
            }
            case 5: 
            case 9: 
            case 15: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getDiffChanges";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "showDiff";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getErrorMessage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 9, 15 -> new IllegalStateException(string);
        };
    }
}

