/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.temporal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.temporal.JSTemporalBuiltinOperation;
import com.oracle.truffle.js.builtins.temporal.TemporalTimeZonePrototypeBuiltinsFactory;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.nodes.temporal.CreateTimeZoneMethodsRecordNode;
import com.oracle.truffle.js.nodes.temporal.TemporalGetOptionNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalCalendarWithISODefaultNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalDateTimeNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalInstantNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalInstant;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalInstantObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateTimeObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalTimeZone;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalTimeZoneObject;
import com.oracle.truffle.js.runtime.builtins.temporal.TimeZoneMethodsRecord;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.TemporalErrors;
import com.oracle.truffle.js.runtime.util.TemporalUtil;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.OptionalLong;

public class TemporalTimeZonePrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<TemporalTimeZonePrototype> {
    public static final JSBuiltinsContainer BUILTINS = new TemporalTimeZonePrototypeBuiltins();

    protected TemporalTimeZonePrototypeBuiltins() {
        super(JSTemporalTimeZone.PROTOTYPE_NAME, TemporalTimeZonePrototype.class);
    }

    @Override
    protected Object createNode(JSContext context2, JSBuiltin builtin, boolean construct, boolean newTarget, TemporalTimeZonePrototype builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: 
            case 8: 
            case 9: {
                return TemporalTimeZonePrototypeBuiltinsFactory.JSTemporalTimeZoneGetterNodeGen.create(context2, builtin, builtinEnum, TemporalTimeZonePrototypeBuiltins.args().withThis().createArgumentNodes(context2));
            }
            case 1: {
                return TemporalTimeZonePrototypeBuiltinsFactory.JSTemporalTimeZoneGetOffsetNanosecondsForNodeGen.create(context2, builtin, TemporalTimeZonePrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context2));
            }
            case 2: {
                return TemporalTimeZonePrototypeBuiltinsFactory.JSTemporalTimeZoneGetOffsetStringForNodeGen.create(context2, builtin, TemporalTimeZonePrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context2));
            }
            case 3: {
                return TemporalTimeZonePrototypeBuiltinsFactory.JSTemporalTimeZoneGetPlainDateTimeForNodeGen.create(context2, builtin, TemporalTimeZonePrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context2));
            }
            case 4: {
                return TemporalTimeZonePrototypeBuiltinsFactory.JSTemporalTimeZoneGetInstantForNodeGen.create(context2, builtin, TemporalTimeZonePrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context2));
            }
            case 5: {
                return TemporalTimeZonePrototypeBuiltinsFactory.JSTemporalTimeZoneGetPossibleInstantsForNodeGen.create(context2, builtin, TemporalTimeZonePrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context2));
            }
            case 6: {
                return TemporalTimeZonePrototypeBuiltinsFactory.JSTemporalTimeZoneGetNextOrPreviousTransitionNodeGen.create(context2, builtin, true, TemporalTimeZonePrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context2));
            }
            case 7: {
                return TemporalTimeZonePrototypeBuiltinsFactory.JSTemporalTimeZoneGetNextOrPreviousTransitionNodeGen.create(context2, builtin, false, TemporalTimeZonePrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context2));
            }
            case 10: {
                return TemporalTimeZonePrototypeBuiltinsFactory.JSTemporalTimeZoneValueOfNodeGen.create(context2, builtin, TemporalTimeZonePrototypeBuiltins.args().withThis().createArgumentNodes(context2));
            }
        }
        return null;
    }

    public static enum TemporalTimeZonePrototype implements BuiltinEnum<TemporalTimeZonePrototype>
    {
        id(0),
        getOffsetNanosecondsFor(1),
        getOffsetStringFor(1),
        getPlainDateTimeFor(1),
        getInstantFor(1),
        getPossibleInstantsFor(1),
        getNextTransition(1),
        getPreviousTransition(1),
        toString(0),
        toJSON(0),
        valueOf(0);

        private final int length;

        private TemporalTimeZonePrototype(int length2) {
            this.length = length2;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public boolean isGetter() {
            return EnumSet.of(id).contains(this);
        }
    }

    public static abstract class JSTemporalTimeZoneGetterNode
    extends JSBuiltinNode {
        protected final TemporalTimeZonePrototype property;

        protected JSTemporalTimeZoneGetterNode(JSContext context2, JSBuiltin builtin, TemporalTimeZonePrototype property) {
            super(context2, builtin);
            this.property = property;
        }

        @Specialization
        protected TruffleString id(JSTemporalTimeZoneObject timeZone, @Cached JSToStringNode toStringNode) {
            switch (this.property.ordinal()) {
                case 0: 
                case 8: {
                    return timeZone.getIdentifier();
                }
                case 9: {
                    return toStringNode.executeString(timeZone);
                }
            }
            throw CompilerDirectives.shouldNotReachHere();
        }

        @Specialization(guards={"!isJSTemporalTimeZone(thisObj)"})
        protected static Object invalidReceiver(Object thisObj) {
            throw TemporalErrors.createTypeErrorTemporalTimeZoneExpected();
        }
    }

    public static abstract class JSTemporalTimeZoneGetOffsetNanosecondsFor
    extends JSTemporalBuiltinOperation {
        protected JSTemporalTimeZoneGetOffsetNanosecondsFor(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
        }

        @Specialization
        protected double getOffsetNanosecondsFor(JSTemporalTimeZoneObject timeZone, Object instantParam, @Cached ToTemporalInstantNode toTemporalInstantNode) {
            JSTemporalInstantObject instant = toTemporalInstantNode.execute(instantParam);
            if (timeZone.getNanoseconds() != null) {
                return timeZone.getNanoseconds().doubleValue();
            }
            return TemporalUtil.getIANATimeZoneOffsetNanoseconds(instant.getNanoseconds(), timeZone.getIdentifier());
        }

        @Specialization(guards={"!isJSTemporalTimeZone(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object instantParam) {
            throw TemporalErrors.createTypeErrorTemporalTimeZoneExpected();
        }
    }

    public static abstract class JSTemporalTimeZoneGetOffsetStringFor
    extends JSTemporalBuiltinOperation {
        protected JSTemporalTimeZoneGetOffsetStringFor(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
        }

        @Specialization
        protected TruffleString getOffsetStringFor(JSTemporalTimeZoneObject timeZone, Object instantParam, @Cached ToTemporalInstantNode toTemporalInstantNode, @Cached CreateTimeZoneMethodsRecordNode createTimeZoneMethodsRecord) {
            JSTemporalInstantObject instant = toTemporalInstantNode.execute(instantParam);
            TimeZoneMethodsRecord timeZoneRec = createTimeZoneMethodsRecord.executeOnlyGetOffsetNanosecondsFor(timeZone);
            return TemporalUtil.builtinTimeZoneGetOffsetStringFor(timeZoneRec, instant);
        }

        @Specialization(guards={"!isJSTemporalTimeZone(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object instantParam) {
            throw TemporalErrors.createTypeErrorTemporalTimeZoneExpected();
        }
    }

    public static abstract class JSTemporalTimeZoneGetPlainDateTimeFor
    extends JSTemporalBuiltinOperation {
        protected JSTemporalTimeZoneGetPlainDateTimeFor(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
        }

        @Specialization
        protected JSTemporalPlainDateTimeObject getPlainDateTimeFor(JSTemporalTimeZoneObject timeZone, Object instantParam, Object calendarLike, @Cached ToTemporalCalendarWithISODefaultNode toTemporalCalendarWithISODefaultNode, @Cached ToTemporalInstantNode toTemporalInstantNode, @Cached CreateTimeZoneMethodsRecordNode createTimeZoneMethodsRecord) {
            JSTemporalInstantObject instant = toTemporalInstantNode.execute(instantParam);
            JSDynamicObject calendar = toTemporalCalendarWithISODefaultNode.execute(calendarLike);
            TimeZoneMethodsRecord timeZoneRec = createTimeZoneMethodsRecord.executeOnlyGetOffsetNanosecondsFor(timeZone);
            return TemporalUtil.builtinTimeZoneGetPlainDateTimeFor(this.getContext(), this.getRealm(), timeZoneRec, instant, calendar);
        }

        @Specialization(guards={"!isJSTemporalTimeZone(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object instantParam, Object calendarLike) {
            throw TemporalErrors.createTypeErrorTemporalTimeZoneExpected();
        }
    }

    public static abstract class JSTemporalTimeZoneGetInstantFor
    extends JSTemporalBuiltinOperation {
        protected JSTemporalTimeZoneGetInstantFor(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
        }

        @Specialization
        protected JSTemporalInstantObject getInstantFor(JSTemporalTimeZoneObject timeZone, Object dateTimeParam, Object optionsParam, @Cached ToTemporalDateTimeNode toTemporalDateTime, @Cached TruffleString.EqualNode equalNode, @Cached TemporalGetOptionNode getOptionNode, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined, @Cached CreateTimeZoneMethodsRecordNode createTimeZoneMethodsRecord) {
            JSTemporalPlainDateTimeObject dateTime = toTemporalDateTime.execute(dateTimeParam, Undefined.instance);
            JSDynamicObject options = this.getOptionsObject(optionsParam, this, errorBranch, optionUndefined);
            TemporalUtil.Disambiguation disambiguation = TemporalUtil.toTemporalDisambiguation(options, getOptionNode, equalNode);
            TimeZoneMethodsRecord timeZoneRec = createTimeZoneMethodsRecord.executeFull(timeZone);
            return TemporalUtil.builtinTimeZoneGetInstantFor(this.getContext(), this.getRealm(), timeZoneRec, dateTime, disambiguation);
        }

        @Specialization(guards={"!isJSTemporalTimeZone(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object dateTimeParam, Object optionsParam) {
            throw TemporalErrors.createTypeErrorTemporalTimeZoneExpected();
        }
    }

    public static abstract class JSTemporalTimeZoneGetPossibleInstantsFor
    extends JSTemporalBuiltinOperation {
        protected JSTemporalTimeZoneGetPossibleInstantsFor(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        protected JSDynamicObject getPossibleInstantsFor(JSTemporalTimeZoneObject timeZone, Object dateTimeParam, @Cached ToTemporalDateTimeNode toTemporalDateTime) {
            JSTemporalPlainDateTimeObject dateTime = toTemporalDateTime.execute(dateTimeParam, Undefined.instance);
            JSRealm realm = this.getRealm();
            if (timeZone.getNanoseconds() != null) {
                BigInteger epochNanoseconds = TemporalUtil.getUTCEpochNanoseconds(dateTime.getYear(), dateTime.getMonth(), dateTime.getDay(), dateTime.getHour(), dateTime.getMinute(), dateTime.getSecond(), dateTime.getMillisecond(), dateTime.getMicrosecond(), dateTime.getNanosecond());
                JSTemporalInstantObject instant = JSTemporalInstant.create(this.getContext(), realm, new BigInt(epochNanoseconds.subtract(timeZone.getNanoseconds().bigIntegerValue())));
                ArrayList<JSTemporalInstantObject> list2 = new ArrayList<JSTemporalInstantObject>();
                list2.add(instant);
                return JSRuntime.createArrayFromList(this.getContext(), realm, list2);
            }
            List<BigInt> possibleEpochNanoseconds = TemporalUtil.getIANATimeZoneEpochValue(timeZone.getIdentifier(), dateTime.getYear(), dateTime.getMonth(), dateTime.getDay(), dateTime.getHour(), dateTime.getMinute(), dateTime.getSecond(), dateTime.getMillisecond(), dateTime.getMicrosecond(), dateTime.getNanosecond());
            ArrayList<JSTemporalInstantObject> possibleInstants = new ArrayList<JSTemporalInstantObject>();
            for (BigInt epochNanoseconds : possibleEpochNanoseconds) {
                JSTemporalInstantObject instant = JSTemporalInstant.create(this.getContext(), realm, epochNanoseconds);
                possibleInstants.add(instant);
            }
            return JSRuntime.createArrayFromList(this.getContext(), realm, possibleInstants);
        }

        @Specialization(guards={"!isJSTemporalTimeZone(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object dateTimeParam) {
            throw TemporalErrors.createTypeErrorTemporalTimeZoneExpected();
        }
    }

    public static abstract class JSTemporalTimeZoneGetNextOrPreviousTransition
    extends JSTemporalBuiltinOperation {
        private final boolean isNext;

        protected JSTemporalTimeZoneGetNextOrPreviousTransition(JSContext context2, JSBuiltin builtin, boolean isNext) {
            super(context2, builtin);
            this.isNext = isNext;
        }

        @Specialization
        protected Object getTransition(JSTemporalTimeZoneObject timeZone, Object startingPointParam, @Cached ToTemporalInstantNode toTemporalInstantNode) {
            JSTemporalInstantObject startingPoint = toTemporalInstantNode.execute(startingPointParam);
            if (timeZone.getNanoseconds() != null) {
                return Null.instance;
            }
            OptionalLong transition = this.isNext ? TemporalUtil.getIANATimeZoneNextTransition(startingPoint.getNanoseconds(), timeZone.getIdentifier()) : TemporalUtil.getIANATimeZonePreviousTransition(startingPoint.getNanoseconds(), timeZone.getIdentifier());
            if (transition.isEmpty()) {
                return Null.instance;
            }
            return JSTemporalInstant.create(this.getContext(), this.getRealm(), BigInt.valueOf(transition.orElse(0L)));
        }

        @Specialization(guards={"!isJSTemporalTimeZone(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object startingPointParam) {
            throw TemporalErrors.createTypeErrorTemporalTimeZoneExpected();
        }
    }

    public static abstract class JSTemporalTimeZoneValueOf
    extends JSTemporalBuiltinOperation {
        protected JSTemporalTimeZoneValueOf(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
        }

        @Specialization
        protected Object valueOf(Object thisObj) {
            throw Errors.createTypeError("Not supported.");
        }
    }
}

