/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.polyglot.impl;

import java.lang.invoke.MethodHandles;
import java.util.function.Consumer;
import java.util.function.Function;
import org.graalvm.nativeimage.LogHandler;
import org.graalvm.options.OptionCategory;
import org.graalvm.options.OptionDescriptor;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.options.OptionKey;
import org.graalvm.options.OptionStability;
import org.graalvm.options.OptionType;
import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.SandboxPolicy;
import org.graalvm.polyglot.impl.AbstractPolyglotImpl;
import org.graalvm.polyglot.impl.ModuleAccess;
import org.graalvm.polyglot.impl.ModuleToUnnamedAPIAccessGen;
import org.graalvm.polyglot.impl.ModuleToUnnamedAccessGen;
import org.graalvm.polyglot.impl.ModuleToUnnamedByteSequenceGen;
import org.graalvm.polyglot.impl.ModuleToUnnamedFileSystemGen;
import org.graalvm.polyglot.impl.ModuleToUnnamedIOAccessorGen;
import org.graalvm.polyglot.impl.ModuleToUnnamedLogHandlerGen;
import org.graalvm.polyglot.impl.ModuleToUnnamedManagementAccessGen;
import org.graalvm.polyglot.impl.ModuleToUnnamedMessageEndpointGen;
import org.graalvm.polyglot.impl.ModuleToUnnamedMessageTransportGen;
import org.graalvm.polyglot.impl.ModuleToUnnamedOptionDescriptorsGen;
import org.graalvm.polyglot.impl.ModuleToUnnamedProcessHandlerGen;
import org.graalvm.polyglot.impl.ModuleToUnnamedThreadScopeGen;
import org.graalvm.polyglot.impl.UnnamedAccess;
import org.graalvm.polyglot.io.ByteSequence;
import org.graalvm.polyglot.io.FileSystem;
import org.graalvm.polyglot.io.MessageEndpoint;
import org.graalvm.polyglot.io.MessageTransport;
import org.graalvm.polyglot.io.ProcessHandler;

public final class ModuleToUnnamedBridge {
    private static volatile boolean bridgeInitialized;
    private static volatile ModuleToUnnamedBridge instance;
    private final MethodHandles.Lookup unnamedLookup;
    private UnnamedAccess unnamed;
    private ModuleToUnnamedAPIAccessGen api;
    private ModuleToUnnamedIOAccessorGen io;
    private ModuleToUnnamedManagementAccessGen management;
    private ModuleAccessImpl moduleAccess;

    public AbstractPolyglotImpl.APIAccess getAPIAccess() {
        return this.api;
    }

    public AbstractPolyglotImpl.IOAccessor getIOAccess() {
        return this.io;
    }

    public AbstractPolyglotImpl.ManagementAccess getManagementAccess() {
        return this.management;
    }

    public Object getModuleAccess() {
        return this.moduleAccess;
    }

    ModuleToUnnamedBridge(MethodHandles.Lookup unnamedLookup) {
        this.unnamedLookup = unnamedLookup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static ModuleToUnnamedBridge create(MethodHandles.Lookup lookup, Object unnamedAccess, Object unnamedAPIAccess, Object unnamedIOAccess, Object unnamedManagementAccess) {
        assert (!lookup.lookupClass().getModule().isNamed()) : "unnamed lookup is not actually unnamed";
        ModuleToUnnamedBridge bridge = instance;
        if (bridge == null) {
            Class<ModuleToUnnamedBridge> clazz = ModuleToUnnamedBridge.class;
            // MONITORENTER : org.graalvm.polyglot.impl.ModuleToUnnamedBridge.class
            bridge = instance;
            if (bridge == null) {
                if (bridgeInitialized) {
                    throw new InternalError("Classes used for the module bridge are already initialized.");
                }
                bridge = instance = new ModuleToUnnamedBridge(lookup);
                bridge.unnamed = new ModuleToUnnamedAccessGen(unnamedAccess);
                bridge.api = new ModuleToUnnamedAPIAccessGen(unnamedAPIAccess);
                bridge.io = new ModuleToUnnamedIOAccessorGen(unnamedIOAccess);
                bridge.management = new ModuleToUnnamedManagementAccessGen(unnamedManagementAccess);
                bridge.moduleAccess = new ModuleAccessImpl();
            }
            // MONITOREXIT : clazz
        }
        if (!bridge.unnamedLookup.equals(lookup)) throw new InternalError("Polyglot bridge was already initialized with a different lookup.");
        return bridge;
    }

    private static class ModuleAccessImpl
    extends ModuleAccess {
        static final SandboxPolicy[] SANDBOX_POLICIES = SandboxPolicy.values();
        static final HostAccess.TargetMappingPrecedence[] TARGET_MAPPING_PRECEDENCE = HostAccess.TargetMappingPrecedence.values();

        private ModuleAccessImpl() {
        }

        @Override
        public Object toMessageTransport(Object value2) {
            return new ModuleToUnnamedMessageTransportGen(value2);
        }

        @Override
        public Object fromMessageTransport(Object value2) {
            return ((ModuleToUnnamedMessageTransportGen)value2).receiver;
        }

        @Override
        public Object toLogHandler(Object value2) {
            return new ModuleToUnnamedLogHandlerGen(value2);
        }

        @Override
        public Object fromMessageEndpoint(Object value2) {
            return ((ModuleToUnnamedMessageEndpointGen)value2).receiver;
        }

        @Override
        public Object toMessageEndpoint(Object value2) {
            return new ModuleToUnnamedMessageEndpointGen(value2);
        }

        @Override
        public Object fromByteSequence(Object value2) {
            if (value2 instanceof ModuleToUnnamedByteSequenceGen) {
                return ((ModuleToUnnamedByteSequenceGen)value2).receiver;
            }
            return ModuleToUnnamedAPIAccess.BRIDGE.unnamed.toByteSequence(value2);
        }

        @Override
        public int fromSandboxPolicy(Object value2) {
            return ((SandboxPolicy)((Object)value2)).ordinal();
        }

        @Override
        public Object toSandboxPolicy(int ordinal) {
            return SANDBOX_POLICIES[ordinal];
        }

        @Override
        public Object toTargetMappingPrecedence(int ordinal) {
            return TARGET_MAPPING_PRECEDENCE[ordinal];
        }

        @Override
        public Object toProcessHandler(Object value2) {
            return new ModuleToUnnamedProcessHandlerGen(value2);
        }

        @Override
        public Object fromOptionDescriptors(Object value2) {
            return ((ModuleToUnnamedOptionDescriptorsGen)value2).receiver;
        }

        @Override
        public Object toFileSystem(Object value2) {
            if (value2 instanceof FileSystem) {
                return value2;
            }
            return new ModuleToUnnamedFileSystemGen(value2);
        }

        @Override
        public Object fromLogHandler(Object value2) {
            return ((ModuleToUnnamedLogHandlerGen)value2).receiver;
        }

        @Override
        public Object fromThreadScope(Object value2) {
            return ((ModuleToUnnamedThreadScopeGen)value2).receiver;
        }

        @Override
        public Object fromFileSystem(Object value2) {
            if (value2 instanceof FileSystem) {
                return ModuleToUnnamedAPIAccess.BRIDGE.unnamed.toFileSystem(value2);
            }
            return ((ModuleToUnnamedFileSystemGen)value2).receiver;
        }

        @Override
        public Object fromProcessHandler(Object value2) {
            return ((ModuleToUnnamedProcessHandlerGen)value2).receiver;
        }

        @Override
        public Object[] fromOptionDescriptor(Object value2) {
            OptionDescriptor d = (OptionDescriptor)value2;
            OptionKey<?> key = d.getKey();
            OptionType<?> type = key.getType();
            return new Object[]{d.getName(), d.getHelp(), d.getCategory().ordinal(), d.getStability().ordinal(), d.isDeprecated(), d.getUsageSyntax(), key.getDefaultValue(), type.getName(), o -> type.convert((String)o), o -> type.validate(o)};
        }
    }

    static abstract class ModuleToUnnamedByteSequence
    implements ByteSequence {
        ModuleToUnnamedByteSequence() {
        }

        static MethodHandles.Lookup methodHandleLookup() {
            return ModuleToUnnamedAPIAccess.unnamedLookup();
        }

        static ByteSequence fromByteSequence(Object value2) {
            if (value2 == null) {
                return null;
            }
            return (ByteSequence)ModuleToUnnamedAPIAccess.BRIDGE.unnamed.fromByteSequence(value2);
        }

        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        public int hashCode() {
            return super.hashCode();
        }

        public String toString() {
            return super.toString();
        }
    }

    static abstract class ModuleToUnnamedAccess
    extends UnnamedAccess {
        ModuleToUnnamedAccess() {
        }

        static MethodHandles.Lookup methodHandleLookup() {
            return ModuleToUnnamedAPIAccess.unnamedLookup();
        }
    }

    static abstract class ModuleToUnnamedManagementAccess
    extends AbstractPolyglotImpl.ManagementAccess {
        ModuleToUnnamedManagementAccess() {
        }

        static MethodHandles.Lookup methodHandleLookup() {
            return ModuleToUnnamedAPIAccess.unnamedLookup();
        }

        static AbstractPolyglotImpl.AbstractExecutionEventDispatch fromAbstractExecutionEventDispatch(Object value2) {
            if (value2 == null) {
                return null;
            }
            return (AbstractPolyglotImpl.AbstractExecutionEventDispatch)ModuleToUnnamedAPIAccess.BRIDGE.unnamed.fromExecutionEventDispatch(value2);
        }

        static AbstractPolyglotImpl.AbstractExecutionListenerDispatch fromAbstractExecutionListenerDispatch(Object value2) {
            if (value2 == null) {
                return null;
            }
            return (AbstractPolyglotImpl.AbstractExecutionListenerDispatch)ModuleToUnnamedAPIAccess.BRIDGE.unnamed.fromExecutionListenerDispatch(value2);
        }

        static Object toAbstractExecutionEventDispatch(AbstractPolyglotImpl.AbstractExecutionEventDispatch value2) {
            if (value2 == null) {
                return null;
            }
            return ModuleToUnnamedAPIAccess.BRIDGE.unnamed.toExecutionEventDispatch(value2);
        }

        static Object toAbstractExecutionListenerDispatch(AbstractPolyglotImpl.AbstractExecutionListenerDispatch value2) {
            if (value2 == null) {
                return null;
            }
            return ModuleToUnnamedAPIAccess.BRIDGE.unnamed.toExecutionListenerDispatch(value2);
        }
    }

    static abstract class ModuleToUnnamedIOAccessor
    extends AbstractPolyglotImpl.IOAccessor {
        ModuleToUnnamedIOAccessor() {
        }

        static MethodHandles.Lookup methodHandleLookup() {
            return ModuleToUnnamedAPIAccess.unnamedLookup();
        }

        static Object toFileSystem(FileSystem value2) {
            if (value2 == null) {
                return null;
            }
            return ModuleToUnnamedAPIAccess.BRIDGE.unnamed.toFileSystem(value2);
        }

        public static FileSystem fromFileSystem(Object value2) {
            if (value2 == null) {
                return null;
            }
            return (FileSystem)ModuleToUnnamedAPIAccess.BRIDGE.unnamed.fromFileSystem(value2);
        }
    }

    static abstract class ModuleToUnnamedMessageTransport
    implements MessageTransport {
        ModuleToUnnamedMessageTransport() {
        }

        static MethodHandles.Lookup methodHandleLookup() {
            return ModuleToUnnamedAPIAccess.unnamedLookup();
        }

        static MessageEndpoint fromMessageEndpoint(Object value2) {
            if (value2 == null) {
                return null;
            }
            return (MessageEndpoint)ModuleToUnnamedAPIAccess.BRIDGE.unnamed.fromMessageEndpoint(value2);
        }

        static Object toMessageEndpoint(MessageEndpoint value2) {
            if (value2 == null) {
                return null;
            }
            return ModuleToUnnamedAPIAccess.BRIDGE.unnamed.toMessageEndpoint(value2);
        }

        public String toString() {
            return super.toString();
        }
    }

    static abstract class ModuleToUnnamedMessageEndpoint
    implements MessageEndpoint {
        ModuleToUnnamedMessageEndpoint() {
        }

        static MethodHandles.Lookup methodHandleLookup() {
            return ModuleToUnnamedAPIAccess.unnamedLookup();
        }
    }

    static abstract class ModuleToUnnamedLogHandler
    implements LogHandler {
        ModuleToUnnamedLogHandler() {
        }

        static MethodHandles.Lookup methodHandleLookup() {
            return ModuleToUnnamedAPIAccess.unnamedLookup();
        }
    }

    static abstract class ModuleToUnnamedProcessHandler
    implements ProcessHandler {
        ModuleToUnnamedProcessHandler() {
        }

        static MethodHandles.Lookup methodHandleLookup() {
            return ModuleToUnnamedAPIAccess.unnamedLookup();
        }

        static Object toProcessCommand(ProcessHandler.ProcessCommand value2) {
            if (value2 == null) {
                return null;
            }
            return ModuleToUnnamedAPIAccess.BRIDGE.unnamed.toProcessCommand(ModuleToUnnamedProcessHandler.serializeProcessCommand(value2));
        }

        private static Object[] serializeProcessCommand(Object value2) {
            ProcessHandler.ProcessCommand c = (ProcessHandler.ProcessCommand)value2;
            return new Object[]{c.getCommand(), c.getDirectory(), c.getEnvironment(), c.isRedirectErrorStream(), ModuleToUnnamedProcessHandler.serializeRedirect(c.getInputRedirect()), ModuleToUnnamedProcessHandler.serializeRedirect(c.getOutputRedirect()), ModuleToUnnamedProcessHandler.serializeRedirect(c.getErrorRedirect())};
        }

        private static Object serializeRedirect(ProcessHandler.Redirect r) {
            if (r.equals(ProcessHandler.Redirect.INHERIT)) {
                return 0;
            }
            if (r.equals(ProcessHandler.Redirect.PIPE)) {
                return 1;
            }
            return r.getOutputStream();
        }
    }

    static abstract class ModuleToUnnamedOptionDescriptors
    implements OptionDescriptors {
        ModuleToUnnamedOptionDescriptors() {
        }

        static MethodHandles.Lookup methodHandleLookup() {
            return ModuleToUnnamedAPIAccess.unnamedLookup();
        }

        static OptionDescriptor fromOptionDescriptor(Object value2) {
            if (value2 == null) {
                return null;
            }
            Object[] array = ModuleToUnnamedAPIAccess.BRIDGE.unnamed.fromOptionDescriptor(value2);
            OptionType type = new OptionType((String)array[7], (Function)array[8], (Consumer)array[9]);
            OptionKey<Object> key = new OptionKey<Object>(array[6], type);
            OptionDescriptor.Builder b = OptionDescriptor.newBuilder(key, (String)array[0]);
            b.help((String)array[1]);
            b.category(OptionCategory.values()[(Integer)array[2]]);
            b.stability(OptionStability.values()[(Integer)array[3]]);
            b.deprecated((Boolean)array[4]);
            b.usageSyntax((String)array[5]);
            return b.build();
        }
    }

    static abstract class ModuleToUnnamedFileSystem
    implements FileSystem {
        ModuleToUnnamedFileSystem() {
        }

        static MethodHandles.Lookup methodHandleLookup() {
            return ModuleToUnnamedAPIAccess.unnamedLookup();
        }

        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        public int hashCode() {
            return super.hashCode();
        }

        public String toString() {
            return super.toString();
        }
    }

    static abstract class ModuleToUnnamedThreadScope
    extends AbstractPolyglotImpl.ThreadScope {
        protected ModuleToUnnamedThreadScope(AbstractPolyglotImpl engineImpl) {
            super(engineImpl);
        }

        static MethodHandles.Lookup methodHandleLookup() {
            return ModuleToUnnamedAPIAccess.unnamedLookup();
        }
    }

    static abstract class ModuleToUnnamedAPIAccess
    extends AbstractPolyglotImpl.APIAccess {
        static final ModuleToUnnamedBridge BRIDGE = instance;
        private static final HostAccess.MutableTargetMapping[] VALUES;

        ModuleToUnnamedAPIAccess() {
        }

        static MethodHandles.Lookup unnamedLookup() {
            if (BRIDGE == null) {
                return null;
            }
            return ModuleToUnnamedAPIAccess.BRIDGE.unnamedLookup;
        }

        static MethodHandles.Lookup methodHandleLookup() {
            return ModuleToUnnamedAPIAccess.unnamedLookup();
        }

        static ByteSequence fromByteSequence(Object value2) {
            if (value2 == null) {
                return null;
            }
            return new ModuleToUnnamedByteSequenceGen(value2);
        }

        static Object toAbstractSourceDispatch(AbstractPolyglotImpl.AbstractSourceDispatch dispatch) {
            if (dispatch == null) {
                return null;
            }
            return ModuleToUnnamedAPIAccess.BRIDGE.unnamed.toSourceDispatch(dispatch);
        }

        static Object toAbstractSourceSectionDispatch(AbstractPolyglotImpl.AbstractSourceSectionDispatch dispatch) {
            if (dispatch == null) {
                return null;
            }
            return ModuleToUnnamedAPIAccess.BRIDGE.unnamed.toSourceSectionDispatch(dispatch);
        }

        static Object toAbstractStackFrameImpl(AbstractPolyglotImpl.AbstractStackFrameImpl dispatch) {
            if (dispatch == null) {
                return null;
            }
            return ModuleToUnnamedAPIAccess.BRIDGE.unnamed.toStackFrameImpl(dispatch);
        }

        static Object toAbstractInstrumentDispatch(AbstractPolyglotImpl.AbstractInstrumentDispatch dispatch) {
            if (dispatch == null) {
                return null;
            }
            return ModuleToUnnamedAPIAccess.BRIDGE.unnamed.toInstrumentDispatch(dispatch);
        }

        static Object toAbstractValueDispatch(AbstractPolyglotImpl.AbstractValueDispatch dispatch) {
            if (dispatch == null) {
                return null;
            }
            return ModuleToUnnamedAPIAccess.BRIDGE.unnamed.toValueDispatch(dispatch);
        }

        static Object toAbstractLanguageDispatch(AbstractPolyglotImpl.AbstractLanguageDispatch dispatch) {
            if (dispatch == null) {
                return null;
            }
            return ModuleToUnnamedAPIAccess.BRIDGE.unnamed.toLanguageDispatch(dispatch);
        }

        static Object toAbstractExceptionDispatch(AbstractPolyglotImpl.AbstractExceptionDispatch dispatch) {
            if (dispatch == null) {
                return null;
            }
            return ModuleToUnnamedAPIAccess.BRIDGE.unnamed.toExceptionDispatch(dispatch);
        }

        static Object toAbstractEngineDispatch(AbstractPolyglotImpl.AbstractEngineDispatch dispatch) {
            if (dispatch == null) {
                return null;
            }
            return ModuleToUnnamedAPIAccess.BRIDGE.unnamed.toEngineDispatch(dispatch);
        }

        static Object toAbstractContextDispatch(AbstractPolyglotImpl.AbstractContextDispatch value2) {
            if (value2 == null) {
                return null;
            }
            return ModuleToUnnamedAPIAccess.BRIDGE.unnamed.toContextDispatch(value2);
        }

        static AbstractPolyglotImpl.AbstractContextDispatch fromAbstractContextDispatch(Object value2) {
            if (value2 == null) {
                return null;
            }
            return (AbstractPolyglotImpl.AbstractContextDispatch)ModuleToUnnamedAPIAccess.BRIDGE.unnamed.fromContextDispatch(value2);
        }

        static AbstractPolyglotImpl.AbstractValueDispatch fromAbstractValueDispatch(Object value2) {
            if (value2 == null) {
                return null;
            }
            return (AbstractPolyglotImpl.AbstractValueDispatch)ModuleToUnnamedAPIAccess.BRIDGE.unnamed.fromValueDispatch(value2);
        }

        static AbstractPolyglotImpl.AbstractLanguageDispatch fromAbstractLanguageDispatch(Object value2) {
            if (value2 == null) {
                return null;
            }
            return (AbstractPolyglotImpl.AbstractLanguageDispatch)ModuleToUnnamedAPIAccess.BRIDGE.unnamed.fromLanguageDispatch(value2);
        }

        static AbstractPolyglotImpl.AbstractSourceSectionDispatch fromAbstractSourceSectionDispatch(Object value2) {
            if (value2 == null) {
                return null;
            }
            return (AbstractPolyglotImpl.AbstractSourceSectionDispatch)ModuleToUnnamedAPIAccess.BRIDGE.unnamed.fromSourceSectionDispatch(value2);
        }

        static AbstractPolyglotImpl.AbstractInstrumentDispatch fromAbstractInstrumentDispatch(Object value2) {
            if (value2 == null) {
                return null;
            }
            return (AbstractPolyglotImpl.AbstractInstrumentDispatch)ModuleToUnnamedAPIAccess.BRIDGE.unnamed.fromInstrumentDispatch(value2);
        }

        static AbstractPolyglotImpl.AbstractEngineDispatch fromAbstractEngineDispatch(Object value2) {
            if (value2 == null) {
                return null;
            }
            return (AbstractPolyglotImpl.AbstractEngineDispatch)ModuleToUnnamedAPIAccess.BRIDGE.unnamed.fromEngineDispatch(value2);
        }

        static AbstractPolyglotImpl.AbstractStackFrameImpl fromAbstractStackFrameImpl(Object value2) {
            if (value2 == null) {
                return null;
            }
            return (AbstractPolyglotImpl.AbstractStackFrameImpl)ModuleToUnnamedAPIAccess.BRIDGE.unnamed.fromStackFrameImpl(value2);
        }

        static AbstractPolyglotImpl.AbstractSourceDispatch fromAbstractSourceDispatch(Object value2) {
            if (value2 == null) {
                return null;
            }
            return (AbstractPolyglotImpl.AbstractSourceDispatch)ModuleToUnnamedAPIAccess.BRIDGE.unnamed.fromSourceDispatch(value2);
        }

        static HostAccess.MutableTargetMapping[] fromMutableTargetMappingArray(Object value2) {
            if (value2 == null) {
                return null;
            }
            int[] array = ModuleToUnnamedAPIAccess.BRIDGE.unnamed.fromMutableTargetMappingArray(value2);
            HostAccess.MutableTargetMapping[] target = new HostAccess.MutableTargetMapping[array.length];
            if (target.length == 0) {
                return target;
            }
            for (int i = 0; i < array.length; ++i) {
                target[i] = VALUES[array[i]];
            }
            return target;
        }

        static {
            bridgeInitialized = true;
            VALUES = HostAccess.MutableTargetMapping.values();
        }
    }
}

