/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.postcss.formatter;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.css.CSSLanguage;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.css.codeStyle.CssCodeStyleSettings;
import com.intellij.psi.css.impl.util.editor.CssFormattingModelBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import org.intellij.plugins.postcss.PostCssElementTypes;
import org.intellij.plugins.postcss.lexer.PostCssTokenTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PostCssFormattingModelBuilder
extends CssFormattingModelBuilder {
    @NotNull
    protected CssFormattingModelBuilder.CssFormattingExtension createExtension(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            PostCssFormattingModelBuilder.$$$reportNull$$$0(0);
        }
        return new PostCssFormattingExtension(settings.getCommonSettings((Language)CSSLanguage.INSTANCE), (CssCodeStyleSettings)settings.getCustomSettings(CssCodeStyleSettings.class));
    }

    private static boolean isPostCssSimpleVar(@Nullable ASTNode node) {
        if (node == null) {
            return false;
        }
        PsiElement leaf = PsiTreeUtil.getDeepestFirst((PsiElement)node.getPsi());
        return leaf.getTextLength() == node.getTextLength() && leaf.getNode().getElementType() == PostCssTokenTypes.POST_CSS_SIMPLE_VARIABLE_TOKEN;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "org/intellij/plugins/postcss/formatter/PostCssFormattingModelBuilder", "createExtension"));
    }

    private static final class PostCssFormattingExtension
    extends CssFormattingModelBuilder.CssFormattingExtension {
        private PostCssFormattingExtension(CommonCodeStyleSettings commonSettings, CssCodeStyleSettings customSettings) {
            super(commonSettings, customSettings);
        }

        public CssFormattingModelBuilder.CssRootBlock createRootBlock(ASTNode _node, CssFormattingModelBuilder.CssFormattingExtension extension) {
            return new PostCssRootBlock(_node, extension);
        }

        public CssFormattingModelBuilder.CssSelectorBlock createSelectorBlock(ASTNode node, CssFormattingModelBuilder.CssFormattingExtension extension) {
            return new PostCssSelectorBlock(node, extension);
        }

        public CssFormattingModelBuilder.CssPropertyBlock createPropertyBlock(ASTNode _node, Indent indent, CssFormattingModelBuilder.CssFormattingExtension extension, @Nullable Alignment alignment, Alignment childAlignment) {
            return new PostCssPropertyBlock(_node, indent, extension, alignment, childAlignment);
        }

        public boolean isComment(IElementType elementType) {
            return PostCssTokenTypes.POST_CSS_COMMENTS.contains(elementType);
        }

        public boolean isLineComment(IElementType elementType) {
            return elementType == PostCssTokenTypes.POST_CSS_COMMENT || super.isLineComment(elementType);
        }
    }

    private static final class PostCssPropertyBlock
    extends CssFormattingModelBuilder.CssPropertyBlock {
        private PostCssPropertyBlock(ASTNode _node, Indent indent, CssFormattingModelBuilder.CssFormattingExtension extension, Alignment alignment, @Nullable Alignment childAlignment) {
            super(_node, indent, extension, alignment, childAlignment);
        }

        @Nullable
        public Spacing getSpacing(Block child1, @NotNull Block child2) {
            if (child2 == null) {
                PostCssPropertyBlock.$$$reportNull$$$0(0);
            }
            if (child1 instanceof ASTBlock && child2 instanceof ASTBlock && (PostCssFormattingModelBuilder.isPostCssSimpleVar(((ASTBlock)child1).getNode()) || PostCssFormattingModelBuilder.isPostCssSimpleVar(((ASTBlock)child2).getNode()))) {
                return Spacing.createSpacing((int)0, (int)1, (int)0, (boolean)true, (int)this.getKeepBlankLines());
            }
            return super.getSpacing(child1, child2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child2", "org/intellij/plugins/postcss/formatter/PostCssFormattingModelBuilder$PostCssPropertyBlock", "getSpacing"));
        }
    }

    private static final class PostCssSelectorBlock
    extends CssFormattingModelBuilder.CssSelectorBlock {
        private PostCssSelectorBlock(ASTNode node, CssFormattingModelBuilder.CssFormattingExtension extension) {
            super(node, Indent.getNoneIndent(), extension);
        }

        @Nullable
        public Spacing getSpacing(Block child1, @NotNull Block child2) {
            if (child2 == null) {
                PostCssSelectorBlock.$$$reportNull$$$0(0);
            }
            if (child1 instanceof ASTBlock && child2 instanceof ASTBlock && (PostCssFormattingModelBuilder.isPostCssSimpleVar(((ASTBlock)child1).getNode()) || PostCssFormattingModelBuilder.isPostCssSimpleVar(((ASTBlock)child2).getNode()))) {
                return Spacing.createSpacing((int)0, (int)1, (int)0, (boolean)true, (int)this.getKeepBlankLines());
            }
            return super.getSpacing(child1, child2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child2", "org/intellij/plugins/postcss/formatter/PostCssFormattingModelBuilder$PostCssSelectorBlock", "getSpacing"));
        }
    }

    private static final class PostCssRootBlock
    extends CssFormattingModelBuilder.CssRootBlock {
        private PostCssRootBlock(ASTNode _node, CssFormattingModelBuilder.CssFormattingExtension extension) {
            super(_node, extension);
        }

        @Nullable
        public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
            if (child2 == null) {
                PostCssRootBlock.$$$reportNull$$$0(0);
            }
            if (child1 instanceof ASTBlock && child2 instanceof ASTBlock) {
                ASTNode node1 = ((ASTBlock)child1).getNode();
                ASTNode node2 = ((ASTBlock)child2).getNode();
                if (node1 != null && node2 != null && node1.getElementType() == PostCssElementTypes.POST_CSS_SIMPLE_VARIABLE_DECLARATION && node2.getElementType() == PostCssElementTypes.POST_CSS_SIMPLE_VARIABLE_DECLARATION) {
                    return Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)true, (int)this.getKeepBlankLines());
                }
            }
            return super.getSpacing(child1, child2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child2", "org/intellij/plugins/postcss/formatter/PostCssFormattingModelBuilder$PostCssRootBlock", "getSpacing"));
        }
    }
}

