/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools;

import com.intellij.execution.filters.AbstractFileHyperlinkFilter;
import com.intellij.execution.filters.FileHyperlinkRawData;
import com.intellij.execution.filters.FileHyperlinkRawDataFinder;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptErrorConsoleFilter
extends AbstractFileHyperlinkFilter
implements DumbAware {
    public static final FileHyperlinkRawDataFinder FINDER = new TypeScriptErrorFinder();
    private static final String PREFIX = ">> ";
    private static final String ERROR_PREFIX = "ERROR: ";

    public TypeScriptErrorConsoleFilter(@NotNull Project project, @Nullable File baseDir) {
        if (project == null) {
            TypeScriptErrorConsoleFilter.$$$reportNull$$$0(0);
        }
        this(project, baseDir == null ? null : baseDir.getAbsolutePath());
    }

    public TypeScriptErrorConsoleFilter(@NotNull Project project, @Nullable String baseDir) {
        if (project == null) {
            TypeScriptErrorConsoleFilter.$$$reportNull$$$0(1);
        }
        super(project, baseDir);
    }

    @NotNull
    public List<FileHyperlinkRawData> parse(@NotNull String line) {
        if (line == null) {
            TypeScriptErrorConsoleFilter.$$$reportNull$$$0(2);
        }
        List list = FINDER.find(line);
        if (list == null) {
            TypeScriptErrorConsoleFilter.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Nullable
    private static FileHyperlinkRawData parse(@NotNull String line, char openBracketChar, char closeBracketChar) {
        if (line == null) {
            TypeScriptErrorConsoleFilter.$$$reportNull$$$0(4);
        }
        int startInd = 0;
        int length = line.length();
        while (startInd < length) {
            int lineStartInd;
            int ind;
            int openParenthesesInd = line.indexOf(openBracketChar, startInd);
            if (openParenthesesInd == -1) {
                return null;
            }
            startInd = openParenthesesInd + 1;
            for (ind = lineStartInd = openParenthesesInd + 1; ind < length && Character.isDigit(line.charAt(ind)); ++ind) {
            }
            int lineEndInd = ind;
            if (lineStartInd == lineEndInd || lineEndInd < length && line.charAt(lineEndInd) != ',') continue;
            for (ind = lineEndInd + 1; ind < length && Character.isWhitespace(line.charAt(ind)); ++ind) {
            }
            int columnStartInd = ind;
            while (ind < length && Character.isDigit(line.charAt(ind))) {
                ++ind;
            }
            int columnEndInd = ind;
            if (columnStartInd == columnEndInd || columnEndInd + 1 >= length || line.charAt(columnEndInd) != closeBracketChar || line.charAt(columnEndInd + 1) != ':') continue;
            return TypeScriptErrorConsoleFilter.create(line, lineStartInd, lineEndInd, columnStartInd, columnEndInd);
        }
        return null;
    }

    @Nullable
    private static FileHyperlinkRawData create(@NotNull String line, int lineStartInd, int lineEndInd, int columnStartInd, int columnEndInd) {
        int pathEndOffset;
        int pathStartOffset;
        if (line == null) {
            TypeScriptErrorConsoleFilter.$$$reportNull$$$0(5);
        }
        if ((pathStartOffset = TypeScriptErrorConsoleFilter.indexOfNonWhitespace(line, 0)) == -1) {
            return null;
        }
        if (line.startsWith(PREFIX, pathStartOffset)) {
            pathStartOffset += PREFIX.length();
        }
        if (line.startsWith(ERROR_PREFIX, pathStartOffset)) {
            pathStartOffset += ERROR_PREFIX.length();
        }
        if (lineStartInd - 1 <= pathStartOffset) {
            return null;
        }
        for (pathEndOffset = lineStartInd - 1; pathEndOffset > 0 && Character.isWhitespace(line.charAt(pathEndOffset - 1)); --pathEndOffset) {
        }
        String path2 = line.substring(pathStartOffset, pathEndOffset);
        try {
            int lineNumber = Integer.parseInt(line.substring(lineStartInd, lineEndInd));
            int columnNumber = Integer.parseInt(line.substring(columnStartInd, columnEndInd));
            return new FileHyperlinkRawData(path2, lineNumber - 1, columnNumber - 1, pathStartOffset, columnEndInd + 1);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private static int indexOfNonWhitespace(@NotNull String str, int startInd) {
        if (str == null) {
            TypeScriptErrorConsoleFilter.$$$reportNull$$$0(6);
        }
        for (int i = startInd; i < str.length(); ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    @NotNull
    private static List<FileHyperlinkRawData> parseWebpackError(@NotNull String line) {
        FileHyperlinkRawData data2;
        char ch;
        int pathEndInd;
        if (line == null) {
            TypeScriptErrorConsoleFilter.$$$reportNull$$$0(7);
        }
        int length = line.length();
        int startInd = TypeScriptErrorConsoleFilter.indexOfNonWhitespace(line, 0);
        if (startInd == -1 || length <= startInd + 1 || line.charAt(startInd) != '@' || line.charAt(startInd + 1) != ' ') {
            List<FileHyperlinkRawData> list = Collections.emptyList();
            if (list == null) {
                TypeScriptErrorConsoleFilter.$$$reportNull$$$0(8);
            }
            return list;
        }
        int pathStartInd = TypeScriptErrorConsoleFilter.indexOfNonWhitespace(line, startInd + 2);
        for (pathEndInd = length; pathEndInd > 0 && (Character.isDigit(ch = line.charAt(pathEndInd - 1)) || Character.isWhitespace(ch) || ch == ':' || ch == '-'); --pathEndInd) {
        }
        if (pathStartInd == -1 || pathEndInd <= pathStartInd) {
            List<FileHyperlinkRawData> list = Collections.emptyList();
            if (list == null) {
                TypeScriptErrorConsoleFilter.$$$reportNull$$$0(9);
            }
            return list;
        }
        List result2 = null;
        int i = pathEndInd;
        while (i < length && (data2 = TypeScriptErrorConsoleFilter.parseWebpackLink(line, pathStartInd, pathEndInd, i)) != null) {
            if (result2 == null) {
                result2 = new SmartList();
            }
            result2.add(data2);
            i = data2.getHyperlinkEndInd();
        }
        List list = ContainerUtil.notNullize(result2);
        if (list == null) {
            TypeScriptErrorConsoleFilter.$$$reportNull$$$0(10);
        }
        return list;
    }

    @Nullable
    public static FileHyperlinkRawData parseWebpackLink(@NotNull String line, int pathStartInd, int pathEndInd, int startWhitespaceInd) {
        int nextColumnInd;
        int columnStartInd;
        int columnEndInd;
        int lineEndInd;
        if (line == null) {
            TypeScriptErrorConsoleFilter.$$$reportNull$$$0(11);
        }
        int length = line.length();
        int lineStartInd = TypeScriptErrorConsoleFilter.indexOfNonWhitespace(line, startWhitespaceInd);
        if (lineStartInd == -1 || lineStartInd == startWhitespaceInd) {
            return null;
        }
        for (lineEndInd = lineStartInd; lineEndInd < length && Character.isDigit(line.charAt(lineEndInd)); ++lineEndInd) {
        }
        if (lineStartInd == lineEndInd) {
            return null;
        }
        if (lineEndInd == length || line.charAt(lineEndInd) != ':') {
            return null;
        }
        for (columnEndInd = columnStartInd = lineEndInd + 1; columnEndInd < length && Character.isDigit(line.charAt(columnEndInd)); ++columnEndInd) {
        }
        if (columnStartInd == columnEndInd) {
            return null;
        }
        if (columnEndInd + 1 >= length || line.charAt(columnEndInd) != '-' && Character.isDigit(line.charAt(columnEndInd + 1))) {
            return null;
        }
        for (nextColumnInd = columnEndInd + 1; nextColumnInd < length && Character.isDigit(line.charAt(nextColumnInd)); ++nextColumnInd) {
        }
        int hyperlinkEndInd = nextColumnInd;
        if (hyperlinkEndInd < length && !Character.isWhitespace(line.charAt(hyperlinkEndInd))) {
            return null;
        }
        String path2 = StringUtil.replace((String)line.substring(pathStartInd, pathEndInd).trim(), (String)"/~/", (String)"/node_modules/");
        String lineStr = line.substring(lineStartInd, lineEndInd);
        String columnStr = line.substring(columnStartInd, columnEndInd);
        try {
            int lineNumber = Integer.parseInt(lineStr);
            int columnNumber = Integer.parseInt(columnStr);
            return new FileHyperlinkRawData(path2, lineNumber - 1, columnNumber, pathEndInd == startWhitespaceInd ? pathStartInd : lineStartInd, hyperlinkEndInd);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 8, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 3: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/buildTools/TypeScriptErrorConsoleFilter";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/buildTools/TypeScriptErrorConsoleFilter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "parseWebpackError";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 3: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "indexOfNonWhitespace";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "parseWebpackError";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "parseWebpackLink";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 8, 9, 10 -> new IllegalStateException(string);
        };
    }

    private static class TypeScriptErrorFinder
    implements FileHyperlinkRawDataFinder {
        private TypeScriptErrorFinder() {
        }

        @NotNull
        public List<FileHyperlinkRawData> find(@NotNull String line) {
            FileHyperlinkRawData data2;
            if (line == null) {
                TypeScriptErrorFinder.$$$reportNull$$$0(0);
            }
            if ((data2 = TypeScriptErrorConsoleFilter.parse(line, '(', ')')) == null) {
                data2 = TypeScriptErrorConsoleFilter.parse(line, '[', ']');
            }
            if (data2 == null) {
                List<FileHyperlinkRawData> list = TypeScriptErrorConsoleFilter.parseWebpackError(line);
                if (list == null) {
                    TypeScriptErrorFinder.$$$reportNull$$$0(1);
                }
                return list;
            }
            List list = ContainerUtil.createMaybeSingletonList((Object)data2);
            if (list == null) {
                TypeScriptErrorFinder.$$$reportNull$$$0(2);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "line";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/buildTools/TypeScriptErrorConsoleFilter$TypeScriptErrorFinder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/buildTools/TypeScriptErrorConsoleFilter$TypeScriptErrorFinder";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "find";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "find";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }
}

