/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.JSWhileStatement;
import com.intellij.lang.javascript.psi.impl.JSUseScopeProvider;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSJoinVariableDeclarationAndAssignmentInspection
extends JSInspection {
    private static final Class<? extends PsiElement>[] TARGET_SCOPE_TYPES = (Class[])ArrayUtil.mergeArrays((Object[])JSUseScopeProvider.getScopeTypes(), (Object[])new Class[]{JSIfStatement.class, JSWhileStatement.class});
    private final boolean myForceShow;

    public JSJoinVariableDeclarationAndAssignmentInspection() {
        this(false);
    }

    public JSJoinVariableDeclarationAndAssignmentInspection(boolean forceShow) {
        this.myForceShow = forceShow;
    }

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSJoinVariableDeclarationAndAssignmentInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            JSJoinVariableDeclarationAndAssignmentInspection.$$$reportNull$$$0(1);
        }
        return new JSElementVisitor(){

            @Override
            public void visitJSVarStatement(@NotNull JSVarStatement node) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                for (JSVariable variable : node.getVariables()) {
                    this.processJSVariable(variable, node);
                }
                super.visitJSVarStatement(node);
            }

            private void processJSVariable(@NotNull JSVariable declaration, @NotNull JSVarStatement statement) {
                if (declaration == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (statement == null) {
                    1.$$$reportNull$$$0(2);
                }
                PsiElement identifier = declaration.getNameIdentifier();
                PsiElement declarationScope = declaration.getDeclarationScope();
                if (identifier != null && declaration.getInitializer() == null && declaration.getName() != null && declarationScope != null && !JSDestructuringUtil.isDestructuring(declaration.getParent())) {
                    JSReferenceExpression reference;
                    Collection refsInTargetScope;
                    PsiElement targetScope;
                    MultiMap scopesToRefs = MultiMap.create();
                    SyntaxTraverser.psiTraverser((PsiElement)declarationScope).filter(JSReferenceExpression.class).filter(ref2 -> !ref2.hasQualifier() && declaration.getName().equals(ref2.getReferenceName()) && ref2.resolve() == declaration).forEach(ref2 -> {
                        PsiElement targetScope = 1.getTargetScope(ref2);
                        if (targetScope != null) {
                            scopesToRefs.putValue((Object)targetScope, ref2);
                        }
                    });
                    if (!scopesToRefs.isEmpty() && 1.allRefsAreWithinTargetScope(targetScope = 1.getScopeOfFirstByOffsetRef((MultiMap<PsiElement, JSReferenceExpression>)scopesToRefs), (MultiMap<PsiElement, JSReferenceExpression>)scopesToRefs) && !(refsInTargetScope = scopesToRefs.get((Object)targetScope)).isEmpty() && (reference = 1.findReference(refsInTargetScope, DialectDetector.isActionScript((PsiElement)declaration))) != null) {
                        boolean single = statement.getVariables().length == 1;
                        ASTNode varModifier = statement.getNode().findChildByType(JSTokenTypes.VAR_MODIFIERS);
                        TextRange range = single && varModifier != null ? new TextRange(varModifier.getStartOffset(), identifier.getTextRange().getEndOffset()).shiftLeft(statement.getTextOffset()) : identifier.getTextRange().shiftLeft((single ? statement : declaration).getTextOffset());
                        holder.registerProblem((PsiElement)(single ? statement : declaration), JavaScriptBundle.message("js.join.declaration.assignment.inspection.name", new Object[0]), JSJoinVariableDeclarationAndAssignmentInspection.this.myForceShow ? ProblemHighlightType.ERROR : ProblemHighlightType.GENERIC_ERROR_OR_WARNING, range, new LocalQuickFix[]{JSFixFactory.getInstance().createJoinDeclarationAndAssignmentFix(declaration, reference)});
                    }
                }
            }

            @Nullable
            private static PsiElement getTargetScope(JSElement element) {
                return PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])TARGET_SCOPE_TYPES);
            }

            private static JSReferenceExpression findReference(Collection<JSReferenceExpression> allRefs, boolean isActionScript) {
                if (!isActionScript) {
                    JSReferenceExpression reference = 1.getFirstByOffset(allRefs);
                    PsiElement parent = reference.getParent();
                    return parent instanceof JSDefinitionExpression || parent instanceof JSForInStatement ? reference : null;
                }
                for (JSReferenceExpression ref2 : allRefs) {
                    if (ref2.getParent() instanceof JSVariable) continue;
                    if (ref2.getParent() instanceof JSDefinitionExpression) {
                        return ref2;
                    }
                    return null;
                }
                return null;
            }

            private static PsiElement getScopeOfFirstByOffsetRef(MultiMap<PsiElement, JSReferenceExpression> scopesToRefs) {
                return (PsiElement)((Map.Entry)scopesToRefs.entrySet().stream().reduce((e1, e2) -> ((JSReferenceExpression)1.getFirstByOffset((Collection)e1.getValue())).getTextOffset() < ((JSReferenceExpression)1.getFirstByOffset((Collection)e2.getValue())).getTextOffset() ? e1 : e2).orElseThrow(() -> new IllegalArgumentException(String.valueOf(scopesToRefs)))).getKey();
            }

            private static <T extends PsiElement> T getFirstByOffset(Collection<T> elements) {
                return (T)((PsiElement)elements.stream().reduce((r1, r2) -> r1.getTextOffset() < r2.getTextOffset() ? r1 : r2).orElseThrow(() -> new IllegalArgumentException(String.valueOf(elements))));
            }

            private static boolean allRefsAreWithinTargetScope(@NotNull PsiElement targetScope, @NotNull MultiMap<PsiElement, JSReferenceExpression> scopesToRefs) {
                if (targetScope == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (scopesToRefs == null) {
                    1.$$$reportNull$$$0(4);
                }
                return ContainerUtil.and((Iterable)scopesToRefs.keySet(), scope2 -> PsiTreeUtil.isAncestor((PsiElement)targetScope, (PsiElement)scope2, (boolean)false));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "declaration";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "statement";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "targetScope";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "scopesToRefs";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSJoinVariableDeclarationAndAssignmentInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSVarStatement";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processJSVariable";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "allRefsAreWithinTargetScope";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/inspections/JSJoinVariableDeclarationAndAssignmentInspection";
        objectArray[2] = "createVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

