/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.parsing;

import com.intellij.ide.nls.NlsMessages;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderUtil;
import com.intellij.lang.javascript.JSDocTokenTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptParserBundle;
import com.intellij.lang.javascript.psi.jsdoc.JSDocBlockTags;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ObjectUtils;
import com.intellij.util.text.CharSequenceSubSequence;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class JSDocParsing {
    private final PsiBuilder builder;

    public static void parseJSDoc(@NotNull PsiBuilder builder2) {
        if (builder2 == null) {
            JSDocParsing.$$$reportNull$$$0(0);
        }
        new JSDocParsing(builder2).parseJSDoc();
    }

    private JSDocParsing(@NotNull PsiBuilder builder2) {
        if (builder2 == null) {
            JSDocParsing.$$$reportNull$$$0(1);
        }
        this.builder = builder2;
    }

    private IElementType getTokenType() {
        return this.builder.getTokenType();
    }

    private CharSequence getTokenCharSequence() {
        return this.builder.eof() ? null : PsiBuilderUtil.rawTokenText((PsiBuilder)this.builder, (int)0);
    }

    private void parseJSDoc() {
        this.builder.enforceCommentTokens(TokenSet.create((IElementType[])new IElementType[]{JSDocTokenTypes.DOC_COMMENT_LEADING_ASTERISK}));
        PsiBuilder.Marker root = this.builder.mark();
        while (!(this.endOfSection() || this.getTokenType() != JSDocTokenTypes.DOC_COMMENT_START && this.getTokenType() != JSDocTokenTypes.DOC_WHITESPACE)) {
            this.builder.advanceLexer();
        }
        if (this.getTokenType() == JSDocTokenTypes.DOC_COMMENT_END) {
            this.builder.advanceLexer();
        } else if (!this.builder.eof()) {
            if (!this.endOfSection()) {
                PsiBuilder.Marker commentDescription = this.builder.mark();
                while (!this.endOfSection()) {
                    if (this.parseInlineTag()) continue;
                    this.builder.advanceLexer();
                }
                commentDescription.done(JSDocTokenTypes.DOC_DESCRIPTION);
            }
            while (!this.builder.eof()) {
                if (this.parseDocTag()) continue;
                this.builder.advanceLexer();
            }
        }
        root.done(JSTokenTypes.DOC_COMMENT);
    }

    private boolean parseDocTag() {
        boolean namepathParsed;
        if (this.builder.getTokenType() != JSDocTokenTypes.DOC_TAG_NAME) {
            return false;
        }
        @NonNls CharSequence tagName = this.getTokenCharSequence();
        if (tagName == null) {
            return false;
        }
        PsiBuilder.Marker docTagMarker = this.builder.mark();
        if ((tagName = tagName.subSequence(1, tagName.length())).isEmpty()) {
            this.builder.error(JavaScriptParserBundle.message((String)"javascript.parser.message.missing.tag.name", (Object[])new Object[0]));
        }
        this.builder.advanceLexer();
        if (this.getTokenType() == JSDocTokenTypes.DOC_TAG_FORCED) {
            this.builder.advanceLexer();
        }
        boolean typeParsed = JSDocBlockTags.isTypeAllowed(tagName) && this.parseType(tagName, false);
        boolean bl = namepathParsed = JSDocBlockTags.isNamepathAllowed(tagName) && this.shouldParseNamepathIfSeeTag(tagName) && this.parseNamepath(tagName);
        while (namepathParsed && this.getTokenType() == JSDocTokenTypes.DOC_COMMA && JSDocBlockTags.hasCommaSeparatedNamePaths(tagName)) {
            this.builder.advanceLexer();
            if (this.parseNamepath(tagName)) continue;
        }
        if (JSDocBlockTags.hasNamespaceAsSyntax(tagName)) {
            if (this.getTokenType() != JSDocTokenTypes.DOC_NAMEPATH_AS) {
                this.builder.error(JavaScriptParserBundle.message((String)"javascript.parser.message.expected.as", (Object[])new Object[0]));
            } else {
                this.builder.advanceLexer();
                this.parseNamepath(tagName);
            }
        } else if (namepathParsed && !typeParsed && (this.getTokenType() == JSDocTokenTypes.DOC_COLON || this.getTokenType() == JSDocTokenTypes.DOC_LBRACE && JSDocBlockTags.isTypeAllowedAfterNamepath(tagName))) {
            if (this.getTokenType() == JSDocTokenTypes.DOC_COLON) {
                this.builder.advanceLexer();
            }
            this.parseType(tagName, true);
        }
        this.parseDescription(tagName);
        docTagMarker.done(JSDocTokenTypes.DOC_TAG);
        return true;
    }

    private boolean parseType(@NlsSafe CharSequence tagName, boolean namepathParsed) {
        if (this.getTokenType() == JSDocTokenTypes.DOC_NAMEPATH_PART && this.builder.lookAhead(1) == JSDocTokenTypes.DOC_COMMENT_DATA && !JSDocBlockTags.allowTypeNoBracesIfFollowedByContentOnTheSameLine(tagName) && !this.nextIsWhitespaceWithNewLine()) {
            return false;
        }
        if (this.getTokenType() != JSDocTokenTypes.DOC_LBRACE) {
            if ((!JSDocBlockTags.areBracesInTypeRequired(tagName) || namepathParsed) && this.getTokenType() == JSDocTokenTypes.DOC_NAMEPATH_PART) {
                PsiBuilder.Marker type2 = this.builder.mark();
                this.builder.advanceLexer();
                type2.collapse(JSDocTokenTypes.DOC_COMMENT_DATA);
                type2.precede().done(JSDocTokenTypes.DOC_TAG_TYPE);
                return true;
            }
            return false;
        }
        if (this.builder.rawLookup(1) == JSDocTokenTypes.DOC_TAG_NAME) {
            return false;
        }
        PsiBuilder.Marker type3 = this.builder.mark();
        assert (this.getTokenType() == JSDocTokenTypes.DOC_LBRACE);
        this.builder.advanceLexer();
        int balance = 1;
        int tokenCount = 0;
        while (!this.endOfSection() && balance > 0) {
            IElementType tokenType = this.getTokenType();
            if (tokenType.equals(JSDocTokenTypes.DOC_LBRACE)) {
                ++balance;
            } else if (tokenType.equals(JSDocTokenTypes.DOC_RBRACE)) {
                --balance;
            }
            ++tokenCount;
            this.builder.advanceLexer();
        }
        if (balance > 0) {
            this.builder.error(JavaScriptParserBundle.message((String)"javascript.parser.message.missing.rbrace", (Object[])new Object[0]));
        }
        if (!namepathParsed && tokenCount == 2 && !this.isNamepathStart(this.getTokenType(), tagName) && !JSDocBlockTags.isTypeAllowed(tagName) && JSDocBlockTags.isNamepathRequired(tagName)) {
            type3.done(JSDocTokenTypes.DOC_TAG_NAMEPATH);
            return false;
        }
        type3.done(JSDocTokenTypes.DOC_TAG_TYPE);
        return true;
    }

    private boolean parseNamepath(@NlsSafe CharSequence tagName) {
        if (!this.isNamepathStart(this.getTokenType(), tagName)) {
            return false;
        }
        PsiBuilder.Marker name = this.builder.mark();
        if (this.getTokenType() == JSDocTokenTypes.DOC_NAMEPATH_PART) {
            this.builder.advanceLexer();
        }
        int bracketBalance = 0;
        IElementType lbracket = JSDocTokenTypes.DOC_LBRACKET;
        IElementType rbracket = JSDocTokenTypes.DOC_RBRACKET;
        if (this.getTokenType() == JSDocTokenTypes.DOC_LBRACKET) {
            bracketBalance = 1;
            this.builder.advanceLexer();
        } else if (this.getTokenType() == JSDocTokenTypes.DOC_LPAR) {
            lbracket = JSDocTokenTypes.DOC_LPAR;
            rbracket = JSDocTokenTypes.DOC_RPAR;
            bracketBalance = 1;
            this.builder.advanceLexer();
        }
        if (bracketBalance > 0) {
            if (this.getTokenType() != JSDocTokenTypes.DOC_NAMEPATH_PART) {
                name.rollbackTo();
                return false;
            }
            this.builder.advanceLexer();
            while (!this.endOfSection() && bracketBalance > 0) {
                IElementType tokenType = this.getTokenType();
                if (tokenType == lbracket) {
                    ++bracketBalance;
                } else if (tokenType == rbracket) {
                    --bracketBalance;
                } else if (tokenType != JSDocTokenTypes.DOC_NAMEPATH_PART) break;
                this.builder.advanceLexer();
            }
            if (bracketBalance > 0) {
                if (rbracket == JSDocTokenTypes.DOC_RPAR) {
                    this.builder.error(JavaScriptParserBundle.message((String)"javascript.parser.message.missing.rparen", (Object[])new Object[0]));
                } else {
                    this.builder.error(JavaScriptParserBundle.message((String)"javascript.parser.message.missing.rbracket", (Object[])new Object[0]));
                }
            }
        }
        name.done(JSDocTokenTypes.DOC_TAG_NAMEPATH);
        return true;
    }

    private boolean shouldParseNamepathIfSeeTag(@NlsSafe CharSequence tagName) {
        if (!JSDocBlockTags.SEE.isSameName(tagName)) {
            return true;
        }
        IElementType nextToken = this.builder.lookAhead(1);
        return this.getTokenType() != JSDocTokenTypes.DOC_NAMEPATH_PART || nextToken != JSDocTokenTypes.DOC_COMMENT_DATA && nextToken != JSDocTokenTypes.DOC_LT;
    }

    private void parseDescription(@NlsSafe CharSequence tagName) {
        if (this.endOfSection()) {
            return;
        }
        if (this.getTokenType() == JSDocTokenTypes.DOC_MINUS) {
            this.builder.advanceLexer();
        }
        PsiBuilder.Marker value = this.builder.mark();
        int descriptionStart = this.builder.getCurrentOffset();
        while (!this.endOfSection()) {
            if (this.parseInlineTag()) continue;
            if (this.builder.getTokenType() == JSDocTokenTypes.DOC_NAMEPATH_PART) {
                PsiBuilder.Marker collapse = this.builder.mark();
                this.builder.advanceLexer();
                collapse.collapse(JSDocTokenTypes.DOC_COMMENT_DATA);
                continue;
            }
            this.builder.advanceLexer();
        }
        value.done(JSDocTokenTypes.DOC_DESCRIPTION);
        Set<CharSequence> possibleValues = JSDocBlockTags.getEnumValues(tagName);
        if (possibleValues != null) {
            int descriptionEndToken = -1;
            while (ObjectUtils.doIfNotNull((Object)this.builder.rawLookup(descriptionEndToken), arg_0 -> ((PsiBuilder)this.builder).isWhitespaceOrComment(arg_0)) == Boolean.TRUE) {
                --descriptionEndToken;
            }
            int descriptionEnd = this.builder.rawTokenTypeStart(descriptionEndToken + 1);
            Object description = new CharSequenceSubSequence(this.builder.getOriginalText(), descriptionStart, descriptionEnd);
            if (!possibleValues.contains(description = StringUtil.trim((CharSequence)description))) {
                value.precede().error(JavaScriptParserBundle.message((String)"javascript.parser.message.expected.one.of", (Object[])new Object[]{NlsMessages.formatOrList(possibleValues)}));
            }
        }
    }

    private boolean parseInlineTag() {
        if (this.getTokenType() != JSDocTokenTypes.DOC_LBRACKET && this.getTokenType() != JSDocTokenTypes.DOC_LBRACE) {
            return false;
        }
        PsiBuilder.Marker inlineTag = this.builder.mark();
        if (this.getTokenType() == JSDocTokenTypes.DOC_LBRACKET && this.builder.rawLookup(1) == JSDocTokenTypes.DOC_COMMENT_DATA && this.builder.rawLookup(2) == JSDocTokenTypes.DOC_RBRACKET && this.builder.rawLookup(3) == JSDocTokenTypes.DOC_LBRACE && this.builder.rawLookup(4) == JSDocTokenTypes.DOC_TAG_NAME) {
            this.builder.advanceLexer();
            assert (this.getTokenType() == JSDocTokenTypes.DOC_COMMENT_DATA);
            PsiBuilder.Marker inlineTagParam = this.builder.mark();
            this.builder.advanceLexer();
            inlineTagParam.done(JSDocTokenTypes.DOC_DESCRIPTION);
            assert (this.getTokenType() == JSDocTokenTypes.DOC_RBRACKET);
            this.builder.advanceLexer();
        }
        if (this.getTokenType() != JSDocTokenTypes.DOC_LBRACE || this.builder.rawLookup(1) != JSDocTokenTypes.DOC_TAG_NAME) {
            inlineTag.rollbackTo();
            return false;
        }
        this.builder.advanceLexer();
        assert (this.getTokenType() == JSDocTokenTypes.DOC_TAG_NAME);
        this.builder.advanceLexer();
        PsiBuilder.Marker inlineTagDescription = this.builder.mark();
        boolean haveNamepath = false;
        boolean haveDocData = false;
        while (!this.endOfSection() && this.getTokenType() != JSDocTokenTypes.DOC_RBRACE) {
            IElementType type2 = this.getTokenType();
            if (type2 == JSDocTokenTypes.DOC_NAMEPATH_PART) {
                haveNamepath = true;
            } else if (type2 == JSDocTokenTypes.DOC_COMMENT_DATA || type2 == JSDocTokenTypes.DOC_LT) {
                haveDocData = true;
            }
            this.builder.advanceLexer();
        }
        if (haveNamepath && !haveDocData) {
            inlineTagDescription.done(JSDocTokenTypes.DOC_TAG_NAMEPATH);
        } else {
            inlineTagDescription.done(JSDocTokenTypes.DOC_DESCRIPTION);
        }
        if (this.getTokenType() == JSDocTokenTypes.DOC_RBRACE) {
            this.builder.advanceLexer();
        }
        inlineTag.done(JSDocTokenTypes.DOC_INLINE_TAG);
        return true;
    }

    private boolean endOfSection() {
        if (this.builder.eof()) {
            return true;
        }
        IElementType tokenType = this.getTokenType();
        return tokenType == JSDocTokenTypes.DOC_TAG_NAME || tokenType == JSDocTokenTypes.DOC_COMMENT_END;
    }

    private boolean isNamepathStart(IElementType tokenType, CharSequence tagName) {
        IElementType nextToken = this.builder.rawLookup(1);
        return tokenType == JSDocTokenTypes.DOC_NAMEPATH_PART && (nextToken == JSDocTokenTypes.DOC_WHITESPACE || nextToken == JSDocTokenTypes.DOC_COMMENT_END || nextToken == JSDocTokenTypes.DOC_LBRACKET || nextToken == JSDocTokenTypes.DOC_LT || nextToken == JSDocTokenTypes.DOC_COMMA && JSDocBlockTags.hasCommaSeparatedNamePaths(tagName) || nextToken == JSDocTokenTypes.DOC_LBRACE && JSDocBlockTags.isTypeAllowedAfterNamepath(tagName)) || (tokenType == JSDocTokenTypes.DOC_LBRACKET || tokenType == JSDocTokenTypes.DOC_LPAR) && JSDocBlockTags.areOptionalParamsAllowed(tagName);
    }

    private boolean nextIsWhitespaceWithNewLine() {
        IElementType nextToken = this.builder.rawLookup(1);
        if (nextToken != JSDocTokenTypes.DOC_WHITESPACE) {
            return false;
        }
        return StringUtil.contains((CharSequence)this.builder.getOriginalText(), (int)this.builder.rawTokenTypeStart(1), (int)this.builder.rawTokenTypeStart(2), (char)'\n');
    }

    public static boolean isInsideJSDoc(PsiElement element) {
        return JSDocTokenTypes.ALL.contains(element.getParent().getNode().getElementType());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "builder";
        objectArray2[1] = "com/intellij/lang/javascript/parsing/JSDocParsing";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "parseJSDoc";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

