/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.dataSource.DdlMappingsManager;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.view.DbContextElements;
import com.intellij.database.view.DbContextElementsKt;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.util.containers.JBIterable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsWrapperGroup
extends DefaultActionGroup {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            VcsWrapperGroup.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
        if (!VcsWrapperGroup.hasDdlDataSources(e)) {
            if (AnAction.EMPTY_ARRAY == null) {
                VcsWrapperGroup.$$$reportNull$$$0(1);
            }
            return AnAction.EMPTY_ARRAY;
        }
        AnAction[] anActionArray = super.getChildren(e);
        if (anActionArray == null) {
            VcsWrapperGroup.$$$reportNull$$$0(2);
        }
        return anActionArray;
    }

    private static boolean hasDdlDataSources(@Nullable AnActionEvent e) {
        DbContextElements<?> elements;
        DbContextElements<?> dbContextElements = elements = e == null ? null : DbContextElementsKt.getContextElements(e);
        if (elements == null) {
            return false;
        }
        JBIterable dataSources = JBIterable.from(elements.getDataSources());
        for (RawDataSource ds : dataSources) {
            if (!(ds instanceof SqlDataSource)) continue;
            return true;
        }
        Project project = e.getProject();
        if (project == null) {
            return false;
        }
        DdlMappingsManager mappingsManager = DdlMappingsManager.getInstance(project);
        for (RawDataSource ds : dataSources) {
            if (!mappingsManager.findByDataSourceId(ds.getUniqueId()).isNotEmpty()) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/database/actions/VcsWrapperGroup";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

