/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport.editor;

import com.intellij.database.datagrid.DataGridListModel;
import com.intellij.database.dbimport.editor.data.DbQuerySourceData;
import com.intellij.database.dbimport.editor.data.DbTableSourceData;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.WrapperElementFactory;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.schemaEditor.DbEditorModelSynchronizer;
import com.intellij.database.schemaEditor.ElementIdentity;
import com.intellij.database.schemaEditor.ElementOwner;
import com.intellij.database.schemaEditor.model.DbEditorModelController;
import com.intellij.openapi.util.Key;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbImportCachedDataManager {
    private static final Key<DbImportCachedDataManager> KEY = Key.create((String)"DbImportCachedDataManager");
    private final DbEditorModelController myController;
    private final Map<ElementIdentity<?>, CachedData> myCache;

    public static DbImportCachedDataManager getInstance(@NotNull DbEditorModelController controller) {
        if (controller == null) {
            DbImportCachedDataManager.$$$reportNull$$$0(0);
        }
        return (DbImportCachedDataManager)DbEditorModelSynchronizer.getBackModelController(controller).getDataHolder().getUserData(KEY);
    }

    public DbImportCachedDataManager(@NotNull DbEditorModelController controller) {
        if (controller == null) {
            DbImportCachedDataManager.$$$reportNull$$$0(1);
        }
        this.myCache = new ConcurrentHashMap();
        this.myController = controller;
        this.myController.getDataHolder().putUserData(KEY, (Object)this);
    }

    public void setCachedData(@NotNull ElementIdentity<?> id, @Nullable DataGridListModel data) {
        if (id == null) {
            DbImportCachedDataManager.$$$reportNull$$$0(2);
        }
        if (data == null) {
            this.myCache.remove(id);
            return;
        }
        if (!DbImportCachedDataManager.isCacheable(id.getMetaObject().kind)) {
            return;
        }
        Object def = this.myController.accessActualOwner(owner -> DbImportCachedDataManager.getDefinition(owner == null ? null : (BasicElement)owner.find(id)));
        if (def == null) {
            return;
        }
        this.myCache.put(id, new CachedData(data, def));
    }

    public boolean hasCachedData(@NotNull ElementIdentity<?> id) {
        if (id == null) {
            DbImportCachedDataManager.$$$reportNull$$$0(3);
        }
        return this.myCache.containsKey(id);
    }

    @Nullable
    public DataGridListModel getCachedData(@Nullable ElementOwner owner, @NotNull ElementIdentity<?> id) {
        if (id == null) {
            DbImportCachedDataManager.$$$reportNull$$$0(4);
        }
        return this.getCachedData(id, owner == null ? null : (BasicElement)owner.find(id), true);
    }

    public boolean isCachedDataAvailable(@NotNull ElementIdentity<?> id, @Nullable BasicElement e) {
        if (id == null) {
            DbImportCachedDataManager.$$$reportNull$$$0(5);
        }
        return this.getCachedData(id, e, false) != null;
    }

    @Nullable
    private static Object getDefinition(@Nullable BasicElement e) {
        return WrapperElementFactory.getDelegate(e, Object.class);
    }

    @Nullable
    private DataGridListModel getCachedData(@NotNull ElementIdentity<?> id, @Nullable BasicElement e, boolean checkEnabled) {
        if (id == null) {
            DbImportCachedDataManager.$$$reportNull$$$0(6);
        }
        CachedData data = this.myCache.get(id);
        Object def = DbImportCachedDataManager.getDefinition(e);
        return data == null || def == null || !data.matches(def, checkEnabled) ? null : data.getData();
    }

    private static boolean isCacheable(ObjectKind kind) {
        return kind == DbTableSourceData.KIND || kind == DbQuerySourceData.KIND;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dbimport/editor/DbImportCachedDataManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setCachedData";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "hasCachedData";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getCachedData";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isCachedDataAvailable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class CachedData {
        private final DataGridListModel myData;
        private final Object myOriginalDef;

        protected CachedData(@NotNull DataGridListModel data, @NotNull Object originalDef) {
            if (data == null) {
                CachedData.$$$reportNull$$$0(0);
            }
            if (originalDef == null) {
                CachedData.$$$reportNull$$$0(1);
            }
            this.myData = data;
            this.myOriginalDef = originalDef instanceof DbTableSourceData ? ((DbTableSourceData)originalDef).clone() : (originalDef instanceof DbQuerySourceData ? ((DbQuerySourceData)originalDef).clone() : null);
        }

        @NotNull
        public DataGridListModel getData() {
            DataGridListModel dataGridListModel = this.myData;
            if (dataGridListModel == null) {
                CachedData.$$$reportNull$$$0(2);
            }
            return dataGridListModel;
        }

        public boolean matches(@Nullable Object def, boolean checkEnabled) {
            Object tbl;
            Object object = this.myOriginalDef;
            if (object instanceof DbTableSourceData) {
                DbTableSourceData oTbl = (DbTableSourceData)object;
                if (def instanceof DbTableSourceData) {
                    tbl = (DbTableSourceData)def;
                    return BasicMetaUtils.isEquivalent(oTbl.getDataSourceRef(), ((DbTableSourceData)tbl).getDataSourceRef()) && BasicMetaUtils.isEquivalent(oTbl.getTableRef(), ((DbTableSourceData)tbl).getTableRef()) && (!checkEnabled || ((DbTableSourceData)tbl).getUseCached());
                }
            }
            if ((tbl = this.myOriginalDef) instanceof DbQuerySourceData) {
                DbQuerySourceData oQr = (DbQuerySourceData)tbl;
                if (def instanceof DbQuerySourceData) {
                    DbQuerySourceData qr = (DbQuerySourceData)def;
                    return BasicMetaUtils.isEquivalent(oQr.getDataSourceRef(), qr.getDataSourceRef()) && BasicMetaUtils.isEquivalent(oQr.getNamespaceRef(), qr.getNamespaceRef()) && Objects.equals(oQr.getQuery(), qr.getQuery()) && (!checkEnabled || qr.getUseCached());
                }
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "originalDef";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dbimport/editor/DbImportCachedDataManager$CachedData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dbimport/editor/DbImportCachedDataManager$CachedData";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

