/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.introspector.jdbc.wrappers;

import com.intellij.database.dialects.base.introspector.jdbc.wrappers.ClosableIt;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.DatabaseMetaDataWrapper;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.MetaDataUtil;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import java.sql.SQLException;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TableVersionColumnIt
extends ClosableIt.ResultSetClosableIt<DatabaseMetaDataWrapper.TableColumn> {
    private final DatabaseMetaDataWrapper.Table myTable;

    public TableVersionColumnIt(@Nullable RemoteResultSet rs, @NotNull DatabaseMetaDataWrapper.Table table) throws SQLException {
        if (table == null) {
            TableVersionColumnIt.$$$reportNull$$$0(0);
        }
        super(rs);
        this.myTable = table;
    }

    @Override
    @NotNull
    protected DatabaseMetaDataWrapper.TableColumn createStorage() {
        return new DatabaseMetaDataWrapper.TableColumn(this.myTable);
    }

    @Override
    protected DatabaseMetaDataWrapper.TableColumn calcValue() {
        DatabaseMetaDataWrapper.TableColumn res2 = (DatabaseMetaDataWrapper.TableColumn)this.getStorageToFill();
        try {
            short type = this.myRs.getShort("PSEUDO_COLUMN", 8);
            if (type == 2) {
                return (DatabaseMetaDataWrapper.TableColumn)this.skip();
            }
            res2.name = this.myRs.getString("COLUMN_NAME", 2);
        }
        catch (SQLException e) {
            this.onError(res2, e);
            return (DatabaseMetaDataWrapper.TableColumn)this.skip();
        }
        return res2;
    }

    @Override
    public void onError(DatabaseMetaDataWrapper.TableColumn cur, SQLException e) {
        String title = cur == null ? null : MetaDataUtil.qName(cur.table.schema.database, cur.table.schema.schema, cur.table.name);
        this.addError(title, e);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dialects/base/introspector/jdbc/wrappers/TableVersionColumnIt", "<init>"));
    }

    public static class Grouping
    extends ClosableIt.GroupingItImpl<DatabaseMetaDataWrapper.Table, DatabaseMetaDataWrapper.TableColumn, DatabaseMetaDataWrapper.TableColumn> {
        protected Grouping(@NotNull ClosableIt<DatabaseMetaDataWrapper.TableColumn> delegate) {
            if (delegate == null) {
                Grouping.$$$reportNull$$$0(0);
            }
            super(delegate);
        }

        @Override
        @NotNull
        protected ClosableIt.GroupingItImpl.GroupIt<DatabaseMetaDataWrapper.TableColumn> createGroupIt(ClosableIt<DatabaseMetaDataWrapper.TableColumn> it) {
            final String tableName = ((DatabaseMetaDataWrapper.TableColumn)it.current()).table.name;
            return new ClosableIt.GroupingItImpl.GroupIt<DatabaseMetaDataWrapper.TableColumn>(it){

                @Override
                protected boolean isInGroup(DatabaseMetaDataWrapper.TableColumn item) {
                    return Objects.equals(tableName, item.table.name);
                }
            };
        }

        @Override
        protected DatabaseMetaDataWrapper.Table getItem(ClosableIt<DatabaseMetaDataWrapper.TableColumn> it) {
            return ((DatabaseMetaDataWrapper.TableColumn)it.current()).table;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/database/dialects/base/introspector/jdbc/wrappers/TableVersionColumnIt$Grouping", "<init>"));
        }
    }
}

