/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mysql;

import com.intellij.database.Dbms;
import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.SizeProvider;
import com.intellij.database.data.types.domain.OperationSupport;
import com.intellij.database.data.types.domain.TextDomain;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.dialects.mysqlbase.MysqlBaseDomains;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public final class MysqlDomains
extends MysqlBaseDomains {
    public MysqlDomains(@NotNull Dbms dbms) {
        if (dbms == null) {
            MysqlDomains.$$$reportNull$$$0(0);
        }
        super(dbms, false, false);
        this.add(new TextDomain("tinytext", ConversionPoint.VARCHAR, 255L){

            @Override
            public boolean isSuitable(@NotNull ColumnDescriptor descriptor2) {
                if (descriptor2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (descriptor2 instanceof GridColumn && descriptor2 instanceof SizeProvider) {
                    return ((SizeProvider)descriptor2).getSize() == 255 && descriptor2.getType() == -1 && (StringUtil.equalsIgnoreCase((CharSequence)descriptor2.getTypeName(), (CharSequence)"text") || StringUtil.equalsIgnoreCase((CharSequence)descriptor2.getTypeName(), (CharSequence)"varchar"));
                }
                return super.isSuitable(descriptor2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/database/dialects/mysql/MysqlDomains$1", "isSuitable"));
            }
        });
        this.add(new TextDomain("text", ConversionPoint.TEXT, 65535L){

            @Override
            public boolean isSuitable(@NotNull ColumnDescriptor descriptor2) {
                if (descriptor2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (descriptor2 instanceof GridColumn && descriptor2 instanceof SizeProvider) {
                    return ((SizeProvider)descriptor2).getSize() == 65535 && (StringUtil.equalsIgnoreCase((CharSequence)descriptor2.getTypeName(), (CharSequence)"mediumtext") || StringUtil.equalsIgnoreCase((CharSequence)descriptor2.getTypeName(), (CharSequence)"varchar"));
                }
                return super.isSuitable(descriptor2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/database/dialects/mysql/MysqlDomains$2", "isSuitable"));
            }
        });
        this.add(new TextDomain("mediumtext", ConversionPoint.CLOB, 0xFFFFFFL){

            @Override
            public boolean isSuitable(@NotNull ColumnDescriptor descriptor2) {
                if (descriptor2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (descriptor2 instanceof GridColumn && descriptor2 instanceof SizeProvider) {
                    return (long)((SizeProvider)descriptor2).getSize() == 0xFFFFFFL && (StringUtil.equalsIgnoreCase((CharSequence)descriptor2.getTypeName(), (CharSequence)"longtext") || StringUtil.equalsIgnoreCase((CharSequence)descriptor2.getTypeName(), (CharSequence)"varchar"));
                }
                return super.isSuitable(descriptor2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/database/dialects/mysql/MysqlDomains$3", "isSuitable"));
            }
        }.withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add(new TextDomain("longtext", ConversionPoint.CLOB, 0xFFFFFFFFL){

            @Override
            public boolean isSuitable(@NotNull ColumnDescriptor descriptor2) {
                if (descriptor2 == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (descriptor2 instanceof GridColumn && descriptor2 instanceof SizeProvider) {
                    int precision = ((SizeProvider)descriptor2).getSize();
                    return !(precision != 0x2AAAAAAA && precision != 0x1FFFFFFF || !StringUtil.equalsIgnoreCase((CharSequence)descriptor2.getTypeName(), (CharSequence)"longtext") && !StringUtil.equalsIgnoreCase((CharSequence)descriptor2.getTypeName(), (CharSequence)"varchar"));
                }
                return super.isSuitable(descriptor2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/database/dialects/mysql/MysqlDomains$4", "isSuitable"));
            }
        }.withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add(new TextDomain("char", ConversionPoint.CHAR, 255L, 1L, true, false));
        this.add(new TextDomain("varchar", ConversionPoint.VARCHAR, 21844L, TextDomain.Length.mandatory(4368L, true)){

            @Override
            public boolean isSuitable(@NotNull ColumnDescriptor descriptor2) {
                if (descriptor2 == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (descriptor2 instanceof GridColumn) {
                    return super.isSuitable(descriptor2) && descriptor2.getType() == 12;
                }
                return super.isSuitable(descriptor2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/database/dialects/mysql/MysqlDomains$5", "isSuitable"));
            }
        });
        this.add(new TextDomain("nvarchar", ConversionPoint.NVARCHAR, 21844L, TextDomain.Length.mandatory(4368L, true)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dbms", "com/intellij/database/dialects/mysql/MysqlDomains", "<init>"));
    }
}

