/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi.documentation;

import com.intellij.codeInsight.navigation.UtilKt;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.access.ConnectionProvider;
import com.intellij.database.dataSource.connection.DGDepartment;
import com.intellij.database.psi.DbElement;
import com.intellij.database.run.ui.DbDocumentationHelper;
import com.intellij.model.Pointer;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.backend.documentation.DocumentationResult;
import com.intellij.platform.backend.documentation.DocumentationTarget;
import com.intellij.platform.backend.presentation.TargetPresentation;
import com.intellij.psi.SmartPointersKt;
import java.util.concurrent.CancellationException;
import java.util.function.Function;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DbElementDocumentationTarget<E extends DbElement>
implements DocumentationTarget {
    private final E myElement;

    public DbElementDocumentationTarget(@NotNull E element) {
        if (element == null) {
            DbElementDocumentationTarget.$$$reportNull$$$0(0);
        }
        this.myElement = element;
    }

    public E getDbElement() {
        return this.myElement;
    }

    @NotNull
    public Pointer<? extends DocumentationTarget> createPointer() {
        Pointer pointer = Pointer.delegatingPointer((Pointer)SmartPointersKt.createSmartPointer(this.myElement), this.getClass(), this.getFactory());
        if (pointer == null) {
            DbElementDocumentationTarget.$$$reportNull$$$0(1);
        }
        return pointer;
    }

    @NotNull
    protected abstract Function<E, DocumentationTarget> getFactory();

    @NotNull
    public TargetPresentation computePresentation() {
        TargetPresentation targetPresentation = UtilKt.targetPresentation(this.myElement);
        if (targetPresentation == null) {
            DbElementDocumentationTarget.$$$reportNull$$$0(2);
        }
        return targetPresentation;
    }

    @Nullable
    public DocumentationResult computeDocumentation() {
        return DocumentationResult.documentation((String)this.getDocumentation());
    }

    @Nls
    @NotNull
    protected abstract String getDocumentation();

    public abstract String substitute(@NotNull ConnectionProvider var1, @Nls @NotNull String var2, @NotNull String var3) throws Exception;

    @Nls
    public static String substitute(@Nls @NotNull String content, @NotNull String section, @Nls @NotNull String value) {
        int from;
        if (content == null) {
            DbElementDocumentationTarget.$$$reportNull$$$0(3);
        }
        if (section == null) {
            DbElementDocumentationTarget.$$$reportNull$$$0(4);
        }
        if (value == null) {
            DbElementDocumentationTarget.$$$reportNull$$$0(5);
        }
        int to = (from = StringUtil.indexOfSubstringEnd((String)content, (String)DbDocumentationHelper.sectionStart(section))) == -1 ? -1 : StringUtil.indexOf((CharSequence)content, (CharSequence)DbDocumentationHelper.sectionEnd(section), (int)from);
        return to == -1 ? content : content.substring(0, from) + value + content.substring(to);
    }

    @Nls
    @NotNull
    public static String substituteConnecting(@Nls String currentContent, String section) {
        String string = DbElementDocumentationTarget.substitute(currentContent, section, HtmlChunk.text((String)DatabaseBundle.message("connecting.to.database.ellipsis", new Object[0])).wrapWith("small").toString());
        if (string == null) {
            DbElementDocumentationTarget.$$$reportNull$$$0(6);
        }
        return string;
    }

    static String loadAndSubstitute(@Nls String currentContent, DbElementDocumentationTarget<?> dbTarget, String section) {
        try {
            return (String)ConnectionProvider.computeWithProvider(dbTarget.getDbElement(), DGDepartment.QUICK_DOCUMENTATION, provider -> dbTarget.substitute((ConnectionProvider)provider, currentContent, section));
        }
        catch (CancellationException e) {
            throw e;
        }
        catch (Throwable e) {
            return DbElementDocumentationTarget.substitute(currentContent, section, HtmlChunk.text((String)DatabaseBundle.message("connection.failed", new Object[0])).bold().toString());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/psi/documentation/DbElementDocumentationTarget";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "section";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/psi/documentation/DbElementDocumentationTarget";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createPointer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "computePresentation";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteConnecting";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "substitute";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 6 -> new IllegalStateException(string);
        };
    }
}

