/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.model.applier;

import com.intellij.database.model.DasIndex;
import com.intellij.database.model.basic.BasicModIndex;
import com.intellij.database.schemaEditor.ElementOwner;
import com.intellij.database.schemaEditor.model.DbEditorModel;
import com.intellij.database.schemaEditor.model.applier.DbKeyColumnsModelApplier;
import com.intellij.database.schemaEditor.model.state.DbCollectionModelState;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbIndexColumnsModelApplier<E extends BasicModIndex, C extends IndexColumn>
extends DbKeyColumnsModelApplier<E, C> {
    @Override
    public C createItem(@Nullable C src) {
        return (C)new IndexColumn((IndexColumn)src);
    }

    @Override
    protected void applyItems(@NotNull ElementOwner owner, @NotNull E e, @NotNull List<C> items) {
        if (owner == null) {
            DbIndexColumnsModelApplier.$$$reportNull$$$0(0);
        }
        if (e == null) {
            DbIndexColumnsModelApplier.$$$reportNull$$$0(1);
        }
        if (items == null) {
            DbIndexColumnsModelApplier.$$$reportNull$$$0(2);
        }
        super.applyItems(owner, e, items);
        e.setReverseColNames(ContainerUtil.map2SetNotNull(items, c2 -> c2.sorting == DasIndex.Sorting.DESCENDING ? this.getColName(owner, (C)c2) : null));
    }

    @Override
    @NotNull
    protected String getColName(@NotNull ElementOwner owner, C c2) {
        if (owner == null) {
            DbIndexColumnsModelApplier.$$$reportNull$$$0(3);
        }
        String res2 = super.getColName(owner, c2);
        Object object = ((IndexColumn)c2).name.getTargetId() == null ? "\u001b" + res2 : res2;
        if (object == null) {
            DbIndexColumnsModelApplier.$$$reportNull$$$0(4);
        }
        return object;
    }

    @Override
    @NotNull
    protected List<C> extractColumns(@NotNull DbEditorModel<E, DbCollectionModelState<C>> model, @NotNull ElementOwner owner, @NotNull E e) {
        if (model == null) {
            DbIndexColumnsModelApplier.$$$reportNull$$$0(5);
        }
        if (owner == null) {
            DbIndexColumnsModelApplier.$$$reportNull$$$0(6);
        }
        if (e == null) {
            DbIndexColumnsModelApplier.$$$reportNull$$$0(7);
        }
        List<C> res2 = super.extractColumns(model, owner, e);
        Set<String> rev = e.getReverseColNames();
        for (IndexColumn col : res2) {
            col.sorting = rev.contains(col.name.getActualName()) ? DasIndex.Sorting.DESCENDING : DasIndex.Sorting.NONE;
        }
        List<C> list = res2;
        if (list == null) {
            DbIndexColumnsModelApplier.$$$reportNull$$$0(8);
        }
        return list;
    }

    @Override
    protected String sanitizeColName(String name2) {
        return StringUtil.trimLeading((String)name2, (char)'\u001b');
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/model/applier/DbIndexColumnsModelApplier";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/model/applier/DbIndexColumnsModelApplier";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getColName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "extractColumns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "applyItems";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getColName";
                break;
            }
            case 4: 
            case 8: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "extractColumns";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 8 -> new IllegalStateException(string);
        };
    }

    public static class IndexColumn
    extends DbKeyColumnsModelApplier.KeyColumn {
        @NotNull
        public DasIndex.Sorting sorting;

        public IndexColumn(@Nullable IndexColumn src) {
            super(src);
            this.sorting = src == null ? DasIndex.Sorting.NONE : src.sorting;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof IndexColumn)) {
                return false;
            }
            return super.equals(o) && this.sorting == ((IndexColumn)o).sorting;
        }

        @Override
        public int hashCode() {
            return Objects.hash(new Object[]{super.hashCode(), this.sorting});
        }
    }
}

