/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.ui;

import com.intellij.database.dataSource.url.FieldSize;
import com.intellij.database.dataSource.url.ui.DatabaseUIUtils;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.schemaEditor.model.DbModelRef;
import com.intellij.database.schemaEditor.model.state.DbCompoundModelState;
import com.intellij.database.schemaEditor.ui.DbEditorController;
import com.intellij.database.schemaEditor.ui.DbFormCompoundEditor;
import com.intellij.database.schemaEditor.ui.DbVisualEditorBase;
import com.intellij.openapi.util.Condition;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ThreeStateCheckBox;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DbToggleableFormCompoundEditor<E extends BasicElement, S extends DbCompoundModelState>
extends DbFormCompoundEditor<E, S> {
    private ThreeStateCheckBox myBox;
    private JComponent myForm;

    protected DbToggleableFormCompoundEditor(@NotNull DbEditorController controller, @NotNull DbModelRef<E, S> model, @NotNull Condition<DbModelRef<?, ?>> filter) {
        if (controller == null) {
            DbToggleableFormCompoundEditor.$$$reportNull$$$0(0);
        }
        if (model == null) {
            DbToggleableFormCompoundEditor.$$$reportNull$$$0(1);
        }
        if (filter == null) {
            DbToggleableFormCompoundEditor.$$$reportNull$$$0(2);
        }
        super(controller, model, filter);
    }

    @Override
    @NotNull
    protected JComponent createComponent() {
        this.myBox = new ThreeStateCheckBox(this.getModelTitle());
        this.myBox.setThirdStateEnabled(false);
        this.myBox.setBorder((Border)JBUI.Borders.emptyRight((int)10));
        this.myBox.addItemListener(e -> this.onChecked());
        FieldSize size = super.getFieldSize();
        boolean vertical = this.isVertical();
        boolean boxOnTop = size == FieldSize.LARGE || vertical;
        int total = DbToggleableFormCompoundEditor.getWidth(boxOnTop ? FieldSize.LARGE : FieldSize.MEDIUM);
        this.myForm = this.createForm(total);
        JPanel panel2 = new JPanel((LayoutManager)new GridLayoutManager(boxOnTop ? 2 : 1, 6));
        if (boxOnTop) {
            panel2.add((Component)this.myBox, DatabaseUIUtils.createRowConstraints(0));
            panel2.add((Component)this.myForm, DatabaseUIUtils.createRowConstraints(1));
        } else {
            panel2.add((Component)this.myBox, DbToggleableFormCompoundEditor.createConstraint(0, 0, 1, false));
            panel2.add((Component)this.myForm, DbToggleableFormCompoundEditor.createConstraint(0, 1, total, false));
        }
        JPanel jPanel = panel2;
        if (jPanel == null) {
            DbToggleableFormCompoundEditor.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    @Override
    @Nullable
    public String getTitle() {
        return null;
    }

    private void onChecked() {
        if (this.myBox.getState() == ThreeStateCheckBox.State.DONT_CARE) {
            return;
        }
        this.modified();
        this.updateEnabled();
    }

    @Override
    public void applyImpl() {
        super.applyImpl();
        if (this.myBox.getState() == ThreeStateCheckBox.State.DONT_CARE) {
            ((DbCompoundModelState)this.getState()).setInconsistent(true);
        }
        this.setToggleState(this.myBox.getState() != ThreeStateCheckBox.State.NOT_SELECTED);
    }

    @Override
    public void resetImpl() {
        super.resetImpl();
        if (((DbCompoundModelState)this.getState()).isInconsistent()) {
            this.myBox.setState(ThreeStateCheckBox.State.DONT_CARE);
        } else {
            this.myBox.setSelected(this.getToggleState());
        }
    }

    @Override
    @NotNull
    public FieldSize getFieldSize() {
        FieldSize fieldSize = FieldSize.LARGE;
        if (fieldSize == null) {
            DbToggleableFormCompoundEditor.$$$reportNull$$$0(4);
        }
        return fieldSize;
    }

    protected abstract void setToggleState(boolean var1);

    protected abstract boolean getToggleState();

    @Override
    protected void setEnabled(boolean state) {
        super.setEnabled(state);
        DbVisualEditorBase.setEnabled(this.myForm, state && this.myBox.isSelected());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/ui/DbToggleableFormCompoundEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/ui/DbToggleableFormCompoundEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createComponent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldSize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }
}

