/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.DatabaseDataKeysCore;
import com.intellij.database.Dbms;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.SqlDialects;
import com.intellij.database.view.DatabaseDialogsHelperCore;
import com.intellij.database.view.ui.DsUiDefaults;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.EditorTextField;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ObjectUtils;
import java.util.function.Function;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseDialogsHelper
extends DatabaseDialogsHelperCore {
    @NotNull
    public static EditorTextField createLanguageEditorArea(@NotNull Project project, @NotNull DasDataSource dataSource, @Nullable SearchPath searchPath, @NotNull String query, boolean isViewer) {
        if (project == null) {
            DatabaseDialogsHelper.$$$reportNull$$$0(0);
        }
        if (dataSource == null) {
            DatabaseDialogsHelper.$$$reportNull$$$0(1);
        }
        if (query == null) {
            DatabaseDialogsHelper.$$$reportNull$$$0(2);
        }
        DbDataSource dbDataSource = DbPsiFacade.getInstance(project).findDataSource(dataSource.getUniqueId());
        return DatabaseDialogsHelper.createLanguageEditorArea(project, dataSource.getDbms(), dbDataSource, searchPath, query, isViewer);
    }

    @NotNull
    public static EditorTextField createLanguageEditorArea(@NotNull Project project, @NotNull Dbms dbms, @Nullable DbDataSource dataSource, @Nullable SearchPath searchPath, @NotNull String query, boolean isViewer) {
        if (project == null) {
            DatabaseDialogsHelper.$$$reportNull$$$0(3);
        }
        if (dbms == null) {
            DatabaseDialogsHelper.$$$reportNull$$$0(4);
        }
        if (query == null) {
            DatabaseDialogsHelper.$$$reportNull$$$0(5);
        }
        Language language = dataSource != null ? DbSqlUtil.getLanguage(dataSource) : DbSqlUtil.getLanguage(dbms);
        return DatabaseDialogsHelper.createLanguageEditorArea(project, language, dataSource, searchPath, query, isViewer);
    }

    @NotNull
    public static EditorTextField createLanguageEditorArea(@NotNull Project project, @NotNull Language language, @Nullable DbDataSource dataSource, @Nullable SearchPath searchPath, @NotNull String query, boolean isViewer) {
        if (project == null) {
            DatabaseDialogsHelper.$$$reportNull$$$0(6);
        }
        if (language == null) {
            DatabaseDialogsHelper.$$$reportNull$$$0(7);
        }
        if (query == null) {
            DatabaseDialogsHelper.$$$reportNull$$$0(8);
        }
        String ext = DbSqlUtilCore.isJSLanguage(language) ? "js" : "sql";
        PsiFile psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText("a." + ext, language, (CharSequence)query);
        psiFile.putUserData(DatabaseDataKeysCore.DATA_SOURCE_KEY, (Object)dataSource);
        psiFile.putUserData(DatabaseDataKeysCore.SEARCH_PATH_KEY, (Object)searchPath);
        return DatabaseDialogsHelper.createEditorTextArea(psiFile, false, isViewer, true);
    }

    @NotNull
    public static EditorTextField createEditorTextArea(PsiFile psiFile, boolean oneLine, boolean isViewer, boolean softWraps) {
        EditorTextField area = DatabaseDialogsHelper.createEditorTextField(psiFile, oneLine, isViewer);
        area.setFontInheritedFromLAF(false);
        area.addSettingsProvider(editor2 -> {
            editor2.getSettings().setWheelFontChangeEnabled(true);
            editor2.getSettings().setFoldingOutlineShown(true);
            editor2.setHorizontalScrollbarVisible(true);
            editor2.setVerticalScrollbarVisible(true);
            editor2.getSettings().setAdditionalLinesCount(2);
            editor2.getSettings().setUseSoftWraps(softWraps);
        });
        EditorTextField editorTextField2 = area;
        if (editorTextField2 == null) {
            DatabaseDialogsHelper.$$$reportNull$$$0(9);
        }
        return editorTextField2;
    }

    @NotNull
    public static EditorTextField createLanguageEditorField(PsiFile psiFile) {
        return DatabaseDialogsHelper.createEditorTextField(psiFile, true, false);
    }

    @NotNull
    public static EditorTextField createEditorTextField(PsiFile psiFile, boolean oneLine, boolean isViewer) {
        Project project = psiFile.getProject();
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(psiFile);
        EditorTextField textField = new EditorTextField(document, project, psiFile.getFileType(), isViewer, oneLine);
        textField.setFontInheritedFromLAF(false);
        textField.addSettingsProvider(editor2 -> {
            DatabaseDialogsHelper.setSyntaxHighlighter(project, editor2);
            editor2.setEmbeddedIntoDialogWrapper(true);
            editor2.getSettings().setLineNumbersShown(false);
        });
        EditorTextField editorTextField2 = textField;
        if (editorTextField2 == null) {
            DatabaseDialogsHelper.$$$reportNull$$$0(10);
        }
        return editorTextField2;
    }

    private static void setSyntaxHighlighter(Project project, EditorEx editor2) {
        VirtualFile file = editor2.getVirtualFile();
        if (file == null) {
            file = FileDocumentManager.getInstance().getFile((Document)editor2.getDocument());
        }
        SqlLanguageDialect dialect = file == null ? SqlDialects.getGenericDialect() : LanguageUtil.getLanguageForPsi((Project)project, (VirtualFile)file);
        DatabaseDialogsHelper.setSpecificSyntaxHighlighter(project, (Language)dialect, editor2, file);
    }

    public static void setSpecificSyntaxHighlighter(Project project, Language dialect, EditorEx editor2, VirtualFile file) {
        SyntaxHighlighter highlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)dialect, (Project)project, (VirtualFile)file);
        editor2.setHighlighter((EditorHighlighter)new LexerEditorHighlighter(highlighter, editor2.getColorsScheme()));
    }

    public static void setTextFieldLanguage(@NotNull EditorTextField field, @NotNull SqlLanguageDialect dialect) {
        if (field == null) {
            DatabaseDialogsHelper.$$$reportNull$$$0(11);
        }
        if (dialect == null) {
            DatabaseDialogsHelper.$$$reportNull$$$0(12);
        }
        DatabaseDialogsHelper.setTextFieldLanguage(field, dialect, null);
    }

    public static void setTextFieldLanguage(@NotNull EditorTextField field, @NotNull SqlLanguageDialect dialect, @Nullable Function<SqlLanguageDialect, PsiFile> factory) {
        Document document;
        Language lang;
        if (field == null) {
            DatabaseDialogsHelper.$$$reportNull$$$0(13);
        }
        if (dialect == null) {
            DatabaseDialogsHelper.$$$reportNull$$$0(14);
        }
        FileDocumentManager mgr = FileDocumentManager.getInstance();
        VirtualFile prevFile = mgr.getFile(field.getDocument());
        Language language = lang = field.getProject() == null ? null : LanguageUtil.getLanguageForPsi((Project)field.getProject(), (VirtualFile)prevFile);
        if (dialect == lang) {
            return;
        }
        if (factory == null) {
            LightVirtualFile file = new LightVirtualFile("a.sql", (Language)dialect, (CharSequence)field.getText());
            document = mgr.getDocument((VirtualFile)file);
        } else {
            PsiFile psiFile = factory.apply(dialect);
            document = PsiDocumentManager.getInstance((Project)psiFile.getProject()).getDocument(psiFile);
        }
        field.setDocument(document);
    }

    public static void setupEnclosingScrollPane(@NotNull JScrollPane scrollPane) {
        if (scrollPane == null) {
            DatabaseDialogsHelper.$$$reportNull$$$0(15);
        }
        scrollPane.setBorder(null);
        JComponent view = (JComponent)scrollPane.getViewport().getView();
        view.setBorder(DsUiDefaults.DEFAULT_PANEL_BORDER);
        GridLayoutManager layoutManager = (GridLayoutManager)ObjectUtils.tryCast((Object)view.getLayout(), GridLayoutManager.class);
        if (layoutManager != null) {
            layoutManager.setHGap(5);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/DatabaseDialogsHelper";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scrollPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/DatabaseDialogsHelper";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditorTextArea";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditorTextField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createLanguageEditorArea";
                break;
            }
            case 9: 
            case 10: {
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setTextFieldLanguage";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setupEnclosingScrollPane";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 10 -> new IllegalStateException(string);
        };
    }
}

