/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter;

import com.intellij.database.Dbms;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.psi.DbElement;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.common.StringFun;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.sql.actions.NavigationHelper;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.formatter.Change;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.impl.SqlCreateBodyStatementImpl;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.sql.psi.impl.SqlProcedureDefinitionImpl;
import com.intellij.util.DocumentUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000h\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a$\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u001a\u001a\u0010\t\u001a\u00020\u0001*\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002\u001a\u0014\u0010\n\u001a\u00020\u0001*\u00020\u00052\u0006\u0010\u000b\u001a\u00020\bH\u0002\u001a\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u001aC\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0013*\u00020\u00142*\u0010\u0015\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\r0\u00160\u0013\"\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\r0\u0016\u00a2\u0006\u0002\u0010\u0017\u001a\u0014\u0010\u0018\u001a\u0004\u0018\u00010\u00142\b\u0010\u0019\u001a\u0004\u0018\u00010\u0014H\u0002\u001a\u000e\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u0014\u001a\f\u0010\u001b\u001a\u0004\u0018\u00010\u001c*\u00020\u001d\u001a\u0010\u0010\u001e\u001a\u00020\r2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0014\u001a\f\u0010\u001b\u001a\u0004\u0018\u00010\u001c*\u00020 \u001a\u001a\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010!\u001a\u0004\u0018\u00010 2\u0006\u0010\"\u001a\u00020#\u001a\u0012\u0010$\u001a\u0004\u0018\u00010\u001c2\u0006\u0010%\u001a\u00020#H\u0002\"\u0015\u0010&\u001a\u00020\r*\u00020'8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010)\u00a8\u0006*"}, d2={"performModificationInBulk", "", "documentManager", "Lcom/intellij/psi/PsiDocumentManager;", "document", "Lcom/intellij/openapi/editor/Document;", "changes", "", "Lcom/intellij/sql/formatter/Change;", "applyChangesInReversedOrder", "performOneReplacement", "change", "isQuoted", "", "node", "Lcom/intellij/lang/ASTNode;", "namingService", "Lcom/intellij/database/script/generator/NamingService;", "findSubSequence", "", "Lcom/intellij/psi/PsiElement;", "predicates", "Lkotlin/Function1;", "(Lcom/intellij/psi/PsiElement;[Lkotlin/jvm/functions/Function1;)[Lcom/intellij/psi/PsiElement;", "skipSpaces", "element", "whetherKeywordsUpper", "obtainOriginalCase", "", "Lcom/intellij/sql/psi/SqlIdentifier;", "identifierIsBuiltInFunction", "parent", "Lcom/intellij/sql/psi/SqlReferenceExpression;", "refExpr", "symbol", "Lcom/intellij/database/symbols/DasSymbol;", "getNameFromPsiDeclaration", "definition", "toChange", "Lcom/intellij/database/util/Case;", "getToChange", "(Lcom/intellij/database/util/Case;)Z", "intellij.database.sql.core.impl"})
@JvmName(name="SqlPreFormatHelper")
public final class SqlPreFormatHelper {
    public static final void performModificationInBulk(@NotNull PsiDocumentManager documentManager, @NotNull Document document, @NotNull Collection<Change> changes) {
        Intrinsics.checkNotNullParameter((Object)documentManager, (String)"documentManager");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter(changes, (String)"changes");
        DocumentUtil.executeInBulk((Document)document, () -> SqlPreFormatHelper.performModificationInBulk$lambda$0(document, changes));
        if (documentManager.isUncommited(document)) {
            documentManager.commitDocument(document);
        }
    }

    private static final void applyChangesInReversedOrder(Document $this$applyChangesInReversedOrder, Collection<Change> changes) {
        int n = changes.size();
        if (n == 0) {
            return;
        }
        ArrayList<Change> theChanges = new ArrayList<Change>(changes);
        if (n > 1) {
            CollectionsKt.sort((List)theChanges);
        }
        for (int i2 = n - 1; -1 < i2; --i2) {
            Change change = theChanges.get(i2);
            Intrinsics.checkNotNullExpressionValue((Object)change, (String)"get(...)");
            SqlPreFormatHelper.performOneReplacement($this$applyChangesInReversedOrder, change);
        }
    }

    private static final void performOneReplacement(Document $this$performOneReplacement, Change change) {
        String string = $this$performOneReplacement.getText(change.range());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String text2 = string;
        String replacement = change.replacement;
        if (Intrinsics.areEqual((Object)text2, (Object)replacement)) {
            return;
        }
        int from = change.from;
        int till = change.till;
        if ($this$performOneReplacement.getRangeGuard(from, till) == null) {
            $this$performOneReplacement.replaceString(from, till, (CharSequence)replacement);
        }
    }

    public static final boolean isQuoted(@NotNull ASTNode node, @NotNull NamingService namingService) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)namingService, (String)"namingService");
        PsiElement element = node.getPsi();
        if (element instanceof SqlNameElement) {
            bl = ((SqlNameElement)element).isQuotedIdentifier();
        } else {
            String string = node.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            bl = namingService.isQuoted(string);
        }
        return bl;
    }

    @Nullable
    public static final PsiElement[] findSubSequence(@NotNull PsiElement $this$findSubSequence, Function1<? super PsiElement, Boolean> ... predicates) {
        Intrinsics.checkNotNullParameter((Object)$this$findSubSequence, (String)"<this>");
        Intrinsics.checkNotNullParameter(predicates, (String)"predicates");
        int n = predicates.length;
        PsiElement[] found = new PsiElement[n];
        PsiElement p2 = SqlPreFormatHelper.skipSpaces($this$findSubSequence);
        while (p2 != null) {
            PsiElement q = p2;
            for (int i2 = 0; i2 < n; ++i2) {
                boolean ok2 = (Boolean)predicates[i2].invoke((Object)q);
                if (!ok2) break;
                found[i2] = q;
                if (i2 == n - 1) {
                    return found;
                }
                if ((q = SqlPreFormatHelper.skipSpaces(q.getNextSibling())) == null) break;
            }
            p2 = SqlPreFormatHelper.skipSpaces(p2.getNextSibling());
        }
        return null;
    }

    private static final PsiElement skipSpaces(PsiElement element) {
        PsiElement e = element;
        while (e instanceof PsiWhiteSpace) {
            e = ((PsiWhiteSpace)e).getNextSibling();
        }
        return e;
    }

    public static final boolean whetherKeywordsUpper(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement kw = element;
        while (kw.getFirstChild() != null) {
            PsiElement e;
            kw = e;
        }
        String text2 = kw.getText();
        return text2 == null || text2.length() < 2 ? false : Character.isUpperCase(text2.charAt(1));
    }

    @Nullable
    public static final String obtainOriginalCase(@NotNull SqlIdentifier $this$obtainOriginalCase) {
        Intrinsics.checkNotNullParameter((Object)$this$obtainOriginalCase, (String)"<this>");
        PsiElement psiElement = $this$obtainOriginalCase.getParent();
        if (psiElement == null) {
            return null;
        }
        PsiElement parent = psiElement;
        return parent instanceof SqlReferenceExpression ? SqlPreFormatHelper.obtainOriginalCase((SqlReferenceExpression)parent) : $this$obtainOriginalCase.getName();
    }

    public static final boolean identifierIsBuiltInFunction(@Nullable PsiElement parent) {
        SqlReferenceExpression sqlReferenceExpression = parent instanceof SqlReferenceExpression ? (SqlReferenceExpression)parent : null;
        PsiElement psiElement = sqlReferenceExpression != null ? sqlReferenceExpression.getParent() : null;
        SqlFunctionCallExpression sqlFunctionCallExpression = psiElement instanceof SqlFunctionCallExpression ? (SqlFunctionCallExpression)psiElement : null;
        if (sqlFunctionCallExpression == null) {
            return false;
        }
        SqlFunctionCallExpression call = sqlFunctionCallExpression;
        Number n = SqlFunctionsUtil.getSignatureNumber(call);
        if (n != null) {
            return true;
        }
        BuiltinFunction fd = call.getFunctionDefinition();
        return fd != null;
    }

    @Nullable
    public static final String obtainOriginalCase(@NotNull SqlReferenceExpression $this$obtainOriginalCase) {
        Intrinsics.checkNotNullParameter((Object)$this$obtainOriginalCase, (String)"<this>");
        DasSymbol dasSymbol = $this$obtainOriginalCase.resolveSymbol();
        if (dasSymbol == null) {
            return null;
        }
        DasSymbol symbol = dasSymbol;
        return SqlPreFormatHelper.obtainOriginalCase($this$obtainOriginalCase, symbol);
    }

    @Nullable
    public static final String obtainOriginalCase(@Nullable SqlReferenceExpression refExpr, @NotNull DasSymbol symbol) {
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        DasSymbol definition = symbol;
        if (definition instanceof SqlCreateBodyStatementImpl) {
            DasObject dasObject = ((SqlCreateBodyStatementImpl)((Object)definition)).getDasParent();
            SqlDefinition sqlDefinition = dasObject instanceof SqlDefinition ? (SqlDefinition)dasObject : null;
            DasSymbol dasSymbol = definition = sqlDefinition != null ? (DasSymbol)sqlDefinition : definition;
        }
        if (symbol instanceof DbElement) {
            Object object = ((DbElement)symbol).getDelegate();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getDelegate(...)");
            Object symbolDelegate = object;
            if (symbolDelegate instanceof BasicElement) {
                boolean preserves;
                BasicDatabase basicDatabase = ((BasicElement)symbolDelegate).getDatabase();
                if (basicDatabase == null) {
                    return null;
                }
                BasicDatabase db = basicDatabase;
                Casing casing = db.getCasing(((BasicElement)symbolDelegate).getKind(), null);
                Intrinsics.checkNotNullExpressionValue((Object)casing, (String)"getCasing(...)");
                Casing casing2 = casing;
                boolean bl = preserves = casing2.plain == Case.EXACT || casing2.plain == Case.MIXED;
                if (!preserves) {
                    return null;
                }
            }
        }
        String originName = null;
        if (definition instanceof SqlProcedureDefinitionImpl) {
            IElementType parentType;
            PsiElement psiElement = ((SqlProcedureDefinitionImpl)((Object)definition)).getParent();
            Object object = parentType = psiElement != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement) : null;
            if (parentType != null && Intrinsics.areEqual((Object)parentType.toString(), (Object)"ORA_CREATE_PACKAGE_BODY_STATEMENT")) {
                DasObject originOne;
                NavigationHelper nh = NavigationHelper.EP.forDbms(Dbms.ORACLE);
                JBIterable pair = nh.findSuperDefinitions((DasObject)((Object)definition), false);
                JBIterable jBIterable = pair;
                DasObject dasObject = originOne = jBIterable != null && (jBIterable = (JBIterable)jBIterable.second) != null ? (DasObject)jBIterable.first() : null;
                String string = originName = dasObject != null ? dasObject.getName() : null;
            }
        }
        if (originName == null && definition instanceof SqlFileImpl.GroupImpl) {
            SqlDefinition sqlDefinition = (SqlDefinition)((SqlFileImpl.GroupImpl)definition).delegates().first();
            String string = originName = sqlDefinition != null ? sqlDefinition.getName() : null;
        }
        if (originName == null) {
            String string = SqlPreFormatHelper.getNameFromPsiDeclaration(definition);
            if (string == null) {
                String string2 = definition.getName();
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            }
            originName = string;
        }
        if (refExpr == null) {
            return originName;
        }
        String string = refExpr.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String thisName = string;
        return StringsKt.equals((String)originName, (String)thisName, (boolean)true) ? originName : null;
    }

    private static final String getNameFromPsiDeclaration(DasSymbol definition) {
        String oldText;
        PsiNamedElement declarationElement;
        JBIterable<? extends PsiElement> jBIterable = definition.getPsiDeclarations();
        Intrinsics.checkNotNullExpressionValue(jBIterable, (String)"getPsiDeclarations(...)");
        Object object = CollectionsKt.singleOrNull((Iterable)((Iterable)jBIterable));
        PsiNamedElement psiNamedElement = declarationElement = object instanceof PsiNamedElement ? (PsiNamedElement)object : null;
        if (declarationElement == null) {
            return null;
        }
        String declarationName = declarationElement.getName();
        if (declarationName != null && StringFun.firstCharIs(oldText = declarationElement.getText(), '@')) {
            declarationName = StringFun.prefixWith(declarationName, '@');
        }
        return declarationName;
    }

    public static final boolean getToChange(@NotNull Case $this$toChange) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$toChange), (String)"<this>");
        return $this$toChange == Case.LOWER || $this$toChange == Case.UPPER || $this$toChange == Case.TITLE;
    }

    private static final void performModificationInBulk$lambda$0(Document $document, Collection $changes) {
        SqlPreFormatHelper.applyChangesInReversedOrder($document, $changes);
    }
}

