/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dataWrangler.jupyterPython.engine;

import com.intellij.dataWrangler.executor.DataWranglerContext;
import com.intellij.dataWrangler.executor.DataWranglerTransformationStepsManager;
import com.intellij.dataWrangler.impl.fus.DataWranglerInputType;
import com.intellij.dataWrangler.impl.fus.DataWranglerProviderCollector;
import com.intellij.dataWrangler.impl.operations.CommandFactoryBase;
import com.intellij.dataWrangler.impl.operations.DataWranglerTransformationStepsManagerImpl;
import com.intellij.dataWrangler.impl.service.DataWranglerService;
import com.intellij.dataWrangler.impl.service.DataWranglerSessionImpl;
import com.intellij.dataWrangler.impl.view.DWMainPanel;
import com.intellij.dataWrangler.impl.view.DWMainPanelKt;
import com.intellij.dataWrangler.jupyterPython.engine.DataWranglerPythonConsoleManagerKt;
import com.intellij.dataWrangler.jupyterPython.engine.JupyterPyDataWranglerNotebookContext;
import com.intellij.dataWrangler.jupyterPython.engine.PyCodePreviewProvider;
import com.intellij.dataWrangler.jupyterPython.engine.PythonDataWranglerContext;
import com.intellij.dataWrangler.jupyterPython.engine.PythonDataWranglerEngine;
import com.intellij.dataWrangler.jupyterPython.engine.console.PyDataWranglerDatabaseContext;
import com.intellij.dataWrangler.jupyterPython.engine.console.PyDataWranglerLocalTableContext;
import com.intellij.dataWrangler.jupyterPython.operations.HandleOutliersMADFactory;
import com.intellij.dataWrangler.jupyterPython.operations.JupyterOneHotEncodingCommandFactory;
import com.intellij.dataWrangler.jupyterPython.operations.JupyterPyChangeColumnTypeFactory;
import com.intellij.dataWrangler.jupyterPython.operations.JupyterPyDropColFactory;
import com.intellij.dataWrangler.jupyterPython.operations.JupyterPyDropDuplicatesFactory;
import com.intellij.dataWrangler.jupyterPython.operations.JupyterPyDropMissFactory;
import com.intellij.dataWrangler.jupyterPython.operations.JupyterPyDropRowsFactory;
import com.intellij.dataWrangler.jupyterPython.operations.JupyterPyFillMissingValuesFactory;
import com.intellij.dataWrangler.jupyterPython.operations.JupyterPyFilterFactory;
import com.intellij.dataWrangler.jupyterPython.operations.JupyterPyHandleOutliersEDFactory;
import com.intellij.dataWrangler.jupyterPython.operations.JupyterPyHandleOutliersWithIQRFactory;
import com.intellij.dataWrangler.jupyterPython.operations.JupyterPyHandleSkewedFactory;
import com.intellij.dataWrangler.jupyterPython.operations.JupyterPyMinMaxFactory;
import com.intellij.dataWrangler.jupyterPython.operations.JupyterPyRemoveEmptyCommandFactory;
import com.intellij.dataWrangler.jupyterPython.operations.JupyterPyReplaceFactory;
import com.intellij.dataWrangler.jupyterPython.operations.JupyterPyRoundFactory;
import com.intellij.dataWrangler.jupyterPython.operations.JupyterPySplitFactory;
import com.intellij.dataWrangler.jupyterPython.operations.JupyterPyStandardizationFactory;
import com.intellij.dataWrangler.jupyterPython.operations.JupyterStringTransformationCommandFactory;
import com.intellij.dataWrangler.jupyterPython.operations.init.JupyterCopyOutputVariableCommand;
import com.intellij.dataWrangler.jupyterPython.operations.init.PythonCreateDataFrameCommand;
import com.intellij.dataWrangler.jupyterPython.operations.init.PythonDatabaseTableCommand;
import com.intellij.dataWrangler.operations.TransformationStep;
import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.dataSource.DataSourceFun;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DatabaseGridDataHookUp;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.psi.DbDataSource;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.python.scientific.powerfuldataviewer.editor.DataViewVirtualFile;
import com.intellij.scientific.tables.DSDataHookUp;
import com.intellij.scientific.tables.api.DSTableDataType;
import com.intellij.scientific.tables.panel.DSTableKt;
import com.intellij.scientific.tables.panel.DSTableWithStatistics;
import com.intellij.util.PlatformUtils;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u001a\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u001a\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u001a \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0004H\u0001\u001a \u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0004H\u0003\"\"\u0010\u0000\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0006\b\u0001\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\",\u0010\u0005\u001a \u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0007\u0012\u000e\u0012\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00020\u00040\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"PYTHON_COMMANDS", "", "Lcom/intellij/dataWrangler/impl/operations/CommandFactoryBase;", "", "Lcom/intellij/dataWrangler/jupyterPython/engine/PythonDataWranglerContext;", "PYTHON_INIT_COMMAND", "", "Ljava/lang/Class;", "Lcom/intellij/dataWrangler/operations/TransformationStep;", "supportedLibraries", "", "Lcom/intellij/scientific/tables/api/DSTableDataType;", "canCreteNotebookContext", "", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "canCreatePythonLocalTableContext", "canCreatePythonContextFromDatabase", "getOrCreateTable", "Lcom/intellij/dataWrangler/impl/view/DWMainPanel;", "grid", "Lcom/intellij/database/datagrid/DataGrid;", "engine", "Lcom/intellij/dataWrangler/jupyterPython/engine/PythonDataWranglerEngine;", "context", "createMainPanel", "intellij.dataWrangler.jupyterPython"})
@SourceDebugExtension(value={"SMAP\nPythonDataWranglerEngine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PythonDataWranglerEngine.kt\ncom/intellij/dataWrangler/jupyterPython/engine/PythonDataWranglerEngineKt\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,156:1\n31#2,2:157\n*S KotlinDebug\n*F\n+ 1 PythonDataWranglerEngine.kt\ncom/intellij/dataWrangler/jupyterPython/engine/PythonDataWranglerEngineKt\n*L\n152#1:157,2\n*E\n"})
public final class PythonDataWranglerEngineKt {
    @NotNull
    private static final List<CommandFactoryBase<? extends Object, PythonDataWranglerContext>> PYTHON_COMMANDS;
    @NotNull
    private static final Map<Class<? extends PythonDataWranglerContext>, TransformationStep<?, PythonDataWranglerContext>> PYTHON_INIT_COMMAND;
    @NotNull
    private static final Set<DSTableDataType> supportedLibraries;

    public static final boolean canCreteNotebookContext(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        DataGrid dataGrid = GridUtil.getDataGrid((DataContext)dataContext);
        if (dataGrid == null) {
            return false;
        }
        DataGrid dataGrid2 = dataGrid;
        Object object = dataContext.getData(DSTableKt.getDS_TABLE_DATA_KEY());
        DSTableWithStatistics dSTableWithStatistics = object instanceof DSTableWithStatistics ? (DSTableWithStatistics)object : null;
        if (dSTableWithStatistics == null) {
            return false;
        }
        DSTableWithStatistics dsTable = dSTableWithStatistics;
        object = dataContext.getData(CommonDataKeys.VIRTUAL_FILE);
        DataViewVirtualFile dataViewVirtualFile = object instanceof DataViewVirtualFile ? (DataViewVirtualFile)object : null;
        GridDataHookUp gridDataHookUp = dataGrid2.getDataHookup();
        DSDataHookUp dSDataHookUp = gridDataHookUp instanceof DSDataHookUp ? (DSDataHookUp)gridDataHookUp : null;
        if (dSDataHookUp == null || (dSDataHookUp = dSDataHookUp.getLoader()) == null || (dSDataHookUp = dSDataHookUp.getTableDataRetrieverFromDataSource()) == null) {
            return false;
        }
        DSDataHookUp tableDataRetriever = dSDataHookUp;
        Object object2 = tableDataRetriever.getPanelInfo().getEditor();
        if (object2 == null) {
            DataViewVirtualFile dataViewVirtualFile2 = dataViewVirtualFile;
            object2 = dataViewVirtualFile2 != null ? dataViewVirtualFile2.getOriginalEditor() : null;
            if (object2 == null) {
                return false;
            }
        }
        if (!CollectionsKt.contains((Iterable)supportedLibraries, (Object)tableDataRetriever.getTableType())) {
            return false;
        }
        return dsTable.getDSTableCommandExecutor() != null;
    }

    public static final boolean canCreatePythonLocalTableContext(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        DataGrid dataGrid = GridUtil.getDataGrid((DataContext)dataContext);
        if (dataGrid == null) {
            return false;
        }
        DataGrid dataGrid2 = dataGrid;
        VirtualFile virtualFile = GridUtil.getVirtualFile((GridDataHookUp)dataGrid2.getDataHookup());
        if (virtualFile == null) {
            return false;
        }
        VirtualFile file = virtualFile;
        return CollectionsKt.contains((Iterable)DataWranglerPythonConsoleManagerKt.getSupportedXLSFileExtensions(), (Object)file.getExtension()) || CollectionsKt.contains((Iterable)DataWranglerPythonConsoleManagerKt.getSupportedCSVFileExtensions(), (Object)file.getExtension());
    }

    public static final boolean canCreatePythonContextFromDatabase(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        if (!PlatformUtils.isDataSpell()) {
            return false;
        }
        DataGrid dataGrid = (DataGrid)dataContext.getData(DatabaseDataKeys.DATA_GRID_KEY);
        if (dataGrid == null) {
            return false;
        }
        DataGrid dataGrid2 = dataGrid;
        GridDataHookUp gridDataHookUp = dataGrid2.getDataHookup();
        DatabaseGridDataHookUp databaseGridDataHookUp = gridDataHookUp instanceof DatabaseGridDataHookUp ? (DatabaseGridDataHookUp)gridDataHookUp : null;
        if (databaseGridDataHookUp == null) {
            return false;
        }
        DatabaseGridDataHookUp loader = databaseGridDataHookUp;
        if (loader.getQueryText() == null) {
            return false;
        }
        DbDataSource dbDataSource = loader.getDataSource();
        Intrinsics.checkNotNullExpressionValue((Object)dbDataSource, (String)"getDataSource(...)");
        return DataSourceFun.getLocalDataSource((DasDataSource)((DasDataSource)dbDataSource)) != null;
    }

    @RequiresEdt
    @NotNull
    public static final DWMainPanel getOrCreateTable(@NotNull DataGrid grid2, @NotNull PythonDataWranglerEngine engine, @NotNull PythonDataWranglerContext context) {
        Intrinsics.checkNotNullParameter((Object)grid2, (String)"grid");
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        DWMainPanel dWMainPanel = (DWMainPanel)((Object)grid2.getUserData(DWMainPanelKt.DATA_WRANGLER_GRID_KEY));
        if (dWMainPanel == null) {
            dWMainPanel = PythonDataWranglerEngineKt.createMainPanel(grid2, engine, context);
        }
        return dWMainPanel;
    }

    @RequiresEdt
    private static final DWMainPanel createMainPanel(DataGrid grid2, PythonDataWranglerEngine engine, PythonDataWranglerContext context) {
        DataWranglerTransformationStepsManagerImpl<DataWranglerContext> transformationManager = DataWranglerTransformationStepsManagerImpl.Companion.createDefault((DataWranglerContext)context);
        PyCodePreviewProvider previewProvider = engine.getPreviewProvider();
        Project project = grid2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<DataWranglerService> serviceClass$iv = DataWranglerService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        CoroutineScope coroutineScope = ((DataWranglerService)object).getCoroutineScope();
        DataWranglerSessionImpl<DataWranglerContext> session = new DataWranglerSessionImpl<DataWranglerContext>(coroutineScope, engine, (DataWranglerTransformationStepsManager)transformationManager, previewProvider, context);
        DataWranglerProviderCollector.INSTANCE.logDWOpened(context instanceof PyDataWranglerLocalTableContext ? DataWranglerInputType.LOCAL_FILE : DataWranglerInputType.PYTHON_VARIABLE);
        return new DWMainPanel(grid2, session);
    }

    public static final /* synthetic */ Set access$getSupportedLibraries$p() {
        return supportedLibraries;
    }

    public static final /* synthetic */ List access$getPYTHON_COMMANDS$p() {
        return PYTHON_COMMANDS;
    }

    public static final /* synthetic */ Map access$getPYTHON_INIT_COMMAND$p() {
        return PYTHON_INIT_COMMAND;
    }

    static {
        Object[] objectArray = new CommandFactoryBase[]{new JupyterPyFilterFactory(), new JupyterPyDropColFactory(), new JupyterPyDropDuplicatesFactory(), new JupyterPyDropMissFactory(), new JupyterPyReplaceFactory(), new JupyterPyRemoveEmptyCommandFactory(), new JupyterStringTransformationCommandFactory(), new JupyterOneHotEncodingCommandFactory(), new JupyterPyDropRowsFactory(), new JupyterPyFillMissingValuesFactory(), new JupyterPyMinMaxFactory(), new JupyterPyStandardizationFactory(), new JupyterPyRoundFactory(), new JupyterPyHandleOutliersWithIQRFactory(), new JupyterPySplitFactory(), new JupyterPyHandleSkewedFactory(), new JupyterPyChangeColumnTypeFactory(), new HandleOutliersMADFactory(), new JupyterPyHandleOutliersEDFactory()};
        PYTHON_COMMANDS = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new Pair[]{TuplesKt.to(PyDataWranglerLocalTableContext.class, PythonCreateDataFrameCommand.Companion.createStep()), TuplesKt.to(JupyterPyDataWranglerNotebookContext.class, JupyterCopyOutputVariableCommand.Companion.createStep()), TuplesKt.to(PyDataWranglerDatabaseContext.class, PythonDatabaseTableCommand.Companion.createStep())};
        PYTHON_INIT_COMMAND = MapsKt.mapOf((Pair[])objectArray);
        supportedLibraries = SetsKt.setOf((Object)DSTableDataType.PANDAS_DATA_FRAME);
    }
}

